/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.ui;

import java.awt.Color;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicInternalFrameUI;
import org.pushingpixels.substance.internal.ui.SubstanceDesktopIconUI;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceInternalFrameTitlePane;

public class SubstanceInternalFrameUI
extends BasicInternalFrameUI {
    private SubstanceInternalFrameTitlePane titlePane;
    protected PropertyChangeListener substancePropertyListener;

    public SubstanceInternalFrameUI(JInternalFrame b) {
        super(b);
    }

    public static ComponentUI createUI(JComponent comp) {
        SubstanceCoreUtilities.testComponentCreationThreadingViolation(comp);
        return new SubstanceInternalFrameUI((JInternalFrame)comp);
    }

    @Override
    protected JComponent createNorthPane(JInternalFrame w) {
        this.titlePane = new SubstanceInternalFrameTitlePane(w);
        return this.titlePane;
    }

    @Override
    protected void uninstallComponents() {
        this.titlePane.uninstall();
        super.uninstallComponents();
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.substancePropertyListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Color newBackgr;
                SubstanceDesktopIconUI ui;
                JInternalFrame.JDesktopIcon jdi;
                if ("closed".equals(evt.getPropertyName())) {
                    SubstanceInternalFrameUI.this.titlePane.uninstall();
                    jdi = SubstanceInternalFrameUI.this.frame.getDesktopIcon();
                    ui = (SubstanceDesktopIconUI)jdi.getUI();
                    ui.uninstallIfNecessary(jdi);
                }
                if ("background".equals(evt.getPropertyName()) && !((newBackgr = (Color)evt.getNewValue()) instanceof UIResource)) {
                    SubstanceInternalFrameUI.this.getTitlePane().setBackground(newBackgr);
                    SubstanceInternalFrameUI.this.frame.getDesktopIcon().setBackground(newBackgr);
                }
                if ("ancestor".equals(evt.getPropertyName())) {
                    jdi = SubstanceInternalFrameUI.this.frame.getDesktopIcon();
                    ui = (SubstanceDesktopIconUI)jdi.getUI();
                    ui.installIfNecessary(jdi);
                }
            }
        };
        this.frame.addPropertyChangeListener(this.substancePropertyListener);
    }

    @Override
    protected void uninstallListeners() {
        this.frame.removePropertyChangeListener(this.substancePropertyListener);
        this.substancePropertyListener = null;
        super.uninstallListeners();
    }

    public SubstanceInternalFrameTitlePane getTitlePane() {
        return this.titlePane;
    }

    void setWindowModified(boolean isWindowModified) {
        this.titlePane.getCloseButton().putClientProperty("windowModified", isWindowModified);
        SubstanceDesktopIconUI desktopIconUi = (SubstanceDesktopIconUI)this.frame.getDesktopIcon().getUI();
        desktopIconUi.setWindowModified(isWindowModified);
    }
}

