/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicOptionPaneUI;
import org.pushingpixels.lafwidget.animation.AnimationConfigurationManager;
import org.pushingpixels.lafwidget.animation.AnimationFacet;
import org.pushingpixels.substance.api.SubstanceLookAndFeel;
import org.pushingpixels.substance.internal.animation.IconGlowTracker;
import org.pushingpixels.substance.internal.painter.BackgroundPaintingUtils;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;
import org.pushingpixels.substance.internal.utils.icon.GlowingIcon;

public class SubstanceOptionPaneUI
extends BasicOptionPaneUI {
    private OptionPaneLabel substanceIconLabel;
    private IconGlowTracker iconGlowTracker;

    static {
        AnimationConfigurationManager.getInstance().allowAnimations(AnimationFacet.ICON_GLOW, OptionPaneLabel.class);
    }

    public static ComponentUI createUI(JComponent comp) {
        SubstanceCoreUtilities.testComponentCreationThreadingViolation(comp);
        return new SubstanceOptionPaneUI();
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        BackgroundPaintingUtils.updateIfOpaque(g, c);
    }

    @Override
    protected void addIcon(Container top) {
        Icon sideIcon;
        Icon icon = sideIcon = this.optionPane == null ? null : this.optionPane.getIcon();
        if (sideIcon == null && this.optionPane != null) {
            sideIcon = super.getIconForType(this.optionPane.getMessageType());
        }
        if (sideIcon != null) {
            if (!SubstanceLookAndFeel.isToUseConstantThemesOnDialogs()) {
                sideIcon = SubstanceCoreUtilities.getThemedIcon(null, sideIcon);
            }
            this.substanceIconLabel = new OptionPaneLabel();
            this.iconGlowTracker = new IconGlowTracker(this.substanceIconLabel);
            this.substanceIconLabel.setIcon(new GlowingIcon(sideIcon, this.iconGlowTracker));
            this.substanceIconLabel.setName("OptionPane.iconLabel");
            this.substanceIconLabel.setVerticalAlignment(1);
            top.add((Component)this.substanceIconLabel, "Before");
        }
    }

    @Override
    protected Icon getIconForType(int messageType) {
        switch (messageType) {
            case 0: {
                return SubstanceCoreUtilities.getIcon("resource/32/dialog-error.png");
            }
            case 1: {
                return SubstanceCoreUtilities.getIcon("resource/32/dialog-information.png");
            }
            case 2: {
                return SubstanceCoreUtilities.getIcon("resource/32/dialog-warning.png");
            }
            case 3: {
                return SubstanceCoreUtilities.getIcon("resource/32/help-browser.png");
            }
        }
        return null;
    }

    @Override
    protected void installComponents() {
        super.installComponents();
        if (this.substanceIconLabel != null && !this.iconGlowTracker.isPlaying()) {
            this.iconGlowTracker.play(3);
        }
    }

    protected static class OptionPaneLabel
    extends JLabel {
        protected OptionPaneLabel() {
        }
    }
}

