/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.swingx;

import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Window;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.image.BufferedImage;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import org.jdesktop.swingx.JXLoginPane;
import org.jdesktop.swingx.plaf.basic.BasicLoginPaneUI;
import org.pushingpixels.lafwidget.LafWidget;
import org.pushingpixels.lafwidget.LafWidgetRepository;
import org.pushingpixels.lafwidget.utils.RenderingUtils;
import org.pushingpixels.substance.api.DecorationAreaType;
import org.pushingpixels.substance.api.SubstanceLookAndFeel;
import org.pushingpixels.substance.internal.painter.BackgroundPaintingUtils;
import org.pushingpixels.substance.internal.painter.DecorationPainterUtils;
import org.pushingpixels.substance.internal.utils.SubstanceColorUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;

public class SubstanceLoginPaneUI
extends BasicLoginPaneUI {
    protected Set lafWidgets;
    protected JXLoginPane loginPanel;
    protected HierarchyListener substanceHierarchyListener;

    public void installUI(JComponent jComponent) {
        this.lafWidgets = LafWidgetRepository.getRepository().getMatchingWidgets(jComponent);
        this.__org__pushingpixels__substance__swingx__SubstanceLoginPaneUI__installUI(jComponent);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installUI();
        }
    }

    public void uninstallUI(JComponent jComponent) {
        this.__org__pushingpixels__substance__swingx__SubstanceLoginPaneUI__uninstallUI(jComponent);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallUI();
        }
    }

    protected void __org__pushingpixels__substance__swingx__SubstanceLoginPaneUI__installDefaults() {
        super.installDefaults();
    }

    protected void installDefaults() {
        this.__org__pushingpixels__substance__swingx__SubstanceLoginPaneUI__installDefaults();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installDefaults();
        }
    }

    public void __org__pushingpixels__substance__swingx__SubstanceLoginPaneUI__update(Graphics graphics, JComponent jComponent) {
        super.update(graphics, jComponent);
    }

    public void update(Graphics graphics, JComponent jComponent) {
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        RenderingUtils.installDesktopHints((Graphics2D)graphics2D, (Component)jComponent);
        this.__org__pushingpixels__substance__swingx__SubstanceLoginPaneUI__update(graphics2D, jComponent);
        graphics2D.dispose();
    }

    public static ComponentUI createUI(JComponent comp) {
        SubstanceCoreUtilities.testComponentCreationThreadingViolation(comp);
        return new SubstanceLoginPaneUI((JXLoginPane)comp);
    }

    public SubstanceLoginPaneUI(JXLoginPane dlg) {
        super(dlg);
        this.loginPanel = dlg;
    }

    public void __org__pushingpixels__substance__swingx__SubstanceLoginPaneUI__installUI(JComponent c) {
        super.installUI(c);
        this.substanceHierarchyListener = new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JComponent titlePane;
                        Window window = SwingUtilities.getWindowAncestor((Component)SubstanceLoginPaneUI.this.loginPanel);
                        if (window != null && (titlePane = SubstanceLookAndFeel.getTitlePaneComponent(window)) != null) {
                            titlePane.putClientProperty("substancelaf.watermark.visible", Boolean.FALSE);
                        }
                        SubstanceLoginPaneUI.this.loginPanel.setBanner(SubstanceLoginPaneUI.this.getBanner());
                    }
                });
            }
        };
        this.loginPanel.addHierarchyListener(this.substanceHierarchyListener);
    }

    public void __org__pushingpixels__substance__swingx__SubstanceLoginPaneUI__uninstallUI(JComponent c) {
        this.loginPanel.removeHierarchyListener(this.substanceHierarchyListener);
        this.substanceHierarchyListener = null;
        super.uninstallUI(c);
    }

    public Image getBanner() {
        Image superResult = super.getBanner();
        if (this.loginPanel.getParent() == null) {
            return superResult;
        }
        int width = superResult.getWidth(null);
        int height = superResult.getHeight(null);
        BufferedImage result = SubstanceCoreUtilities.getBlankImage(width, height);
        Graphics2D graphics = (Graphics2D)result.getGraphics();
        Icon origIcon = SubstanceCoreUtilities.getIcon("resource/32/login-new32.png");
        origIcon = SubstanceCoreUtilities.getThemedIcon((Component)this.loginPanel, origIcon);
        SubstanceLookAndFeel.setDecorationType((JComponent)this.loginPanel, DecorationAreaType.HEADER);
        BackgroundPaintingUtils.update(graphics, (Component)this.loginPanel, true);
        DecorationPainterUtils.clearDecorationType((JComponent)this.loginPanel);
        float loginStringX = (float)(origIcon.getIconWidth() + 8) + (float)width * 0.05f;
        float loginStringY = (float)height * 0.75f;
        Font font = UIManager.getFont("JXLoginPane.bannerFont");
        graphics.setFont(font);
        Graphics2D originalGraphics = graphics;
        if (!this.loginPanel.getComponentOrientation().isLeftToRight()) {
            originalGraphics = (Graphics2D)graphics.create();
            graphics.scale(-1.0, 1.0);
            graphics.translate(-width, 0);
            loginStringX = (float)(width - origIcon.getIconWidth() - 8) - ((float)font.getStringBounds(this.loginPanel.getBannerText(), originalGraphics.getFontRenderContext()).getWidth() + (float)width * 0.05f);
        }
        RenderingUtils.installDesktopHints((Graphics2D)graphics, (Component)this.loginPanel);
        originalGraphics.setColor(SubstanceColorUtilities.getForegroundColor(SubstanceCoreUtilities.getSkin((Component)this.loginPanel).getEnabledColorScheme(DecorationAreaType.HEADER)));
        originalGraphics.drawString(this.loginPanel.getBannerText(), loginStringX, loginStringY);
        int iconY = (height - origIcon.getIconHeight()) / 2;
        if (!this.loginPanel.getComponentOrientation().isLeftToRight()) {
            origIcon.paintIcon((Component)this.loginPanel, graphics, width - origIcon.getIconWidth() - 8, iconY);
        } else {
            origIcon.paintIcon((Component)this.loginPanel, graphics, 8, iconY);
        }
        return result;
    }
}

