/*
 * Decompiled with CFR 0.152.
 */
package test;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.net.URL;
import java.util.EnumSet;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.FontUIResource;
import org.pushingpixels.lafwidget.tabbed.DefaultTabPreviewPainter;
import org.pushingpixels.lafwidget.utils.LafConstants;
import org.pushingpixels.substance.api.SubstanceConstants;
import org.pushingpixels.substance.api.SubstanceLookAndFeel;
import org.pushingpixels.substance.api.fonts.FontSet;
import org.pushingpixels.substance.api.skin.SubstanceGeminiLookAndFeel;
import test.check.Controllable;
import test.check.Deferrable;

public class Check
extends JFrame {
    private JTabbedPane jtp;
    private MyMainTabPreviewPainter mainTabPreviewPainter;
    private JToolBar toolbar;

    public Check() {
        super("Substance test with very very very very very very very very very very very very very very long title");
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                boolean hasLafSpecified = false;
                try {
                    hasLafSpecified = System.getProperty("swing.defaultlaf") != null;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                try {
                    if (!hasLafSpecified) {
                        Check.out(" CREATING LAF ");
                        long time0 = System.currentTimeMillis();
                        SubstanceGeminiLookAndFeel laf = new SubstanceGeminiLookAndFeel();
                        long time1 = System.currentTimeMillis();
                        Check.out(" LAF CREATED " + (time1 - time0));
                        Check.out(" SETTING LAF ");
                        long time2 = System.currentTimeMillis();
                        UIManager.setLookAndFeel(laf);
                        long time3 = System.currentTimeMillis();
                        Check.out(" LAF SET " + (time3 - time2));
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                SubstanceLookAndFeel.setToUseConstantThemesOnDialogs(true);
                UIManager.put("substancelaf.tabbedpanehasclosebuttons", Boolean.TRUE);
                UIManager.put("substancelaf.addWidgets", Boolean.TRUE);
                JFrame.setDefaultLookAndFeelDecorated(true);
                JDialog.setDefaultLookAndFeelDecorated(true);
                long time2 = System.currentTimeMillis();
                Check c = new Check();
                c.addComponentListener(new ComponentAdapter(){

                    @Override
                    public void componentResized(ComponentEvent e) {
                        super.componentResized(e);
                        ((JFrame)e.getComponent()).getRootPane().repaint();
                    }
                });
                c.setPreferredSize(new Dimension(820, 560));
                c.setMinimumSize(new Dimension(150, 100));
                c.pack();
                Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
                c.setLocation((d.width - c.getWidth()) / 2, (d.height - c.getHeight()) / 2);
                c.setVisible(true);
                c.setDefaultCloseOperation(System.getProperty("javawebstart.version") != null ? 3 : 2);
                long time3 = System.currentTimeMillis();
                Check.out("App " + (time3 - time2));
            }
        });
    }

    public static void out(Object obj) {
        try {
            System.out.println(obj);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static Icon getIcon(String iconName) {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        URL url = cl.getResource("test/check/icons/" + iconName + ".gif");
        if (url != null) {
            return new ImageIcon(url);
        }
        url = cl.getResource("test/check/icons/" + iconName + ".png");
        if (url != null) {
            return new ImageIcon(url);
        }
        return null;
    }

    public static JToolBar getToolbar(String label, int size, boolean hasStrings) {
        JToolBar toolBar = new JToolBar();
        JButton buttonCut = new JButton(hasStrings ? "cut" : null, Check.getIcon(String.valueOf(size) + "/edit-cut"));
        buttonCut.putClientProperty("substancelaf.buttonnominsize", Boolean.TRUE);
        toolBar.add(buttonCut);
        JButton buttonCopy = new JButton(hasStrings ? "copy" : null, Check.getIcon(String.valueOf(size) + "/edit-copy"));
        buttonCopy.putClientProperty("substancelaf.buttonnominsize", Boolean.TRUE);
        buttonCopy.setEnabled(false);
        toolBar.add(buttonCopy);
        JButton buttonPaste = new JButton(Check.getIcon(String.valueOf(size) + "/edit-paste"));
        toolBar.add(buttonPaste);
        JButton buttonSelectAll = new JButton(Check.getIcon(String.valueOf(size) + "/edit-select-all"));
        toolBar.add(buttonSelectAll);
        JButton buttonDelete = new JButton(Check.getIcon(String.valueOf(size) + "/edit-delete"));
        toolBar.add(buttonDelete);
        toolBar.addSeparator();
        JToolBar innerToolbar = new JToolBar(0);
        innerToolbar.setFloatable(false);
        JToggleButton buttonFormatCenter = new JToggleButton(Check.getIcon(String.valueOf(size) + "/format-justify-center"));
        buttonFormatCenter.putClientProperty("substancelaf.cornerRadius", Float.valueOf(5.0f));
        innerToolbar.add(buttonFormatCenter);
        JToggleButton buttonFormatLeft = new JToggleButton(Check.getIcon(String.valueOf(size) + "/format-justify-left"));
        innerToolbar.add(buttonFormatLeft);
        JToggleButton buttonFormatRight = new JToggleButton(Check.getIcon(String.valueOf(size) + "/format-justify-right"));
        innerToolbar.add(buttonFormatRight);
        JToggleButton buttonFormatFill = new JToggleButton(Check.getIcon(String.valueOf(size) + "/format-justify-fill"));
        buttonFormatFill.putClientProperty("substancelaf.cornerRadius", Float.valueOf(0.0f));
        innerToolbar.add(buttonFormatFill);
        toolBar.add(innerToolbar);
        toolBar.addSeparator();
        if (size > 20) {
            JToolBar innerToolbar2 = new JToolBar(0);
            innerToolbar2.setFloatable(false);
            JPanel innerPanel = new JPanel(new FlowLayout(0, 0, 0));
            innerToolbar2.add((Component)innerPanel, "Center");
            JToggleButton buttonStyleBold = new JToggleButton(Check.getIcon(String.valueOf(size) + "/format-text-bold"));
            EnumSet<SubstanceConstants.Side> rightSide = EnumSet.of(SubstanceConstants.Side.RIGHT);
            buttonStyleBold.putClientProperty("substancelaf.buttonopenSide", rightSide);
            buttonStyleBold.putClientProperty("substancelaf.cornerRadius", Float.valueOf(3.0f));
            JToggleButton buttonStyleItalic = new JToggleButton(Check.getIcon(String.valueOf(size) + "/format-text-italic"));
            buttonStyleItalic.putClientProperty("substancelaf.cornerRadius", Float.valueOf(0.0f));
            buttonStyleItalic.putClientProperty("substancelaf.buttonopenSide", rightSide);
            JToggleButton buttonStyleUnderline = new JToggleButton(Check.getIcon(String.valueOf(size) + "/format-text-underline"));
            buttonStyleUnderline.putClientProperty("substancelaf.cornerRadius", Float.valueOf(0.0f));
            buttonStyleUnderline.putClientProperty("substancelaf.buttonopenSide", rightSide);
            JToggleButton buttonStyleStrikethrough = new JToggleButton(Check.getIcon(String.valueOf(size) + "/format-text-strikethrough"));
            buttonStyleStrikethrough.putClientProperty("substancelaf.buttonside", EnumSet.of(SubstanceConstants.Side.LEFT));
            buttonStyleStrikethrough.putClientProperty("substancelaf.cornerRadius", Float.valueOf(3.0f));
            buttonStyleBold.setSelected(true);
            innerPanel.add(buttonStyleBold);
            innerPanel.add(buttonStyleItalic);
            innerPanel.add(buttonStyleUnderline);
            innerPanel.add(buttonStyleStrikethrough);
            toolBar.add(innerToolbar2);
        }
        toolBar.add(Box.createGlue());
        JButton buttonExit = new JButton(Check.getIcon(String.valueOf(size) + "/process-stop"));
        buttonExit.setToolTipText("Closes the test application");
        buttonExit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.exit(0);
            }
        });
        toolBar.add(buttonExit);
        return toolBar;
    }

    public void setSpecificTaskPane(JPanel contents, String title, Icon icon) {
    }

    public void clearSpecificTaskPane() {
    }

    public JTabbedPane getMainTabbedPane() {
        return this.jtp;
    }

    public static class MyMainTabPreviewPainter
    extends DefaultTabPreviewPainter {
        protected LafConstants.TabOverviewKind tabOverviewKind;

        public void setTabOverviewKind(LafConstants.TabOverviewKind tabOverviewKind) {
            this.tabOverviewKind = tabOverviewKind;
        }

        public LafConstants.TabOverviewKind getOverviewKind(JTabbedPane tabPane) {
            if (this.tabOverviewKind == null) {
                return super.getOverviewKind(tabPane);
            }
            return this.tabOverviewKind;
        }
    }

    public class TabSwitchListener
    implements ChangeListener {
        @Override
        public void stateChanged(ChangeEvent e) {
            Deferrable deferrable;
            Component selected = Check.this.jtp.getSelectedComponent();
            if (selected instanceof Deferrable && !(deferrable = (Deferrable)((Object)selected)).isInitialized()) {
                deferrable.initialize();
            }
            if (selected instanceof Controllable) {
                JPanel controlPanel = ((Controllable)((Object)selected)).getControlPanel();
                if (controlPanel == null) {
                    Check.this.clearSpecificTaskPane();
                } else {
                    Check.this.setSpecificTaskPane(controlPanel, Check.this.jtp.getTitleAt(Check.this.jtp.getSelectedIndex()), Check.this.jtp.getIconAt(Check.this.jtp.getSelectedIndex()));
                }
            } else {
                Check.this.clearSpecificTaskPane();
            }
        }
    }

    private static class WrapperFontSet
    implements FontSet {
        private int extra;
        private FontSet delegate;

        public WrapperFontSet(FontSet delegate, int extra) {
            this.delegate = delegate;
            this.extra = extra;
        }

        private FontUIResource getWrappedFont(FontUIResource systemFont) {
            return new FontUIResource(systemFont.getFontName(), systemFont.getStyle(), systemFont.getSize() + this.extra);
        }

        @Override
        public FontUIResource getControlFont() {
            return this.getWrappedFont(this.delegate.getControlFont());
        }

        @Override
        public FontUIResource getMenuFont() {
            return this.getWrappedFont(this.delegate.getMenuFont());
        }

        @Override
        public FontUIResource getMessageFont() {
            return this.getWrappedFont(this.delegate.getMessageFont());
        }

        @Override
        public FontUIResource getSmallFont() {
            return this.getWrappedFont(this.delegate.getSmallFont());
        }

        @Override
        public FontUIResource getTitleFont() {
            return this.getWrappedFont(this.delegate.getTitleFont());
        }

        @Override
        public FontUIResource getWindowTitleFont() {
            return this.getWrappedFont(this.delegate.getWindowTitleFont());
        }
    }
}

