/*
 * Decompiled with CFR 0.152.
 */
package test.check;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Rectangle;
import java.text.DecimalFormat;
import java.util.Enumeration;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JDesktopPane;
import javax.swing.JEditorPane;
import javax.swing.JFormattedTextField;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.JToggleButton;
import javax.swing.JTree;
import javax.swing.SpinnerListModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import test.Check;
import test.check.CheckeredPanel;
import test.check.Deferrable;
import test.check.ScrollablePanel;
import test.check.command.BackgroundColorCommand;
import test.check.command.ChainCommand;
import test.check.command.ClientPropertyCommand;
import test.check.command.ConfigurationCommand;
import test.check.command.CreationCommand;
import test.check.command.DisableCommand;
import test.check.command.DisableViewportCommand;
import test.check.command.ForegroundColorCommand;
import test.check.command.MinimizeInternalFrameCommand;
import test.check.command.SelectCommand;
import test.check.command.SetBoundsCommand;

public class ColorizedControlsPanel
extends JPanel
implements Deferrable {
    public JButton defaultButton;
    private boolean isInitialized;

    @Override
    public boolean isInitialized() {
        return this.isInitialized;
    }

    private AbstractButton[] getRow() {
        AbstractButton[] result = new AbstractButton[]{new JButton("sample"), new JToggleButton("sample"), new JCheckBox("sample"), new JRadioButton("sample")};
        return result;
    }

    private void addButtonRow(DefaultFormBuilder builder, String label, Icon icon, ConfigurationCommand<Component> configurationCmd) {
        int n;
        AbstractButton[] row = this.getRow();
        if (configurationCmd != null) {
            AbstractButton[] abstractButtonArray = row;
            n = row.length;
            int n2 = 0;
            while (n2 < n) {
                AbstractButton ab = abstractButtonArray[n2];
                configurationCmd.configure(ab);
                ab.setName(String.valueOf(label) + " " + ab.getClass().getSimpleName());
                ++n2;
            }
        }
        JLabel jl = new JLabel(label);
        if (icon != null) {
            jl.setIcon(icon);
        }
        builder.append(jl);
        AbstractButton[] abstractButtonArray = row;
        int n3 = row.length;
        n = 0;
        while (n < n3) {
            AbstractButton ab = abstractButtonArray[n];
            builder.append(ab);
            ++n;
        }
    }

    private void addControlRow(DefaultFormBuilder builder, String label, CreationCommand<Component> creationCmd, ConfigurationCommand<Component> configurationCmd) {
        int n;
        Component[] row = new Component[4];
        row[0] = creationCmd.create();
        row[0].setBackground(Color.yellow);
        row[0].setName(String.valueOf(row[0].getName()) + ": yellow backgr");
        row[1] = creationCmd.create();
        row[1].setBackground(Color.blue);
        row[1].setForeground(Color.red);
        row[1].setName(String.valueOf(row[1].getName()) + ": blue backgr, red foregr");
        row[2] = creationCmd.create();
        row[2].setBackground(Color.green);
        row[2].setName(String.valueOf(row[2].getName()) + ": green backgr");
        row[3] = creationCmd.create();
        row[3].setBackground(Color.green.darker());
        row[3].setName(String.valueOf(row[3].getName()) + ": darker green backgr");
        if (configurationCmd != null) {
            Component[] componentArray = row;
            n = row.length;
            int n2 = 0;
            while (n2 < n) {
                Component comp = componentArray[n2];
                configurationCmd.configure(comp);
                ++n2;
            }
        }
        JLabel jl = new JLabel(label);
        builder.append(jl);
        Component[] componentArray = row;
        int n3 = row.length;
        n = 0;
        while (n < n3) {
            Component comp = componentArray[n];
            builder.append(comp);
            ++n;
        }
    }

    private void addInternalFrame(JDesktopPane desktopPane, CreationCommand creationCommand, ConfigurationCommand<Component> configCommand) {
        JInternalFrame jif = (JInternalFrame)creationCommand.create();
        desktopPane.add(jif);
        configCommand.configure(jif);
    }

    public ColorizedControlsPanel() {
        this.setLayout(new BorderLayout());
    }

    @Override
    public synchronized void initialize() {
        FormLayout lmButtons = new FormLayout("right:pref, 10dlu, left:pref:grow(1), 4dlu,left:pref:grow(1), 4dlu, left:pref:grow(1), 4dlu, left:pref:grow(1)", "");
        lmButtons.setColumnGroups(new int[][]{{3, 5, 7, 9}});
        DefaultFormBuilder builderButtons = new DefaultFormBuilder(lmButtons, new ScrollablePanel());
        builderButtons.setDefaultDialogBorder();
        builderButtons.append("");
        JLabel bLabel = new JLabel("Buttons");
        bLabel.setIcon(Check.getIcon("JButtonColor16"));
        JLabel tbLabel = new JLabel("Toggle buttons");
        tbLabel.setIcon(Check.getIcon("JToggleButtonColor16"));
        JLabel cbLabel = new JLabel("Check boxes");
        cbLabel.setIcon(Check.getIcon("JCheckBoxColor16"));
        JLabel rbLabel = new JLabel("Radio buttons");
        rbLabel.setIcon(Check.getIcon("JRadioButtonColor16"));
        builderButtons.append((Component)bLabel, (Component)tbLabel);
        builderButtons.append((Component)cbLabel, (Component)rbLabel);
        builderButtons.appendSeparator("Regular settings");
        this.addButtonRow(builderButtons, "Enabled", null, null);
        this.addButtonRow(builderButtons, "Flat", null, new ClientPropertyCommand("substancelaf.componentFlat", Boolean.TRUE));
        this.addButtonRow(builderButtons, "Disabled", null, new DisableCommand());
        this.addButtonRow(builderButtons, "Selected", null, new SelectCommand());
        this.addButtonRow(builderButtons, "Disabled selected", null, new ChainCommand<Component>(new DisableCommand(), new SelectCommand()));
        builderButtons.appendSeparator("Background settings");
        this.addButtonRow(builderButtons, "Yellow", null, new BackgroundColorCommand(Color.yellow));
        this.addButtonRow(builderButtons, "Yellow flat", null, new ChainCommand<Component>(new BackgroundColorCommand(Color.yellow), new ClientPropertyCommand("substancelaf.componentFlat", Boolean.TRUE)));
        this.addButtonRow(builderButtons, "Yellow disabled", null, new ChainCommand<Component>(new BackgroundColorCommand(Color.yellow), new DisableCommand()));
        this.addButtonRow(builderButtons, "Yellow selected", null, new ChainCommand<Component>(new BackgroundColorCommand(Color.yellow), new SelectCommand()));
        this.addButtonRow(builderButtons, "Yellow disabled selected", null, new ChainCommand<Component>(new BackgroundColorCommand(Color.yellow), new SelectCommand(), new DisableCommand()));
        this.addButtonRow(builderButtons, "Red", null, new BackgroundColorCommand(Color.red));
        this.addButtonRow(builderButtons, "Red disabled", null, new ChainCommand<Component>(new BackgroundColorCommand(Color.red), new DisableCommand()));
        this.addButtonRow(builderButtons, "Red selected", null, new ChainCommand<Component>(new BackgroundColorCommand(Color.red), new SelectCommand()));
        this.addButtonRow(builderButtons, "Red disabled selected", null, new ChainCommand<Component>(new BackgroundColorCommand(Color.red), new SelectCommand(), new DisableCommand()));
        this.addButtonRow(builderButtons, "Green", null, new BackgroundColorCommand(Color.green));
        this.addButtonRow(builderButtons, "Green disabled", null, new ChainCommand<Component>(new BackgroundColorCommand(Color.green), new DisableCommand()));
        this.addButtonRow(builderButtons, "Green selected", null, new ChainCommand<Component>(new BackgroundColorCommand(Color.green), new SelectCommand()));
        this.addButtonRow(builderButtons, "Green disabled selected", null, new ChainCommand<Component>(new BackgroundColorCommand(Color.green), new SelectCommand(), new DisableCommand()));
        this.addButtonRow(builderButtons, "Dark Green", null, new BackgroundColorCommand(Color.green.darker()));
        this.addButtonRow(builderButtons, "Dark Green disabled", null, new ChainCommand<Component>(new BackgroundColorCommand(Color.green.darker()), new DisableCommand()));
        this.addButtonRow(builderButtons, "Dark Green selected", null, new ChainCommand<Component>(new BackgroundColorCommand(Color.green.darker()), new SelectCommand()));
        this.addButtonRow(builderButtons, "Dark Green disabled selected", null, new ChainCommand<Component>(new BackgroundColorCommand(Color.green.darker()), new SelectCommand(), new DisableCommand()));
        builderButtons.appendSeparator("Foreground settings");
        this.addButtonRow(builderButtons, "Yellow", null, new ForegroundColorCommand(Color.yellow));
        this.addButtonRow(builderButtons, "Yellow disabled", null, new ChainCommand<Component>(new ForegroundColorCommand(Color.yellow), new DisableCommand()));
        this.addButtonRow(builderButtons, "Yellow selected", null, new ChainCommand<Component>(new ForegroundColorCommand(Color.yellow), new SelectCommand()));
        this.addButtonRow(builderButtons, "Yellow disabled selected", null, new ChainCommand<Component>(new ForegroundColorCommand(Color.yellow), new SelectCommand(), new DisableCommand()));
        this.addButtonRow(builderButtons, "Red", null, new ForegroundColorCommand(Color.red));
        this.addButtonRow(builderButtons, "Red disabled", null, new ChainCommand<Component>(new ForegroundColorCommand(Color.red), new DisableCommand()));
        this.addButtonRow(builderButtons, "Red selected", null, new ChainCommand<Component>(new ForegroundColorCommand(Color.red), new SelectCommand()));
        this.addButtonRow(builderButtons, "Red disabled selected", null, new ChainCommand<Component>(new ForegroundColorCommand(Color.red), new SelectCommand(), new DisableCommand()));
        this.addButtonRow(builderButtons, "Green", null, new ForegroundColorCommand(Color.green));
        this.addButtonRow(builderButtons, "Green disabled", null, new ChainCommand<Component>(new ForegroundColorCommand(Color.green), new DisableCommand()));
        this.addButtonRow(builderButtons, "Green selected", null, new ChainCommand<Component>(new ForegroundColorCommand(Color.green), new SelectCommand()));
        this.addButtonRow(builderButtons, "Green disabled selected", null, new ChainCommand<Component>(new ForegroundColorCommand(Color.green), new SelectCommand(), new DisableCommand()));
        this.addButtonRow(builderButtons, "Dark Green", null, new ForegroundColorCommand(Color.green.darker()));
        this.addButtonRow(builderButtons, "Dark Green disabled", null, new ChainCommand<Component>(new ForegroundColorCommand(Color.green.darker()), new DisableCommand()));
        this.addButtonRow(builderButtons, "Dark Green selected", null, new ChainCommand<Component>(new ForegroundColorCommand(Color.green.darker()), new SelectCommand()));
        this.addButtonRow(builderButtons, "Dark Green disabled selected", null, new ChainCommand<Component>(new ForegroundColorCommand(Color.green.darker()), new SelectCommand(), new DisableCommand()));
        builderButtons.appendSeparator("Combined settings");
        this.addButtonRow(builderButtons, "Blue/yellow", null, new ChainCommand<Component>(new ForegroundColorCommand(Color.blue), new BackgroundColorCommand(Color.yellow)));
        this.addButtonRow(builderButtons, "Blue/yellow disabled", null, new ChainCommand<Component>(new ForegroundColorCommand(Color.blue), new BackgroundColorCommand(Color.yellow), new DisableCommand()));
        this.addButtonRow(builderButtons, "Blue/yellow selected", null, new ChainCommand<Component>(new ForegroundColorCommand(Color.blue), new BackgroundColorCommand(Color.yellow), new SelectCommand()));
        this.addButtonRow(builderButtons, "Blue/yellow disabled selected", null, new ChainCommand<Component>(new ForegroundColorCommand(Color.blue), new BackgroundColorCommand(Color.yellow), new SelectCommand(), new DisableCommand()));
        this.addButtonRow(builderButtons, "Red/light green", null, new ChainCommand<Component>(new ForegroundColorCommand(Color.red), new BackgroundColorCommand(Color.green.brighter())));
        this.addButtonRow(builderButtons, "Red/light green disabled", null, new ChainCommand<Component>(new ForegroundColorCommand(Color.red), new BackgroundColorCommand(Color.green.brighter()), new DisableCommand()));
        this.addButtonRow(builderButtons, "Red/light green selected", null, new ChainCommand<Component>(new ForegroundColorCommand(Color.red), new BackgroundColorCommand(Color.green.brighter()), new SelectCommand()));
        this.addButtonRow(builderButtons, "Red/light green disabled selected", null, new ChainCommand<Component>(new ForegroundColorCommand(Color.red), new BackgroundColorCommand(Color.green.brighter()), new SelectCommand(), new DisableCommand()));
        this.addButtonRow(builderButtons, "Dark yellow/blue", null, new ChainCommand<Component>(new ForegroundColorCommand(Color.yellow.darker()), new BackgroundColorCommand(Color.blue)));
        this.addButtonRow(builderButtons, "Dark yellow/blue disabled", null, new ChainCommand<Component>(new ForegroundColorCommand(Color.yellow.darker()), new BackgroundColorCommand(Color.blue), new DisableCommand()));
        this.addButtonRow(builderButtons, "Dark yellow/blue selected", null, new ChainCommand<Component>(new ForegroundColorCommand(Color.yellow.darker()), new BackgroundColorCommand(Color.blue), new SelectCommand()));
        this.addButtonRow(builderButtons, "Dark yellow/blue disabled selected", null, new ChainCommand<Component>(new ForegroundColorCommand(Color.yellow.darker()), new BackgroundColorCommand(Color.blue), new SelectCommand(), new DisableCommand()));
        this.addButtonRow(builderButtons, "Dark green/magenta", null, new ChainCommand<Component>(new ForegroundColorCommand(Color.green.darker()), new BackgroundColorCommand(Color.magenta)));
        this.addButtonRow(builderButtons, "Dark green/magenta disabled", null, new ChainCommand<Component>(new ForegroundColorCommand(Color.green.darker()), new BackgroundColorCommand(Color.magenta), new DisableCommand()));
        this.addButtonRow(builderButtons, "Dark green/magenta selected", null, new ChainCommand<Component>(new ForegroundColorCommand(Color.green.darker()), new BackgroundColorCommand(Color.magenta), new SelectCommand()));
        this.addButtonRow(builderButtons, "Dark green/magenta disabled selected", null, new ChainCommand<Component>(new ForegroundColorCommand(Color.green.darker()), new BackgroundColorCommand(Color.magenta), new SelectCommand(), new DisableCommand()));
        JPanel panelButtons = builderButtons.getPanel();
        JScrollPane jspButtons = new JScrollPane(panelButtons);
        panelButtons.setOpaque(false);
        jspButtons.setOpaque(false);
        jspButtons.getViewport().setOpaque(false);
        FormLayout lmOther = new FormLayout("right:pref, 10dlu, left:pref:grow(1), 4dlu,left:pref:grow(1), 4dlu, left:pref:grow(1), 4dlu, left:pref:grow(1)", "");
        lmOther.setColumnGroups(new int[][]{{3, 5, 7, 9}});
        DefaultFormBuilder builderOther = new DefaultFormBuilder(lmOther, new ScrollablePanel());
        builderOther.setDefaultDialogBorder();
        builderOther.append("");
        builderOther.append((Component)new JLabel("Yellow"), (Component)new JLabel("Blue + red foreground"));
        builderOther.append((Component)new JLabel("Green"), (Component)new JLabel("Dark green"));
        builderOther.appendSeparator("Labels");
        this.addControlRow(builderOther, "Regular", new CreationCommand<Component>(){

            @Override
            public Component create() {
                return new JLabel("label");
            }
        }, null);
        this.addControlRow(builderOther, "Disabled", new CreationCommand<Component>(){

            @Override
            public Component create() {
                return new JLabel("label");
            }
        }, new DisableCommand());
        this.addControlRow(builderOther, "HTML", new CreationCommand<Component>(){

            @Override
            public Component create() {
                return new JLabel("<html>text <b>text</b> <font color='red'>text</font>");
            }
        }, null);
        builderOther.appendSeparator("Sliders");
        this.addControlRow(builderOther, "Regular", new CreationCommand<Component>(){

            @Override
            public Component create() {
                return new JSlider(0, 100, 50);
            }
        }, null);
        this.addControlRow(builderOther, "Disabled", new CreationCommand<Component>(){

            @Override
            public Component create() {
                return new JSlider(0, 100, 50);
            }
        }, new DisableCommand());
        builderOther.appendSeparator("Progress bars");
        this.addControlRow(builderOther, "Regular", new CreationCommand<Component>(){

            @Override
            public Component create() {
                JProgressBar jpb = new JProgressBar(0, 100);
                jpb.setIndeterminate(false);
                jpb.setValue(50);
                jpb.setStringPainted(true);
                return jpb;
            }
        }, null);
        this.addControlRow(builderOther, "Disabled", new CreationCommand<Component>(){

            @Override
            public Component create() {
                JProgressBar jpb = new JProgressBar(0, 100);
                jpb.setIndeterminate(false);
                jpb.setValue(50);
                jpb.setStringPainted(true);
                return jpb;
            }
        }, new DisableCommand());
        this.addControlRow(builderOther, "Custom foreground", new CreationCommand<Component>(){

            @Override
            public Component create() {
                JProgressBar jpb = new JProgressBar(0, 100);
                jpb.setIndeterminate(false);
                jpb.setValue(50);
                jpb.setStringPainted(true);
                return jpb;
            }
        }, new ForegroundColorCommand(Color.red));
        this.addControlRow(builderOther, "Disabled with foreground", new CreationCommand<Component>(){

            @Override
            public Component create() {
                JProgressBar jpb = new JProgressBar(0, 100);
                jpb.setIndeterminate(false);
                jpb.setValue(50);
                jpb.setStringPainted(true);
                return jpb;
            }
        }, new ChainCommand<Component>(new DisableCommand(), new ForegroundColorCommand(Color.red)));
        this.addControlRow(builderOther, "Indeterminate", new CreationCommand<Component>(){

            @Override
            public Component create() {
                JProgressBar jpb = new JProgressBar(0, 100);
                jpb.setIndeterminate(true);
                return jpb;
            }
        }, null);
        this.addControlRow(builderOther, "Indeterminate disabled", new CreationCommand<Component>(){

            @Override
            public Component create() {
                JProgressBar jpb = new JProgressBar(0, 100);
                jpb.setIndeterminate(true);
                return jpb;
            }
        }, new DisableCommand());
        builderOther.appendSeparator("Combo boxes");
        this.addControlRow(builderOther, "Regular", new CreationCommand<Component>(){

            @Override
            public Component create() {
                JComboBox<Object> jcb = new JComboBox<Object>(new Object[]{"Ester", "Jordi", "Jordina", "Jorge", "Sergi"});
                return jcb;
            }
        }, null);
        this.addControlRow(builderOther, "Flat", new CreationCommand<Component>(){

            @Override
            public Component create() {
                JComboBox<Object> jcb = new JComboBox<Object>(new Object[]{"Ester", "Jordi", "Jordina", "Jorge", "Sergi"});
                return jcb;
            }
        }, new ClientPropertyCommand("substancelaf.componentFlat", Boolean.TRUE));
        this.addControlRow(builderOther, "Disabled", new CreationCommand<Component>(){

            @Override
            public Component create() {
                JComboBox<Object> jcb = new JComboBox<Object>(new Object[]{"Ester", "Jordi", "Jordina", "Jorge", "Sergi"});
                return jcb;
            }
        }, new DisableCommand());
        this.addControlRow(builderOther, "Editable", new CreationCommand<Component>(){

            @Override
            public Component create() {
                JComboBox<Object> jcb = new JComboBox<Object>(new Object[]{"Ester", "Jordi", "Jordina", "Jorge", "Sergi"});
                jcb.setEditable(true);
                return jcb;
            }
        }, null);
        this.addControlRow(builderOther, "Disabled editable", new CreationCommand<Component>(){

            @Override
            public Component create() {
                JComboBox<Object> jcb = new JComboBox<Object>(new Object[]{"Ester", "Jordi", "Jordina", "Jorge", "Sergi"});
                jcb.setEditable(true);
                return jcb;
            }
        }, new DisableCommand());
        CreationCommand<Component> spinnerCreationCmd = new CreationCommand<Component>(){

            @Override
            public Component create() {
                JSpinner s = new JSpinner(new SpinnerListModel(new Object[]{"sample0", "sample", "sample2"}));
                s.getModel().setValue("sample");
                return s;
            }
        };
        builderOther.appendSeparator("Spinners");
        this.addControlRow(builderOther, "Regular", spinnerCreationCmd, null);
        this.addControlRow(builderOther, "Flat", spinnerCreationCmd, new ClientPropertyCommand("substancelaf.componentFlat", Boolean.TRUE));
        this.addControlRow(builderOther, "Disabled", spinnerCreationCmd, new DisableCommand());
        JPanel panelOther = builderOther.getPanel();
        JScrollPane jspOther = new JScrollPane(panelOther);
        panelOther.setOpaque(false);
        jspOther.setOpaque(false);
        jspOther.getViewport().setOpaque(false);
        FormLayout lmText = new FormLayout("right:pref, 10dlu, left:pref:grow(1), 4dlu,left:pref:grow(1), 4dlu, left:pref:grow(1), 4dlu, left:pref:grow(1)", "");
        lmText.setColumnGroups(new int[][]{{3, 5, 7, 9}});
        DefaultFormBuilder builderText = new DefaultFormBuilder(lmText, new ScrollablePanel());
        builderText.setDefaultDialogBorder();
        builderText.append("");
        builderText.append((Component)new JLabel("Yellow"), (Component)new JLabel("Blue + red foreground"));
        builderText.append((Component)new JLabel("Green"), (Component)new JLabel("Dark green"));
        builderText.appendSeparator("Text fields");
        this.addControlRow(builderText, "Regular", new CreationCommand<Component>(){

            @Override
            public Component create() {
                JTextField field = new JTextField("test", 15);
                return field;
            }
        }, null);
        this.addControlRow(builderText, "Watermark", new CreationCommand<Component>(){

            @Override
            public Component create() {
                JTextField field = new JTextField("test", 15);
                return field;
            }
        }, new ClientPropertyCommand("substancelaf.watermark.visible", Boolean.TRUE));
        this.addControlRow(builderText, "Disabled", new CreationCommand<Component>(){

            @Override
            public Component create() {
                JTextField field = new JTextField("test", 15);
                return field;
            }
        }, new DisableCommand());
        this.addControlRow(builderText, "Not editable", new CreationCommand<Component>(){

            @Override
            public Component create() {
                JTextField field = new JTextField("test", 15);
                field.setEditable(false);
                return field;
            }
        }, null);
        builderText.appendSeparator("Formatted text fields");
        this.addControlRow(builderText, "Regular", new CreationCommand<Component>(){

            @Override
            public Component create() {
                JFormattedTextField field = new JFormattedTextField(new DecimalFormat("#,##0.0000"));
                field.setText("2,430.0000");
                return field;
            }
        }, null);
        this.addControlRow(builderText, "Watermark", new CreationCommand<Component>(){

            @Override
            public Component create() {
                JFormattedTextField field = new JFormattedTextField(new DecimalFormat("#,##0.0000"));
                field.setText("2,430.0000");
                return field;
            }
        }, new ClientPropertyCommand("substancelaf.watermark.visible", Boolean.TRUE));
        this.addControlRow(builderText, "Disabled", new CreationCommand<Component>(){

            @Override
            public Component create() {
                JFormattedTextField field = new JFormattedTextField(new DecimalFormat("#,##0.0000"));
                field.setText("2,430.0000");
                return field;
            }
        }, new DisableCommand());
        this.addControlRow(builderText, "Not editable", new CreationCommand<Component>(){

            @Override
            public Component create() {
                JFormattedTextField field = new JFormattedTextField(new DecimalFormat("#,##0.0000"));
                field.setText("2,430.0000");
                field.setEditable(false);
                return field;
            }
        }, null);
        builderText.appendSeparator("Password fields");
        this.addControlRow(builderText, "Regular", new CreationCommand<Component>(){

            @Override
            public Component create() {
                JPasswordField field = new JPasswordField("password", 15);
                return field;
            }
        }, null);
        this.addControlRow(builderText, "Watermark", new CreationCommand<Component>(){

            @Override
            public Component create() {
                JPasswordField field = new JPasswordField("password", 15);
                return field;
            }
        }, new ClientPropertyCommand("substancelaf.watermark.visible", Boolean.TRUE));
        this.addControlRow(builderText, "Disabled", new CreationCommand<Component>(){

            @Override
            public Component create() {
                JPasswordField field = new JPasswordField("password", 15);
                return field;
            }
        }, new DisableCommand());
        this.addControlRow(builderText, "Not editable", new CreationCommand<Component>(){

            @Override
            public Component create() {
                JPasswordField field = new JPasswordField("password", 15);
                field.setEditable(false);
                return field;
            }
        }, null);
        builderText.appendSeparator("Editor panes");
        this.addControlRow(builderText, "Regular", new CreationCommand<Component>(){

            @Override
            public Component create() {
                JEditorPane pane = new JEditorPane("text/html;", "Sample <b>content</b><br> <u>text</u>");
                return pane;
            }
        }, null);
        this.addControlRow(builderText, "Watermark", new CreationCommand<Component>(){

            @Override
            public Component create() {
                JEditorPane pane = new JEditorPane("text/html;", "Sample <b>content</b><br> <u>text</u>");
                return pane;
            }
        }, new ClientPropertyCommand("substancelaf.watermark.visible", Boolean.TRUE));
        this.addControlRow(builderText, "Disabled", new CreationCommand<Component>(){

            @Override
            public Component create() {
                JEditorPane pane = new JEditorPane("text/html;", "Sample <b>content</b><br> <u>text</u>");
                return pane;
            }
        }, new DisableCommand());
        this.addControlRow(builderText, "Not editable", new CreationCommand<Component>(){

            @Override
            public Component create() {
                JEditorPane pane = new JEditorPane("text/html;", "Sample <b>content</b><br> <u>text</u>");
                pane.setEditable(false);
                return pane;
            }
        }, null);
        builderText.appendSeparator("Text areas");
        this.addControlRow(builderText, "Regular", new CreationCommand<Component>(){

            @Override
            public Component create() {
                JTextArea area = new JTextArea("Sample content text", 3, 15);
                return area;
            }
        }, null);
        this.addControlRow(builderText, "Watermark", new CreationCommand<Component>(){

            @Override
            public Component create() {
                JTextArea area = new JTextArea("Sample content text", 3, 15);
                return area;
            }
        }, new ClientPropertyCommand("substancelaf.watermark.visible", Boolean.TRUE));
        this.addControlRow(builderText, "Disabled", new CreationCommand<Component>(){

            @Override
            public Component create() {
                JTextArea area = new JTextArea("Sample content text", 3, 15);
                return area;
            }
        }, new DisableCommand());
        this.addControlRow(builderText, "Not editable", new CreationCommand<Component>(){

            @Override
            public Component create() {
                JTextArea area = new JTextArea("Sample content text", 3, 15);
                area.setEditable(false);
                return area;
            }
        }, null);
        builderText.appendSeparator("Text panes");
        this.addControlRow(builderText, "Regular", new CreationCommand<Component>(){

            @Override
            public Component create() {
                JTextPane pane = new JTextPane();
                pane.replaceSelection("Sample content text");
                pane.setPreferredSize(new Dimension(120, 40));
                return pane;
            }
        }, null);
        this.addControlRow(builderText, "Watermark", new CreationCommand<Component>(){

            @Override
            public Component create() {
                JTextPane pane = new JTextPane();
                pane.replaceSelection("Sample content text");
                pane.setPreferredSize(new Dimension(120, 40));
                return pane;
            }
        }, new ClientPropertyCommand("substancelaf.watermark.visible", Boolean.TRUE));
        this.addControlRow(builderText, "Disabled", new CreationCommand<Component>(){

            @Override
            public Component create() {
                JTextPane pane = new JTextPane();
                pane.replaceSelection("Sample content text");
                pane.setPreferredSize(new Dimension(120, 40));
                return pane;
            }
        }, new DisableCommand());
        this.addControlRow(builderText, "Not editable", new CreationCommand<Component>(){

            @Override
            public Component create() {
                JTextPane pane = new JTextPane();
                pane.replaceSelection("Sample content text");
                pane.setPreferredSize(new Dimension(120, 40));
                pane.setEditable(false);
                return pane;
            }
        }, null);
        JPanel panelText = builderText.getPanel();
        JScrollPane jspText = new JScrollPane(panelText);
        panelText.setOpaque(false);
        jspText.setOpaque(false);
        jspText.getViewport().setOpaque(false);
        JScrollPane coloredScrollPane = new JScrollPane(new CheckeredPanel());
        coloredScrollPane.setBackground(Color.yellow);
        coloredScrollPane.getVerticalScrollBar().setBackground(Color.green);
        FormLayout lmCells = new FormLayout("right:pref, 10dlu, fill:pref:grow(1), 4dlu,fill:pref:grow(1), 4dlu, fill:pref:grow(1), 4dlu, fill:pref:grow(1)", "");
        lmCells.setColumnGroups(new int[][]{{3, 5, 7, 9}});
        DefaultFormBuilder builderCells = new DefaultFormBuilder(lmCells, new ScrollablePanel());
        builderCells.setDefaultDialogBorder();
        builderCells.append("");
        builderCells.append((Component)new JLabel("Yellow"), (Component)new JLabel("Blue + red foreground"));
        builderCells.append((Component)new JLabel("Green"), (Component)new JLabel("Dark green"));
        builderCells.appendSeparator("Lists");
        this.addControlRow(builderCells, "List", new CreationCommand<Component>(){

            @Override
            public Component create() {
                JList<Object> list = new JList<Object>(new Object[]{"entry1", "entry2", "entry3"});
                return list;
            }
        }, null);
        this.addControlRow(builderCells, "List watermark", new CreationCommand<Component>(){

            @Override
            public Component create() {
                JList<Object> list = new JList<Object>(new Object[]{"entry1", "entry2", "entry3"});
                return list;
            }
        }, new ClientPropertyCommand("substancelaf.watermark.visible", Boolean.TRUE));
        this.addControlRow(builderCells, "List disabled", new CreationCommand<Component>(){

            @Override
            public Component create() {
                JList<Object> list = new JList<Object>(new Object[]{"entry1", "entry2", "entry3"});
                return list;
            }
        }, new DisableCommand());
        CreationCommand<Component> tableCreationCmd = new CreationCommand<Component>(){

            @Override
            public Component create() {
                final JTable table = new JTable(new Object[][]{{"entry11", "entry12", "entry13"}, {"entry21", "entry22", "entry23"}, {"entry31", "entry32", "entry33"}}, new Object[]{"Column1", "Column2", "Column3"});
                table.setName("Table ");
                JScrollPane tableScroll = new JScrollPane(table){

                    @Override
                    public void setBackground(Color bg) {
                        super.setBackground(bg);
                        table.setBackground(bg);
                        table.getTableHeader().setBackground(bg);
                    }

                    @Override
                    public void setForeground(Color fg) {
                        super.setForeground(fg);
                        table.setForeground(fg);
                        table.getTableHeader().setForeground(fg);
                    }
                };
                Dimension prefTable = table.getPreferredSize();
                tableScroll.setPreferredSize(new Dimension(prefTable.width, prefTable.height + 25));
                return tableScroll;
            }
        };
        builderCells.appendSeparator("Tables");
        this.addControlRow(builderCells, "Table", tableCreationCmd, null);
        this.addControlRow(builderCells, "Table watermark", tableCreationCmd, new ClientPropertyCommand("substancelaf.watermark.visible", Boolean.TRUE));
        this.addControlRow(builderCells, "Table disabled", tableCreationCmd, new DisableViewportCommand());
        CreationCommand<Component> treeCreationCmd = new CreationCommand<Component>(){

            public void expandAll(JTree tree, boolean expand) {
                TreeNode root = (TreeNode)tree.getModel().getRoot();
                this.expandAll(tree, new TreePath(root), expand);
            }

            private void expandAll(JTree tree, TreePath parent, boolean expand) {
                TreeNode node = (TreeNode)parent.getLastPathComponent();
                if (node.getChildCount() >= 0) {
                    Enumeration<? extends TreeNode> e = node.children();
                    while (e.hasMoreElements()) {
                        TreeNode n = e.nextElement();
                        TreePath path = parent.pathByAddingChild(n);
                        this.expandAll(tree, path, expand);
                    }
                }
                if (expand) {
                    tree.expandPath(parent);
                } else {
                    tree.collapsePath(parent);
                }
            }

            @Override
            public Component create() {
                DefaultMutableTreeNode root = new DefaultMutableTreeNode("root");
                DefaultMutableTreeNode son1 = new DefaultMutableTreeNode("son1");
                DefaultMutableTreeNode son2 = new DefaultMutableTreeNode("son2");
                DefaultMutableTreeNode son3 = new DefaultMutableTreeNode("son3");
                DefaultMutableTreeNode gson11 = new DefaultMutableTreeNode("gson11");
                DefaultMutableTreeNode gson12 = new DefaultMutableTreeNode("gson12");
                DefaultMutableTreeNode gson21 = new DefaultMutableTreeNode("gson21");
                DefaultMutableTreeNode gson22 = new DefaultMutableTreeNode("gson22");
                DefaultMutableTreeNode gson31 = new DefaultMutableTreeNode("gson31");
                DefaultMutableTreeNode gson32 = new DefaultMutableTreeNode("gson32");
                DefaultMutableTreeNode ggson111 = new DefaultMutableTreeNode("ggson111");
                DefaultMutableTreeNode ggson112 = new DefaultMutableTreeNode("ggson112");
                DefaultMutableTreeNode ggson113 = new DefaultMutableTreeNode("ggson113");
                gson11.add(ggson111);
                gson11.add(ggson112);
                gson11.add(ggson113);
                son1.add(gson11);
                son1.add(gson12);
                son2.add(gson21);
                son2.add(gson22);
                son3.add(gson31);
                son3.add(gson32);
                root.add(son1);
                root.add(son2);
                root.add(son3);
                JTree tree = new JTree(root);
                this.expandAll(tree, true);
                return tree;
            }
        };
        builderCells.appendSeparator("Trees");
        this.addControlRow(builderCells, "Tree", treeCreationCmd, null);
        this.addControlRow(builderCells, "Tree watermark", treeCreationCmd, new ClientPropertyCommand("substancelaf.watermark.visible", Boolean.TRUE));
        this.addControlRow(builderCells, "Tree disabled", treeCreationCmd, new DisableCommand());
        JPanel panelCells = builderCells.getPanel();
        JScrollPane jspCells = new JScrollPane(panelCells);
        panelCells.setOpaque(false);
        jspCells.setOpaque(false);
        jspCells.getViewport().setOpaque(false);
        JDesktopPane desktopPane = new JDesktopPane();
        CreationCommand<Component> internalFrameCreationCmd = new CreationCommand<Component>(){

            @Override
            public Component create() {
                JInternalFrame jif = new JInternalFrame("Internal frame");
                jif.setLayout(new FlowLayout());
                JButton button = new JButton("red button");
                button.setBackground(Color.red);
                jif.add(button);
                jif.setClosable(true);
                jif.setMaximizable(true);
                jif.setIconifiable(true);
                jif.setResizable(true);
                jif.setVisible(true);
                JMenuBar jmb = new JMenuBar();
                JMenu coloredMenu = new JMenu("Colors");
                coloredMenu.setMnemonic('0');
                JMenuItem coloredMI = new JMenuItem("Italic red");
                coloredMI.setFont(coloredMI.getFont().deriveFont(2));
                coloredMI.setForeground(Color.red);
                coloredMI.setBackground(Color.yellow);
                coloredMenu.add(coloredMI);
                JRadioButtonMenuItem coloredRBMI = new JRadioButtonMenuItem("Bold green");
                coloredRBMI.setFont(coloredRBMI.getFont().deriveFont(1));
                coloredRBMI.setForeground(Color.green);
                coloredRBMI.setBackground(Color.blue.brighter());
                coloredMenu.add(coloredRBMI);
                JCheckBoxMenuItem coloredCBMI = new JCheckBoxMenuItem("Big blue");
                coloredCBMI.setFont(coloredCBMI.getFont().deriveFont(32.0f));
                coloredCBMI.setForeground(Color.blue);
                coloredCBMI.setBackground(Color.green.brighter());
                coloredMenu.add(coloredCBMI);
                JMenu coloredM = new JMenu("Always big magenta");
                coloredM.setForeground(Color.magenta);
                coloredM.setBackground(Color.red.darker());
                coloredM.setFont(coloredM.getFont().deriveFont(24.0f));
                coloredMenu.add(coloredM);
                jmb.add(coloredMenu);
                JMenu blueMenu = new JMenu("Blue");
                blueMenu.setForeground(Color.blue);
                blueMenu.setBackground(Color.yellow);
                jmb.add(blueMenu);
                jif.setJMenuBar(jmb);
                return jif;
            }
        };
        this.addInternalFrame(desktopPane, internalFrameCreationCmd, new ChainCommand<Component>(new BackgroundColorCommand(Color.yellow), new SetBoundsCommand(new Rectangle(0, 0, 200, 100))));
        this.addInternalFrame(desktopPane, internalFrameCreationCmd, new ChainCommand<Component>(new BackgroundColorCommand(Color.green), new SetBoundsCommand(new Rectangle(250, 0, 200, 100))));
        this.addInternalFrame(desktopPane, internalFrameCreationCmd, new ChainCommand<Component>(new BackgroundColorCommand(Color.yellow), new SetBoundsCommand(new Rectangle(0, 150, 200, 100)), new MinimizeInternalFrameCommand()));
        this.addInternalFrame(desktopPane, internalFrameCreationCmd, new ChainCommand<Component>(new BackgroundColorCommand(Color.green), new SetBoundsCommand(new Rectangle(250, 150, 200, 100)), new MinimizeInternalFrameCommand()));
        desktopPane.setBackground(Color.blue);
        final JTabbedPane tabbed = new JTabbedPane();
        tabbed.addTab("Buttons", jspButtons);
        tabbed.addTab("Text", jspText);
        tabbed.addTab("Scroll", coloredScrollPane);
        tabbed.addTab("Cells", jspCells);
        tabbed.addTab("Desktop", desktopPane);
        tabbed.addTab("Other", jspOther);
        tabbed.addTab("Yellow / Magenta", new JPanel());
        tabbed.setBackgroundAt(tabbed.getTabCount() - 1, Color.yellow);
        tabbed.setForegroundAt(tabbed.getTabCount() - 1, Color.magenta);
        tabbed.addTab("Green / Blue", new JPanel());
        tabbed.setBackgroundAt(tabbed.getTabCount() - 1, Color.green);
        tabbed.setForegroundAt(tabbed.getTabCount() - 1, Color.blue);
        tabbed.addTab("Dark Green", new JPanel());
        tabbed.setBackgroundAt(tabbed.getTabCount() - 1, Color.green.darker());
        tabbed.addTab("Disabled Green / Red", new JPanel());
        tabbed.setBackgroundAt(tabbed.getTabCount() - 1, Color.green);
        tabbed.setForegroundAt(tabbed.getTabCount() - 1, Color.red.darker());
        tabbed.setEnabledAt(tabbed.getTabCount() - 1, false);
        this.add((Component)tabbed, "Center");
        JPanel controls = new JPanel(new FlowLayout(0));
        final JSlider colorizationSlider = new JSlider(0, 100, 50);
        this.putClientProperty("substancelaf.colorizationFactor", 0.5);
        colorizationSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                double val = (double)colorizationSlider.getValue() / 100.0;
                ColorizedControlsPanel.this.putClientProperty("substancelaf.colorizationFactor", new Double(val));
                tabbed.repaint();
            }
        });
        controls.add(colorizationSlider);
        this.add((Component)controls, "North");
        this.isInitialized = true;
    }
}

