/*
 * Decompiled with CFR 0.152.
 */
package test.check;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerListModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.FontUIResource;
import org.pushingpixels.substance.api.SubstanceLookAndFeel;
import org.pushingpixels.substance.api.skin.BusinessBlackSteelSkin;
import test.check.ControllablePanel;
import test.check.Deferrable;
import test.check.ScrollablePanel;

public class HAlignmentPanel
extends ControllablePanel
implements Deferrable {
    private boolean isInitialized;
    private JCheckBox toPaintGuiderLines;
    private JCheckBox toPaintBounds;

    @Override
    public boolean isInitialized() {
        return this.isInitialized;
    }

    public HAlignmentPanel() {
        this.setLayout(new BorderLayout());
    }

    @Override
    public synchronized void initialize() {
        FormLayout lm = new FormLayout("left:pref:grow", "");
        DefaultFormBuilder builder = new DefaultFormBuilder(lm, new ScrollablePanel());
        builder.setDefaultDialogBorder();
        int fontSize = 11;
        while (fontSize < 25) {
            builder.append(this.getSubPanel(fontSize));
            ++fontSize;
        }
        this.add(new JScrollPane(builder.getPanel()));
        FormLayout controlPanelLayoutManager = new FormLayout("fill:pref:grow", "");
        DefaultFormBuilder controlPanelBuilder = new DefaultFormBuilder(controlPanelLayoutManager, new ScrollablePanel());
        this.toPaintGuiderLines = new JCheckBox("guider lines");
        this.toPaintGuiderLines.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HAlignmentPanel.this.repaint();
            }
        });
        controlPanelBuilder.append(this.toPaintGuiderLines);
        this.toPaintBounds = new JCheckBox("bounds");
        this.toPaintBounds.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HAlignmentPanel.this.repaint();
            }
        });
        controlPanelBuilder.append(this.toPaintBounds);
        this.controlPanel = controlPanelBuilder.getPanel();
        this.isInitialized = true;
    }

    private JPanel getSubPanel(int size) {
        final JButton button = new JButton("sample");
        final JTextField tf = new JTextField("sample");
        final JPanel result = new JPanel(new FlowLayout(0)){

            @Override
            public void paint(Graphics g) {
                super.paint(g);
                Graphics2D g2d = (Graphics2D)g.create();
                if (HAlignmentPanel.this.toPaintGuiderLines.isSelected()) {
                    Rectangle buttonBounds = button.getBounds();
                    int textFieldBaseline = tf.getBaseline(buttonBounds.width, buttonBounds.height);
                    g2d.setColor(new Color(255, 0, 0, 196));
                    g2d.drawLine(0, buttonBounds.y, this.getWidth(), buttonBounds.y);
                    g2d.drawLine(0, buttonBounds.y + buttonBounds.height - 1, this.getWidth(), buttonBounds.y + buttonBounds.height - 1);
                    g2d.setColor(new Color(0, 128, 0, 196));
                    g2d.drawLine(0, buttonBounds.y + textFieldBaseline, this.getWidth(), buttonBounds.y + textFieldBaseline);
                }
                if (HAlignmentPanel.this.toPaintBounds.isSelected()) {
                    int i = 0;
                    while (i < this.getComponentCount()) {
                        Component child = this.getComponent(i);
                        Rectangle bounds = child.getBounds();
                        g2d.setColor(new Color(128, 0, 255, 128));
                        g2d.fill(bounds);
                        ++i;
                    }
                }
                g2d.dispose();
            }
        };
        String fontName = "Tahoma";
        Font font = new Font(fontName, 0, size);
        if (UIManager.getLookAndFeel() instanceof SubstanceLookAndFeel) {
            FontUIResource base = SubstanceLookAndFeel.getFontPolicy().getFontSet("Substance", null).getControlFont();
            fontName = base.getFamily();
            font = base.deriveFont((float)size);
        }
        JLabel label = new JLabel(String.valueOf(fontName) + " " + size);
        label.setFont(font);
        result.add(label);
        tf.setFont(font);
        result.add(tf);
        JPasswordField pf = new JPasswordField("sample");
        pf.setFont(font);
        result.add(pf);
        JComboBox ecb = new JComboBox(new Object[]{"sample"}){

            @Override
            public void updateUI() {
                super.updateUI();
                ((JTextField)this.getEditor().getEditorComponent()).setColumns(5);
            }
        };
        ecb.setFont(font);
        ecb.setEditable(true);
        ecb.setPrototypeDisplayValue("sample");
        result.add(ecb);
        JSpinner s = new JSpinner(new SpinnerListModel(new Object[]{"sample0", "sample", "sample2"}));
        s.getModel().setValue("sample");
        s.setFont(font);
        result.add(s);
        JComboBox<Object> cb = new JComboBox<Object>(new Object[]{"sample"});
        cb.setFont(font);
        result.add(cb);
        button.setFont(font);
        result.add(button);
        JRadioButton radio = new JRadioButton("sample");
        radio.setFont(font);
        result.add(radio);
        JCheckBox check = new JCheckBox("sample");
        check.setFont(font);
        result.add(check);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                result.revalidate();
            }
        });
        return result;
    }

    public static void main(String[] args) throws Exception {
        JFrame.setDefaultLookAndFeelDecorated(true);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SubstanceLookAndFeel.setSkin(new BusinessBlackSteelSkin());
                JFrame frame = new JFrame("Alignment");
                frame.setSize(600, 400);
                frame.setLocationRelativeTo(null);
                frame.setDefaultCloseOperation(3);
                HAlignmentPanel panel = new HAlignmentPanel();
                panel.initialize();
                frame.add((Component)panel, "Center");
                frame.setVisible(true);
            }
        });
    }
}

