/*
 * Decompiled with CFR 0.152.
 */
package test.check;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.Sizes;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.util.LinkedList;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import org.pushingpixels.substance.api.ColorSchemeAssociationKind;
import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.DecorationAreaType;
import org.pushingpixels.substance.api.SubstanceLookAndFeel;
import org.pushingpixels.substance.api.SubstanceSkin;
import org.pushingpixels.substance.api.skin.SkinChangeListener;
import test.SubstanceLogo;
import test.check.SampleMenuFactory;
import test.check.ScrollablePanel;

public class SampleInternalFrame
extends JInternalFrame {
    public SampleInternalFrame() {
        this.setLayout(new BorderLayout());
        JTabbedPane tabbed = new JTabbedPane();
        this.add((Component)tabbed, "Center");
        tabbed.addTab("Regular", new JPanel());
        JPanel samplePanel = new JPanel(new BorderLayout());
        FormLayout lm = new FormLayout("fill:default:grow(1), 4dlu,fill:default:grow(1)", "");
        DefaultFormBuilder builder = new DefaultFormBuilder(lm, new ScrollablePanel());
        builder.setLineGapSize(Sizes.pixel(1));
        builder.setBorder(new EmptyBorder(2, 2, 2, 2));
        JCheckBox cb1 = new JCheckBox("Enabled selected");
        cb1.setSelected(true);
        JCheckBox cb2 = new JCheckBox("Disabled selected");
        cb2.setSelected(true);
        cb2.setEnabled(false);
        JCheckBox cb3 = new JCheckBox("Enabled unselected");
        JRadioButton rb1 = new JRadioButton("Enabled selected");
        rb1.setSelected(true);
        JRadioButton rb2 = new JRadioButton("Disabled selected");
        rb2.setSelected(true);
        rb2.setEnabled(false);
        JRadioButton rb3 = new JRadioButton("Enabled unselected");
        builder.append((Component)cb1, (Component)rb1);
        builder.append((Component)cb2, (Component)rb2);
        builder.append((Component)cb3, (Component)rb3);
        JComboBox<Object> combo = new JComboBox<Object>(new Object[]{"item1", "item2", "item3", "item4"});
        combo.setSelectedIndex(0);
        combo.setEditable(true);
        JTextField text = new JTextField("Text field");
        text.setEditable(false);
        builder.append(combo, (Component)text);
        JPanel contentPanel = builder.getPanel();
        contentPanel.setPreferredSize(new Dimension(contentPanel.getPreferredSize().width, contentPanel.getPreferredSize().height + 100));
        contentPanel.setBorder(null);
        JScrollPane scroll = new JScrollPane(contentPanel, 22, 31);
        scroll.setBorder(new EmptyBorder(0, 0, 0, 0));
        samplePanel.add((Component)scroll, "Center");
        JPanel buttons = new JPanel(new FlowLayout(2));
        JButton prev = new JButton("prev");
        JButton cancel = new JButton("cancel");
        cancel.setEnabled(false);
        JButton ok = new JButton("OK");
        buttons.add(prev);
        buttons.add(cancel);
        buttons.add(ok);
        samplePanel.add((Component)buttons, "South");
        tabbed.addTab("Sample", samplePanel);
        tabbed.setSelectedComponent(samplePanel);
        tabbed.setOpaque(false);
        JMenuBar jmb = new JMenuBar();
        jmb.add(SampleMenuFactory.getSkinMenu());
        JMenu jm1 = new JMenu("Menu1");
        jm1.setMnemonic('1');
        int mcount = 0;
        for (LinkedList linkedList : SampleMenuFactory.getTestMenuItems()) {
            if (mcount > 0) {
                if (mcount % 2 == 0) {
                    jm1.addSeparator();
                } else {
                    jm1.add(new JSeparator());
                }
            }
            for (JMenuItem menuItem : linkedList) {
                jm1.add(menuItem);
            }
            ++mcount;
        }
        jmb.add(jm1);
        this.setJMenuBar(jmb);
        this.setClosable(true);
        this.setMaximizable(true);
        this.setIconifiable(true);
        this.setResizable(true);
        this.synchronize();
        SubstanceLookAndFeel.registerSkinChangeListener(new SkinChangeListener(){

            @Override
            public void skinChanged() {
                SampleInternalFrame.this.synchronize();
            }
        });
        ok.requestFocusInWindow();
    }

    protected void synchronize() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (UIManager.getLookAndFeel() instanceof SubstanceLookAndFeel) {
                    SubstanceSkin currentSkin = SubstanceLookAndFeel.getCurrentSkin(SampleInternalFrame.this.getRootPane());
                    SampleInternalFrame.this.setFrameIcon(SubstanceLogo.getLogoIcon(currentSkin.getColorScheme(DecorationAreaType.SECONDARY_TITLE_PANE, ColorSchemeAssociationKind.FILL, ComponentState.ENABLED)));
                    SampleInternalFrame.this.setTitle(currentSkin.getDisplayName());
                }
            }
        });
    }
}

