/*
 * Decompiled with CFR 0.152.
 */
package test.samples.substance.api;

import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.pushingpixels.substance.api.SubstanceLookAndFeel;
import org.pushingpixels.substance.api.SubstanceSkin;
import org.pushingpixels.substance.api.skin.AutumnSkin;
import org.pushingpixels.substance.api.skin.BusinessBlackSteelSkin;
import org.pushingpixels.substance.api.skin.GraphiteSkin;

public class GetCurrentSkin
extends JFrame {
    public GetCurrentSkin() {
        super("Per-window skins");
        this.setLayout(new FlowLayout());
        JButton autumnSkin = new JButton("Autumn skin");
        autumnSkin.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        GetCurrentSkin.this.openSampleFrame(new AutumnSkin());
                    }
                });
            }
        });
        this.add(autumnSkin);
        JButton ravenGraphiteSkin = new JButton("Graphite skin");
        ravenGraphiteSkin.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        GetCurrentSkin.this.openSampleFrame(new GraphiteSkin());
                    }
                });
            }
        });
        this.add(ravenGraphiteSkin);
        this.setSize(400, 200);
        this.setLocationRelativeTo(null);
        this.setDefaultCloseOperation(3);
    }

    private void openSampleFrame(SubstanceSkin skin) {
        final JFrame sampleFrame = new JFrame(skin.getDisplayName());
        sampleFrame.setLayout(new FlowLayout());
        final JButton button = new JButton("Get skin");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JOptionPane.showMessageDialog(sampleFrame, "Skin of this button is " + SubstanceLookAndFeel.getCurrentSkin(button).getDisplayName());
                    }
                });
            }
        });
        sampleFrame.add(button);
        sampleFrame.setVisible(true);
        sampleFrame.setSize(200, 100);
        sampleFrame.setLocationRelativeTo(null);
        sampleFrame.setDefaultCloseOperation(2);
        sampleFrame.getRootPane().putClientProperty("substancelaf.skin", skin);
        SwingUtilities.updateComponentTreeUI(sampleFrame);
        sampleFrame.repaint();
    }

    public static void main(String[] args) {
        JFrame.setDefaultLookAndFeelDecorated(true);
        JDialog.setDefaultLookAndFeelDecorated(true);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SubstanceLookAndFeel.setSkin(new BusinessBlackSteelSkin());
                new GetCurrentSkin().setVisible(true);
            }
        });
    }
}

