/*
 * Decompiled with CFR 0.152.
 */
package test.samples.substance.api;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import org.pushingpixels.substance.api.SubstanceLookAndFeel;
import org.pushingpixels.substance.api.skin.BusinessBlackSteelSkin;
import org.pushingpixels.substance.api.tabbed.TabCloseListener;

public class UnregisterTabCloseChangeListener_General
extends JFrame {
    private TabCloseListener listener;

    public UnregisterTabCloseChangeListener_General() {
        super("Register tab close listener");
        this.setLayout(new BorderLayout());
        JTabbedPane jtp = new JTabbedPane();
        jtp.addTab("tab1", new JPanel());
        jtp.addTab("tab2", new JPanel());
        jtp.addTab("tab3", new JPanel());
        jtp.putClientProperty("substancelaf.tabbedpanehasclosebuttons", Boolean.TRUE);
        this.listener = new TabCloseListener(){

            @Override
            public void tabClosing(JTabbedPane tabbedPane, Component tabComponent) {
                System.out.println("Tab " + tabbedPane.getTitleAt(tabbedPane.indexOfComponent(tabComponent)) + " closing");
            }

            @Override
            public void tabClosed(JTabbedPane tabbedPane, Component tabComponent) {
                System.out.println("Tab closed");
            }
        };
        SubstanceLookAndFeel.registerTabCloseChangeListener(this.listener);
        this.add((Component)jtp, "Center");
        JPanel controls = new JPanel(new FlowLayout(2));
        final JButton unregisterListener = new JButton("Unregister listener");
        unregisterListener.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        unregisterListener.setEnabled(false);
                        SubstanceLookAndFeel.unregisterTabCloseChangeListener(UnregisterTabCloseChangeListener_General.this.listener);
                    }
                });
            }
        });
        controls.add(unregisterListener);
        this.add((Component)controls, "South");
        this.setSize(400, 200);
        this.setLocationRelativeTo(null);
        this.setDefaultCloseOperation(3);
    }

    public static void main(String[] args) {
        JFrame.setDefaultLookAndFeelDecorated(true);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SubstanceLookAndFeel.setSkin(new BusinessBlackSteelSkin());
                new UnregisterTabCloseChangeListener_General().setVisible(true);
            }
        });
    }
}

