/*
 * Decompiled with CFR 0.152.
 */
package test.samples.substance.clientprop;

import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.pushingpixels.substance.api.SubstanceLookAndFeel;
import org.pushingpixels.substance.api.SubstanceSkin;
import org.pushingpixels.substance.api.skin.AutumnSkin;
import org.pushingpixels.substance.api.skin.BusinessBlackSteelSkin;
import org.pushingpixels.substance.api.skin.GraphiteSkin;

public class SkinProperty
extends JFrame {
    public SkinProperty() {
        super("Per-window skins");
        this.setLayout(new FlowLayout());
        JButton autumnSkin = new JButton("Autumn skin");
        autumnSkin.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SkinProperty.this.openSampleFrame(new AutumnSkin());
                    }
                });
            }
        });
        this.add(autumnSkin);
        JButton ravenGraphiteSkin = new JButton("Graphite skin");
        ravenGraphiteSkin.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SkinProperty.this.openSampleFrame(new GraphiteSkin());
                    }
                });
            }
        });
        this.add(ravenGraphiteSkin);
        this.setSize(400, 200);
        this.setLocationRelativeTo(null);
        this.setDefaultCloseOperation(3);
    }

    private void openSampleFrame(SubstanceSkin skin) {
        JFrame sampleFrame = new JFrame(skin.getDisplayName());
        sampleFrame.setLayout(new FlowLayout());
        JButton defaultButton = new JButton("active");
        JButton button = new JButton("default");
        JButton disabledButton = new JButton("disabled");
        disabledButton.setEnabled(false);
        sampleFrame.getRootPane().setDefaultButton(defaultButton);
        sampleFrame.add(defaultButton);
        sampleFrame.add(button);
        sampleFrame.add(disabledButton);
        sampleFrame.setVisible(true);
        sampleFrame.pack();
        sampleFrame.setLocationRelativeTo(null);
        sampleFrame.setDefaultCloseOperation(2);
        sampleFrame.getRootPane().putClientProperty("substancelaf.skin", skin);
        SwingUtilities.updateComponentTreeUI(sampleFrame);
        sampleFrame.repaint();
    }

    public static void main(String[] args) {
        JFrame.setDefaultLookAndFeelDecorated(true);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SubstanceLookAndFeel.setSkin(new BusinessBlackSteelSkin());
                new SkinProperty().setVisible(true);
            }
        });
    }
}

