/*
 * Decompiled with CFR 0.152.
 */
package tools.jitterbug;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.RenderingHints;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.InputStream;
import java.util.List;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.pushingpixels.substance.api.SubstanceColorScheme;
import org.pushingpixels.substance.api.SubstanceLookAndFeel;
import org.pushingpixels.substance.api.skin.BusinessSkin;
import org.pushingpixels.substance.internal.utils.SubstanceColorSchemeUtilities;
import tools.common.JImageComponent;
import tools.jitterbug.JColorComponent;
import tools.jitterbug.JColorSchemeComponent;
import tools.jitterbug.JColorSchemeList;
import tools.jitterbug.JHsvGraph;
import tools.jitterbug.StateChangeEvent;
import tools.jitterbug.StateChangeListener;
import tools.jitterbug.substance;

public class JitterbugEditor
extends JFrame
implements ClipboardOwner {
    private static final String APP_TITLE = "Jitterbug color scheme editor";
    private JColorSchemeList colorSchemeList;
    private JColorSchemeComponent colorSchemeComp;
    private JHsvGraph hsvGraph;

    public JitterbugEditor() {
        BufferedImage iconImage = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().createCompatibleImage(16, 16, 3);
        new JitterbugLogo().paintIcon(this, iconImage.getGraphics(), 0, 0);
        this.setIconImage(iconImage);
        FormLayout leftPanelLayout = new FormLayout("fill:pref", "fill:pref, fill:pref, fill:pref:grow, fill:pref");
        DefaultFormBuilder leftPanelBuilder = new DefaultFormBuilder(leftPanelLayout);
        this.colorSchemeList = new JColorSchemeList();
        this.colorSchemeList.setDropTarget(new DropTarget(this, new JitterbugDropHandler()));
        leftPanelBuilder.append(this.colorSchemeList);
        this.colorSchemeComp = new JColorSchemeComponent();
        this.colorSchemeComp.setEnabled(false);
        this.colorSchemeComp.setDropTarget(new DropTarget(this, new JitterbugDropHandler()));
        leftPanelBuilder.append(this.colorSchemeComp);
        this.hsvGraph = new JHsvGraph();
        this.hsvGraph.setDropTarget(new DropTarget(this, new JitterbugDropHandler()));
        leftPanelBuilder.append(this.hsvGraph);
        JPanel controlsPanel = new JPanel(new FlowLayout(4));
        final JButton saveButton = new JButton("save");
        saveButton.setIcon(new ImageIcon(JitterbugEditor.class.getClassLoader().getResource("tools/jitterbug/page_save.png")));
        saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JitterbugEditor.this.colorSchemeList.save();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        saveButton.setEnabled(false);
                    }
                });
            }
        });
        saveButton.setEnabled(false);
        controlsPanel.add(saveButton);
        JButton saveAsButton = new JButton("save as...");
        saveAsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JitterbugEditor.this.colorSchemeList.saveAs();
                JitterbugEditor.this.updateMainWindowTitle(JitterbugEditor.this.colorSchemeList.isModified());
            }
        });
        controlsPanel.add(saveAsButton);
        JButton newButton = new JButton("new");
        newButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JitterbugEditor.this.colorSchemeList.setColorSchemeList(null);
                JitterbugEditor.this.colorSchemeComp.clearContent();
                JitterbugEditor.this.updateMainWindowTitle(JitterbugEditor.this.colorSchemeList.isModified());
            }
        });
        controlsPanel.add(Box.createHorizontalStrut(20));
        controlsPanel.add(newButton);
        leftPanelBuilder.append(controlsPanel);
        JPanel leftPanel = leftPanelBuilder.getPanel();
        this.wireDragAndDrop(leftPanel);
        this.colorSchemeList.addPropertyChangeListener("selectedColorScheme", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                SubstanceColorScheme newSelection = (SubstanceColorScheme)evt.getNewValue();
                if (newSelection != null) {
                    JitterbugEditor.this.colorSchemeComp.setContent(newSelection);
                } else {
                    JitterbugEditor.this.colorSchemeComp.clearContent();
                }
            }
        });
        this.colorSchemeComp.addStateChangeListener(new StateChangeListener(){

            @Override
            public void stateChanged(StateChangeEvent event) {
                if (event.getStateChangeType() == StateChangeEvent.StateChangeType.MODIFIED) {
                    JitterbugEditor.this.colorSchemeList.setModified(true);
                }
                if (JitterbugEditor.this.colorSchemeComp.isDefined()) {
                    Color[] colors = new Color[]{JitterbugEditor.this.colorSchemeComp.getUltraLightColor(), JitterbugEditor.this.colorSchemeComp.getExtraLightColor(), JitterbugEditor.this.colorSchemeComp.getLightColor(), JitterbugEditor.this.colorSchemeComp.getMidColor(), JitterbugEditor.this.colorSchemeComp.getDarkColor(), JitterbugEditor.this.colorSchemeComp.getUltraDarkColor()};
                    JitterbugEditor.this.hsvGraph.setColors(colors);
                } else {
                    JitterbugEditor.this.hsvGraph.setColors(null);
                }
                if (event.getStateChangeType() == StateChangeEvent.StateChangeType.MODIFIED && JitterbugEditor.this.colorSchemeComp.isDefined()) {
                    boolean isLight = JitterbugEditor.this.colorSchemeComp.isLight();
                    Color ultraDark = JitterbugEditor.this.colorSchemeComp.getUltraDarkColor();
                    Color dark = JitterbugEditor.this.colorSchemeComp.getDarkColor();
                    Color mid = JitterbugEditor.this.colorSchemeComp.getMidColor();
                    Color light = JitterbugEditor.this.colorSchemeComp.getLightColor();
                    Color extraLight = JitterbugEditor.this.colorSchemeComp.getExtraLightColor();
                    Color ultraLight = JitterbugEditor.this.colorSchemeComp.getUltraLightColor();
                    Color foreground = JitterbugEditor.this.colorSchemeComp.getForegroundColor();
                    String name = JitterbugEditor.this.colorSchemeComp.getDisplayName();
                    Color[] colors = new Color[]{ultraLight, extraLight, light, mid, dark, ultraDark, foreground};
                    SubstanceColorScheme scheme = isLight ? SubstanceColorSchemeUtilities.getLightColorScheme(name, colors) : SubstanceColorSchemeUtilities.getDarkColorScheme(name, colors);
                    JitterbugEditor.this.colorSchemeList.updateColorScheme(scheme);
                }
            }
        });
        this.colorSchemeList.addPropertyChangeListener("modified", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                boolean isModified = (Boolean)evt.getNewValue();
                JitterbugEditor.this.getRootPane().putClientProperty("windowModified", isModified);
                JitterbugEditor.this.updateMainWindowTitle(isModified);
                File currFile = JitterbugEditor.this.colorSchemeList.getCurrentFile();
                saveButton.setEnabled(currFile != null);
            }
        });
        this.add((Component)leftPanel, "West");
        JPanel mainPanel = new JPanel(new BorderLayout());
        JImageComponent imageComp = new JImageComponent(true);
        imageComp.setLegend(new String[]{"Image panel. Use one of the following to show an image:", "\t* Right-click to paste an image from the clipboard", "\t* Drag and drop an image file from local disk or another app", "\t* Drag and drop a URL pointing to an image"});
        imageComp.addPropertyChangeListener("selectedColor", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Color selectedImageColor = (Color)evt.getNewValue();
                JColorComponent selectedColorComp = JitterbugEditor.this.colorSchemeComp.getSelectedColorComponent();
                if (selectedColorComp != null) {
                    selectedColorComp.setColor(selectedImageColor, true);
                }
            }
        });
        mainPanel.add((Component)imageComp, "Center");
        this.add((Component)mainPanel, "Center");
        this.setSize(800, 700);
        this.setExtendedState(6);
        this.setLocationRelativeTo(null);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (JitterbugEditor.this.colorSchemeList.checkModifiedStateAndSaveIfNecessary()) {
                    JitterbugEditor.this.dispose();
                }
            }
        });
        this.updateMainWindowTitle(false);
    }

    private void wireDragAndDrop(Component comp) {
        comp.setDropTarget(new DropTarget(this, new JitterbugDropHandler()));
        if (comp instanceof Container) {
            Container cont = (Container)comp;
            int i = 0;
            while (i < cont.getComponentCount()) {
                this.wireDragAndDrop(cont.getComponent(i));
                ++i;
            }
        }
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable contents) {
    }

    private void updateMainWindowTitle(boolean isModified) {
        File schemesFile = this.colorSchemeList.getCurrentFile();
        String title = "Jitterbug color scheme editor - ";
        if (isModified) {
            title = String.valueOf(title) + "* ";
        }
        title = schemesFile != null ? String.valueOf(title) + schemesFile.getAbsolutePath() : String.valueOf(title) + "Unsaved";
        this.setTitle(title);
    }

    public static void main(String[] args) {
        JDialog.setDefaultLookAndFeelDecorated(true);
        JFrame.setDefaultLookAndFeelDecorated(true);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SubstanceLookAndFeel.setSkin(new BusinessSkin());
                new JitterbugEditor().setVisible(true);
            }
        });
    }

    protected class JitterbugDropHandler
    extends DropTargetAdapter {
        protected JitterbugDropHandler() {
        }

        @Override
        public void drop(DropTargetDropEvent dtde) {
            Transferable t = dtde.getTransferable();
            if (t.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                try {
                    dtde.acceptDrop(3);
                    List files = (List)t.getTransferData(DataFlavor.javaFileListFlavor);
                    File f = (File)files.get(0);
                    System.out.println("Reading from " + f.getAbsolutePath());
                    JitterbugEditor.this.colorSchemeList.setColorSchemeList(f);
                    JitterbugEditor.this.colorSchemeComp.clearContent();
                    dtde.dropComplete(true);
                    JitterbugEditor.this.setTitle("Jitterbug color scheme editor - " + f.getAbsolutePath());
                    return;
                }
                catch (Exception exc) {
                    exc.printStackTrace();
                }
            }
        }

        @Override
        public void dragEnter(DropTargetDragEvent dtde) {
            DataFlavor[] dataFlavorArray = dtde.getCurrentDataFlavors();
            int n = dataFlavorArray.length;
            int n2 = 0;
            while (n2 < n) {
                DataFlavor df = dataFlavorArray[n2];
                Class<?> repClass = df.getDefaultRepresentationClass();
                boolean canDrop = InputStream.class.isAssignableFrom(repClass);
                if (canDrop) {
                    dtde.acceptDrag(3);
                    return;
                }
                ++n2;
            }
        }
    }

    private class JitterbugLogo
    implements Icon {
        private JitterbugLogo() {
        }

        @Override
        public int getIconHeight() {
            return 16;
        }

        @Override
        public int getIconWidth() {
            return 16;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            Graphics2D g2d = (Graphics2D)g.create();
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2d.translate(x, y);
            double coef1 = (double)this.getIconWidth() / (double)substance.getOrigWidth();
            double coef2 = (double)this.getIconHeight() / (double)substance.getOrigHeight();
            double coef = Math.min(coef1, coef2);
            g2d.scale(coef, coef);
            g2d.translate(substance.getOrigX(), substance.getOrigY());
            substance.paint(g2d);
            g2d.dispose();
        }
    }
}

