/*
 * Decompiled with CFR 0.152.
 */
package com.wapmx.nativeutils.jniloader;

import com.wapmx.nativeutils.jniloader.JniExtractor;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;

public class DefaultJniExtractor
implements JniExtractor {
    private static boolean debug = false;
    private File jniDir = null;
    private static Map _cache;

    public File getJniDir() throws IOException {
        String[] absLibPaths = new String[]{"/Applications/Sikuli-IDE.app/Contents/Frameworks", System.getenv("SIKULI_HOME") + "libs"};
        String[] relLibPaths = new String[]{"Sikuli-IDE.app/Contents/Frameworks", "libs"};
        Vector<String> libPaths = new Vector<String>(Arrays.asList(relLibPaths));
        String isTesting = System.getProperty("sikuli.testing");
        if (isTesting == null || !isTesting.equals("yes")) {
            libPaths.addAll(Arrays.asList(absLibPaths));
        }
        if (this.jniDir == null) {
            for (String path : libPaths) {
                this.jniDir = new File(path);
                if (!this.jniDir.exists()) continue;
                System.setProperty("java.library.tmpdir", path);
                return this.jniDir;
            }
            String tmpdir = System.getProperty("java.io.tmpdir") + "/tmplib";
            this.jniDir = new File(System.getProperty("java.library.tmpdir", tmpdir));
            if (debug) {
                System.err.println("Initialised JNI library working directory to '" + this.jniDir + "'");
            }
        }
        if (!this.jniDir.exists() && !this.jniDir.mkdirs()) {
            throw new IOException("Unable to create JNI library working directory " + this.jniDir);
        }
        return this.jniDir;
    }

    public File extractJni(String libname) throws IOException {
        String mappedlib = System.mapLibraryName(libname);
        if (mappedlib.endsWith(".jnilib") && this.getClass().getClassLoader().getResource("META-INF/lib/" + mappedlib) == null) {
            mappedlib = mappedlib.substring(0, mappedlib.length() - 7) + ".dylib";
        }
        if (_cache.containsKey(mappedlib)) {
            if (debug) {
                System.err.println("in cache " + mappedlib);
            }
            return (File)_cache.get(mappedlib);
        }
        if (debug) {
            System.err.println("not in cache " + mappedlib);
        }
        File ret = this.extractResource("META-INF/lib/" + mappedlib, mappedlib);
        _cache.put(mappedlib, ret);
        return ret;
    }

    File extractResource(String resourcename, String outputname) throws IOException {
        InputStream in = this.getClass().getClassLoader().getResourceAsStream(resourcename);
        if (in == null) {
            throw new IOException("Unable to find library " + resourcename + " on classpath");
        }
        File outfile = new File(this.getJniDir(), outputname);
        if (debug) {
            System.err.println("Extracting '" + resourcename + "' to '" + outfile.getAbsolutePath() + "'");
        }
        if (!outfile.exists() || outfile.getParent().endsWith("tmplib")) {
            FileOutputStream out = new FileOutputStream(outfile);
            DefaultJniExtractor.copy(in, out);
            ((OutputStream)out).close();
        }
        in.close();
        return outfile;
    }

    static void copy(InputStream in, OutputStream out) throws IOException {
        byte[] tmp = new byte[8192];
        int len = 0;
        while ((len = in.read(tmp)) > 0) {
            out.write(tmp, 0, len);
        }
    }

    static {
        String s = System.getProperty("java.library.debug");
        if (s != null && (s.toLowerCase().startsWith("y") || s.startsWith("1"))) {
            debug = true;
        }
        _cache = new HashMap();
        if (debug) {
            System.err.println("cache " + _cache);
        }
    }
}

