/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.script;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsDevice;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.image.BufferedImage;
import java.awt.image.RasterFormatException;
import java.awt.image.RescaleOp;
import org.sikuli.script.Animator;
import org.sikuli.script.Debug;
import org.sikuli.script.Env;
import org.sikuli.script.LinearAnimator;
import org.sikuli.script.OS;
import org.sikuli.script.Observer;
import org.sikuli.script.Screen;
import org.sikuli.script.ScreenImage;
import org.sikuli.script.Subject;
import org.sikuli.script.TransparentWindow;
import org.sikuli.script.UnionScreen;

public class CapturePrompt
extends TransparentWindow
implements Subject {
    static Color _overlayColor = new Color(0.0f, 0.0f, 0.0f, 0.6f);
    static final float MIN_DARKER_FACTOR = 0.6f;
    static final long MSG_DISPLAY_TIME = 2000L;
    static final long WIN_FADE_IN_TIME = 200L;
    static GraphicsDevice _gdev = null;
    Observer _obs;
    Screen _scr;
    BufferedImage _scr_img = null;
    BufferedImage _darker_screen = null;
    float _darker_factor;
    Rectangle rectSelection;
    BasicStroke bs;
    int srcScreenId = 0;
    int srcx;
    int srcy;
    int destx;
    int desty;
    boolean _canceled = false;
    Animator _aniMsg;
    Animator _aniWin;
    String _msg;
    BasicStroke _StrokeCross = new BasicStroke(1.0f, 1, 1, 1.0f, new float[]{2.0f}, 0.0f);
    private Color selFrameColor = new Color(1.0f, 1.0f, 1.0f, 1.0f);
    private Color selCrossColor = new Color(1.0f, 0.0f, 0.0f, 0.6f);
    private Color screenFrameColor = new Color(1.0f, 0.0f, 0.0f, 0.6f);
    BasicStroke strokeScreenFrame = new BasicStroke(5.0f);
    static Font fontMsg = new Font("Arial", 0, 60);
    BufferedImage bi = null;

    @Override
    public void addObserver(Observer observer) {
        this._obs = observer;
    }

    @Override
    public void notifyObserver() {
        this._obs.update(this);
    }

    private void captureScreen(Screen screen) {
        ScreenImage screenImage = screen.capture();
        this._scr_img = screenImage.getImage();
        this._darker_factor = 0.6f;
        RescaleOp rescaleOp = new RescaleOp(this._darker_factor, 0.0f, null);
        this._darker_screen = rescaleOp.filter(this._scr_img, null);
    }

    private void drawScreenFrame(Graphics2D graphics2D, int n) {
        Rectangle rectangle = Screen.getBounds(n);
        Rectangle rectangle2 = new UnionScreen().getBounds();
        graphics2D.setColor(this.screenFrameColor);
        graphics2D.setStroke(this.strokeScreenFrame);
        rectangle.x -= rectangle2.x;
        rectangle.y -= rectangle2.y;
        int n2 = (int)(this.strokeScreenFrame.getLineWidth() / 2.0f);
        rectangle.x += n2;
        rectangle.y += n2;
        rectangle.width -= n2 * 2;
        rectangle.height -= n2 * 2;
        graphics2D.draw(rectangle);
    }

    private void drawSelection(Graphics2D graphics2D) {
        if (this.srcx != this.destx || this.srcy != this.desty) {
            int n;
            int n2 = this.srcx < this.destx ? this.srcx : this.destx;
            int n3 = this.srcy < this.desty ? this.srcy : this.desty;
            int n4 = this.srcx > this.destx ? this.srcx : this.destx;
            int n5 = n = this.srcy > this.desty ? this.srcy : this.desty;
            if (Screen.getNumberScreens() > 1) {
                Rectangle rectangle = new Rectangle(n2, n3, n4 - n2, n - n3);
                Rectangle rectangle2 = new UnionScreen().getBounds();
                rectangle.x += rectangle2.x;
                rectangle.y += rectangle2.y;
                Rectangle rectangle3 = rectangle.intersection(Screen.getBounds(this.srcScreenId));
                n2 = rectangle3.x - rectangle2.x;
                n3 = rectangle3.y - rectangle2.y;
                n4 = n2 + rectangle3.width - 1;
                n = n3 + rectangle3.height - 1;
            }
            this.rectSelection.x = n2;
            this.rectSelection.y = n3;
            this.rectSelection.width = n4 - n2 + 1;
            this.rectSelection.height = n - n3 + 1;
            if (this.rectSelection.width > 0 && this.rectSelection.height > 0) {
                graphics2D.drawImage(this._scr_img.getSubimage(n2, n3, n4 - n2 + 1, n - n3 + 1), null, n2, n3);
            }
            graphics2D.setColor(this.selFrameColor);
            graphics2D.setStroke(this.bs);
            graphics2D.draw(this.rectSelection);
            int n6 = (n2 + n4) / 2;
            int n7 = (n3 + n) / 2;
            graphics2D.setColor(this.selCrossColor);
            graphics2D.setStroke(this._StrokeCross);
            graphics2D.drawLine(n6, n3, n6, n);
            graphics2D.drawLine(n2, n7, n4, n7);
            if (Screen.getNumberScreens() > 1) {
                this.drawScreenFrame(graphics2D, this.srcScreenId);
            }
        }
    }

    void drawMessage(Graphics2D graphics2D) {
        if (this._msg == null) {
            return;
        }
        if (this._aniMsg.running()) {
            float f = this._aniMsg.step();
            graphics2D.setFont(fontMsg);
            graphics2D.setColor(new Color(1.0f, 1.0f, 1.0f, f));
            int n = graphics2D.getFontMetrics().stringWidth(this._msg);
            int n2 = graphics2D.getFontMetrics().getMaxAscent();
            Rectangle rectangle = new UnionScreen().getBounds();
            for (int i = 0; i < Screen.getNumberScreens(); ++i) {
                Rectangle rectangle2 = Screen.getBounds(i);
                int n3 = rectangle2.x + (rectangle2.width - n) / 2 - rectangle.x;
                int n4 = rectangle2.y + (rectangle2.height - n2) / 2 - rectangle.y;
                graphics2D.drawString(this._msg, n3, n4);
            }
            this.repaint();
        }
    }

    @Override
    public void paint(Graphics graphics) {
        if (this._scr_img != null) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            if (this.bi == null || this.bi.getWidth(this) != this.getWidth() || this.bi.getHeight(this) != this.getHeight()) {
                this.bi = new BufferedImage(this.getWidth(), this.getHeight(), 1);
            }
            Graphics2D graphics2D2 = this.bi.createGraphics();
            graphics2D2.drawImage((Image)this._darker_screen, 0, 0, this);
            this.drawMessage(graphics2D2);
            this.drawSelection(graphics2D2);
            graphics2D.drawImage((Image)this.bi, 0, 0, this);
            this.setVisible(true);
            if (this._aniWin != null && this._aniWin.running()) {
                float f = this._aniWin.step();
                this.setOpacity(f);
                this.repaint();
            }
        } else {
            this.setVisible(false);
        }
    }

    void init() {
        this._canceled = false;
        this.setCursor(Cursor.getPredefinedCursor(1));
        this.rectSelection = new Rectangle();
        this.bs = new BasicStroke(1.0f);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (CapturePrompt.this._scr_img == null) {
                    return;
                }
                CapturePrompt.this.destx = CapturePrompt.this.srcx = mouseEvent.getX();
                CapturePrompt.this.desty = CapturePrompt.this.srcy = mouseEvent.getY();
                CapturePrompt.this.srcScreenId = new UnionScreen().getIdFromPoint(CapturePrompt.this.srcx, CapturePrompt.this.srcy);
                Debug.log(3, "pressed " + CapturePrompt.this.srcx + "," + CapturePrompt.this.srcy + " at screen " + CapturePrompt.this.srcScreenId, new Object[0]);
                CapturePrompt.this.repaint();
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                if (CapturePrompt.this._scr_img == null) {
                    return;
                }
                if (mouseEvent.getButton() == 3) {
                    CapturePrompt.this._canceled = true;
                    CapturePrompt.this.notifyObserver();
                    CapturePrompt.this.close();
                } else {
                    CapturePrompt.this.notifyObserver();
                }
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent mouseEvent) {
                if (CapturePrompt.this._scr_img == null) {
                    return;
                }
                CapturePrompt.this.destx = mouseEvent.getX();
                CapturePrompt.this.desty = mouseEvent.getY();
                CapturePrompt.this.repaint();
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 27) {
                    CapturePrompt.this._canceled = true;
                    CapturePrompt.this.notifyObserver();
                    CapturePrompt.this.close();
                }
            }
        });
    }

    @Override
    public void close() {
        if (_gdev != null) {
            try {
                _gdev.setFullScreenWindow(null);
            }
            catch (Exception exception) {
                Debug.log("Switch to windowed mode failed: " + exception.getMessage(), new Object[0]);
            }
        }
        this.setVisible(false);
        this.dispose();
    }

    private BufferedImage cropSelection() {
        int n = this.rectSelection.width;
        int n2 = this.rectSelection.height;
        if (n <= 0 || n2 <= 0) {
            return null;
        }
        BufferedImage bufferedImage = new BufferedImage(n, n2, 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        try {
            graphics2D.drawImage(this._scr_img.getSubimage(this.rectSelection.x, this.rectSelection.y, n, n2), null, 0, 0);
        }
        catch (RasterFormatException rasterFormatException) {
            rasterFormatException.printStackTrace();
        }
        graphics2D.dispose();
        return bufferedImage;
    }

    public ScreenImage getSelection() {
        if (this._canceled) {
            return null;
        }
        BufferedImage bufferedImage = this.cropSelection();
        if (bufferedImage == null) {
            return null;
        }
        this.rectSelection.x += this._scr.x;
        this.rectSelection.y += this._scr.y;
        ScreenImage screenImage = new ScreenImage(this.rectSelection, bufferedImage);
        return screenImage;
    }

    public void prompt(String string, int n) {
        try {
            Thread.sleep(n);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.prompt(string);
    }

    public void prompt(int n) {
        this.prompt(null, n);
    }

    public void prompt() {
        this.prompt(null);
    }

    public void prompt(String string) {
        Debug.log(3, "starting CapturePrompt @" + this._scr, new Object[0]);
        this.captureScreen(this._scr);
        this.setLocation(this._scr.x, this._scr.y);
        this.setSize(new Dimension(this._scr.w, this._scr.h));
        this.setBounds(this._scr.x, this._scr.y, this._scr.w, this._scr.h);
        this.setAlwaysOnTop(true);
        this._msg = string;
        this._aniMsg = new LinearAnimator(1.0f, 0.0f, 2000L);
        if (Env.getOS() == OS.MAC || Env.getOS() == OS.WINDOWS) {
            this._aniWin = new LinearAnimator(0.0f, 1.0f, 200L);
            this.setOpacity(0.0f);
            this.getRootPane().putClientProperty("Window.shadow", Boolean.FALSE);
            this.setVisible(true);
            if (Env.getOS() == OS.MAC) {
                Env.getOSUtil().bringWindowToFront(this, false);
            }
        } else {
            this.setVisible(true);
        }
        if (this._scr.useFullscreen()) {
            _gdev = this._scr.getGraphicsDevice();
            if (_gdev.isFullScreenSupported()) {
                _gdev.setFullScreenWindow(this);
            } else {
                Debug.log("Fullscreen mode is not supported.", new Object[0]);
            }
        }
        this.requestFocus();
    }

    public CapturePrompt(Screen screen, Observer observer) {
        this(screen);
        this.addObserver(observer);
    }

    public CapturePrompt(Screen screen) {
        if (screen == null) {
            screen = Screen.getNumberScreens() > 1 ? new UnionScreen() : new Screen();
        }
        this._scr = screen;
        this.init();
    }
}

