/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.script;

import java.awt.Toolkit;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringBufferInputStream;
import java.io.StringReader;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;

public class Clipboard {
    public static final TextType HTML = new TextType("text/html");
    public static final TextType PLAIN = new TextType("text/plain");
    public static final Charset UTF8 = new Charset("UTF-8");
    public static final Charset UTF16 = new Charset("UTF-16");
    public static final Charset UNICODE = new Charset("unicode");
    public static final Charset US_ASCII = new Charset("US-ASCII");
    public static final TransferType READER = new TransferType(Reader.class);
    public static final TransferType INPUT_STREAM = new TransferType(InputStream.class);
    public static final TransferType CHAR_BUFFER = new TransferType(CharBuffer.class);
    public static final TransferType BYTE_BUFFER = new TransferType(ByteBuffer.class);

    private Clipboard() {
    }

    public static void putText(CharSequence charSequence) {
        StringSelection stringSelection = new StringSelection(((Object)charSequence).toString());
        Clipboard.getSystemClipboard().setContents(stringSelection, stringSelection);
    }

    public static void putText(TextType textType, Charset charset, TransferType transferType, CharSequence charSequence) {
        String string = textType + "; charset=" + charset + "; class=" + transferType;
        TextTransferable textTransferable = new TextTransferable(string, ((Object)charSequence).toString());
        Clipboard.getSystemClipboard().setContents(textTransferable, textTransferable);
    }

    public static java.awt.datatransfer.Clipboard getSystemClipboard() {
        return Toolkit.getDefaultToolkit().getSystemClipboard();
    }

    public static class TransferType {
        private Class dataClass;

        private TransferType(Class clazz) {
            this.dataClass = clazz;
        }

        public Class getDataClass() {
            return this.dataClass;
        }

        public String toString() {
            return this.dataClass.getName();
        }
    }

    public static class Charset {
        private String name;

        private Charset(String string) {
            this.name = string;
        }

        public String toString() {
            return this.name;
        }
    }

    public static class TextType {
        private String type;

        private TextType(String string) {
            this.type = string;
        }

        public String toString() {
            return this.type;
        }
    }

    private static class TextTransferable
    implements Transferable,
    ClipboardOwner {
        private String data;
        private DataFlavor flavor;

        public TextTransferable(String string, String string2) {
            this.flavor = new DataFlavor(string, "Text");
            this.data = string2;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{this.flavor, DataFlavor.stringFlavor};
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
            boolean bl = this.flavor.getPrimaryType().equals(dataFlavor.getPrimaryType());
            return bl || dataFlavor.equals(DataFlavor.stringFlavor);
        }

        @Override
        public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
            if (dataFlavor.isRepresentationClassInputStream()) {
                return new StringBufferInputStream(this.data);
            }
            if (dataFlavor.isRepresentationClassReader()) {
                return new StringReader(this.data);
            }
            if (dataFlavor.isRepresentationClassCharBuffer()) {
                return CharBuffer.wrap(this.data);
            }
            if (dataFlavor.isRepresentationClassByteBuffer()) {
                return ByteBuffer.wrap(this.data.getBytes());
            }
            if (dataFlavor.equals(DataFlavor.stringFlavor)) {
                return this.data;
            }
            throw new UnsupportedFlavorException(dataFlavor);
        }

        @Override
        public void lostOwnership(java.awt.datatransfer.Clipboard clipboard, Transferable transferable) {
        }
    }
}

