/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.script;

import java.awt.AWTException;
import java.awt.GraphicsDevice;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.image.BufferedImage;
import org.sikuli.script.Env;
import org.sikuli.script.IRobot;
import org.sikuli.script.Key;
import org.sikuli.script.Location;
import org.sikuli.script.OS;
import org.sikuli.script.OutQuarticEase;
import org.sikuli.script.ScreenImage;
import org.sikuli.script.Settings;
import org.sikuli.script.TimeBasedAnimator;

public class DesktopRobot
extends Robot
implements IRobot {
    static final int MAX_DELAY = 60000;

    public DesktopRobot(GraphicsDevice graphicsDevice) throws AWTException {
        super(graphicsDevice);
    }

    @Override
    public void smoothMove(Location location) {
        this.smoothMove(Env.getMouseLocation(), location, (long)(Settings.MoveMouseDelay * 1000.0f));
    }

    @Override
    public void smoothMove(Location location, Location location2, long l) {
        if (l == 0L) {
            this.mouseMove(location2.x, location2.y);
            return;
        }
        TimeBasedAnimator timeBasedAnimator = new TimeBasedAnimator(new OutQuarticEase(location.x, location2.x, l));
        TimeBasedAnimator timeBasedAnimator2 = new TimeBasedAnimator(new OutQuarticEase(location.y, location2.y, l));
        while (timeBasedAnimator.running()) {
            float f = timeBasedAnimator.step();
            float f2 = timeBasedAnimator2.step();
            this.mouseMove((int)f, (int)f2);
            this.delay(50);
        }
    }

    @Override
    public void dragDrop(Location location, Location location2, int n, long l, int n2) {
        this.mouseMove(location.x, location.y);
        this.mousePress(n2);
        this.delay((int)(Settings.DelayAfterDrag * 1000.0));
        this.waitForIdle();
        this.smoothMove(location, location2, l);
        this.delay((int)(Settings.DelayBeforeDrop * 1000.0));
        this.mouseRelease(n2);
        this.waitForIdle();
    }

    @Override
    public void delay(int n) {
        if (n < 0) {
            n = 0;
        }
        while (n > 60000) {
            super.delay(60000);
            n -= 60000;
        }
        super.delay(n);
    }

    @Override
    public ScreenImage captureScreen(Rectangle rectangle) {
        BufferedImage bufferedImage = this.createScreenCapture(rectangle);
        return new ScreenImage(rectangle, bufferedImage);
    }

    @Override
    public void pressModifiers(int n) {
        if ((n & 1) != 0) {
            this.keyPress(16);
        }
        if ((n & 2) != 0) {
            this.keyPress(17);
        }
        if ((n & 8) != 0) {
            this.keyPress(18);
        }
        if ((n & 4) != 0) {
            if (Env.getOS() == OS.WINDOWS) {
                this.keyPress(524);
            } else {
                this.keyPress(157);
            }
        }
    }

    @Override
    public void releaseModifiers(int n) {
        if ((n & 1) != 0) {
            this.keyRelease(16);
        }
        if ((n & 2) != 0) {
            this.keyRelease(17);
        }
        if ((n & 8) != 0) {
            this.keyRelease(18);
        }
        if ((n & 4) != 0) {
            if (Env.getOS() == OS.WINDOWS) {
                this.keyRelease(524);
            } else {
                this.keyRelease(157);
            }
        }
    }

    protected void doType(IRobot.KeyMode keyMode, int ... nArray) {
        if (keyMode == IRobot.KeyMode.PRESS_ONLY) {
            for (int i = 0; i < nArray.length; ++i) {
                this.keyPress(nArray[i]);
            }
        } else if (keyMode == IRobot.KeyMode.RELEASE_ONLY) {
            for (int i = 0; i < nArray.length; ++i) {
                this.keyRelease(nArray[i]);
            }
        } else {
            int n;
            for (n = 0; n < nArray.length; ++n) {
                this.keyPress(nArray[n]);
            }
            for (n = 0; n < nArray.length; ++n) {
                this.keyRelease(nArray[n]);
            }
        }
    }

    @Override
    public void typeChar(char c, IRobot.KeyMode keyMode) {
        this.doType(keyMode, Key.toJavaKeyCode(c));
    }

    @Override
    public Object getDevice() {
        return null;
    }
}

