/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.script;

import java.awt.AWTException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.sikuli.script.AppearEvent;
import org.sikuli.script.ChangeEvent;
import org.sikuli.script.Debug;
import org.sikuli.script.Finder;
import org.sikuli.script.Match;
import org.sikuli.script.OpenCV;
import org.sikuli.script.Pattern;
import org.sikuli.script.Region;
import org.sikuli.script.ScreenImage;
import org.sikuli.script.Settings;
import org.sikuli.script.SikuliEventObserver;
import org.sikuli.script.VanishEvent;
import org.sikuli.script.natives.FindInput;
import org.sikuli.script.natives.FindResult;
import org.sikuli.script.natives.FindResults;
import org.sikuli.script.natives.Mat;
import org.sikuli.script.natives.Vision;

public class EventManager {
    private Region _region;
    private Mat _lastImgMat = null;
    private Map<Object, State> _state;
    private Map<Object, Match> _lastMatch;
    private Map<Object, SikuliEventObserver> _appearOb;
    private Map<Object, SikuliEventObserver> _vanishOb;
    private Map<Integer, SikuliEventObserver> _changeOb;
    private int _minChanges;

    public EventManager(Region region) {
        this._region = region;
        this._state = new HashMap<Object, State>();
        this._lastMatch = new HashMap<Object, Match>();
        this._appearOb = new HashMap<Object, SikuliEventObserver>();
        this._vanishOb = new HashMap<Object, SikuliEventObserver>();
        this._changeOb = new HashMap<Integer, SikuliEventObserver>();
    }

    private <PSC> float getSimiliarity(PSC PSC) {
        float f = -1.0f;
        if (PSC instanceof Pattern) {
            f = ((Pattern)PSC).similarity;
        }
        if (f < 0.0f) {
            f = (float)Settings.MinSimilarity;
        }
        return f;
    }

    public <PSC> void addAppearObserver(PSC PSC, SikuliEventObserver sikuliEventObserver) {
        this._appearOb.put(PSC, sikuliEventObserver);
        this._state.put(PSC, State.UNKNOWN);
    }

    public <PSC> void addVanishObserver(PSC PSC, SikuliEventObserver sikuliEventObserver) {
        this._vanishOb.put(PSC, sikuliEventObserver);
        this._state.put(PSC, State.UNKNOWN);
    }

    public void addChangeObserver(int n, SikuliEventObserver sikuliEventObserver) {
        this._changeOb.put(new Integer(n), sikuliEventObserver);
        this._minChanges = this.getMinChanges();
    }

    protected void callAppearObserver(Object object, Match match) {
        AppearEvent appearEvent = new AppearEvent(object, match, this._region);
        SikuliEventObserver sikuliEventObserver = this._appearOb.get(object);
        sikuliEventObserver.targetAppeared(appearEvent);
    }

    protected void callVanishObserver(Object object, Match match) {
        VanishEvent vanishEvent = new VanishEvent(object, match, this._region);
        SikuliEventObserver sikuliEventObserver = this._vanishOb.get(object);
        sikuliEventObserver.targetVanished(vanishEvent);
    }

    protected void checkPatterns(ScreenImage screenImage) {
        Finder finder = new Finder(screenImage, this._region);
        for (Object object : this._state.keySet()) {
            try {
                finder.find(object);
                Match match = null;
                boolean bl = false;
                if (finder.hasNext() && (match = finder.next()).getScore() >= (double)this.getSimiliarity(object)) {
                    bl = true;
                    this._lastMatch.put(object, match);
                }
                Debug.log(9, "check pattern: " + (Object)((Object)this._state.get(object)) + " match:" + bl, new Object[0]);
                if (this._appearOb.containsKey(object) && this._state.get(object) != State.APPEARED && bl) {
                    this.callAppearObserver(object, match);
                }
                if (this._vanishOb.containsKey(object) && this._state.get(object) != State.VANISHED && !bl) {
                    this.callVanishObserver(object, this._lastMatch.get(object));
                }
                if (bl) {
                    this._state.put(object, State.APPEARED);
                    continue;
                }
                this._state.put(object, State.VANISHED);
            }
            catch (IOException iOException) {
                Debug.error("Can't access " + object + "\n" + iOException.getMessage(), new Object[0]);
            }
        }
    }

    protected void callChangeObserver(FindResults findResults) throws AWTException {
        for (Integer n : this._changeOb.keySet()) {
            Object object;
            ArrayList<Match> arrayList = new ArrayList<Match>();
            int n2 = 0;
            while ((long)n2 < findResults.size()) {
                object = findResults.get(n2);
                if (((FindResult)object).getW() * ((FindResult)object).getH() >= n) {
                    arrayList.add(this._region.toGlobalCoord(new Match((FindResult)object, this._region.getScreen())));
                }
                ++n2;
            }
            if (arrayList.size() <= 0) continue;
            ChangeEvent changeEvent = new ChangeEvent(arrayList, this._region);
            object = this._changeOb.get(n);
            object.targetChanged(changeEvent);
        }
    }

    protected int getMinChanges() {
        int n = Integer.MAX_VALUE;
        for (Integer n2 : this._changeOb.keySet()) {
            if (n2 >= n) continue;
            n = n2;
        }
        return n;
    }

    protected void checkChanges(ScreenImage screenImage) {
        if (this._lastImgMat == null) {
            this._lastImgMat = OpenCV.convertBufferedImageToMat(screenImage.getImage());
            return;
        }
        FindInput findInput = new FindInput();
        findInput.setSource(this._lastImgMat);
        Mat mat = OpenCV.convertBufferedImageToMat(screenImage.getImage());
        findInput.setTarget(mat);
        findInput.setSimilarity(this._minChanges);
        FindResults findResults = Vision.findChanges(findInput);
        try {
            this.callChangeObserver(findResults);
        }
        catch (AWTException aWTException) {
            aWTException.printStackTrace();
        }
        this._lastImgMat = mat;
    }

    public void update(ScreenImage screenImage) {
        this.checkPatterns(screenImage);
        if (this._changeOb.size() > 0) {
            this.checkChanges(screenImage);
        }
    }

    protected void finalize() throws Throwable {
    }

    public void dispose() {
    }

    protected static enum State {
        UNKNOWN,
        APPEARED,
        VANISHED;

    }
}

