/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.script;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.regex.Pattern;
import org.sikuli.script.Debug;
import org.sikuli.script.Env;
import org.sikuli.script.Extension;
import org.sikuli.script.Util;

public class ExtensionManager {
    protected static final String EXT_LIST_FILE = ".ext-list";
    protected static ExtensionManager _instance = null;
    protected File _extListFile = new File(this.getUserExtPath(), ".ext-list");
    protected ArrayList<Extension> _extensions;

    public static ExtensionManager getInstance() {
        if (_instance == null) {
            _instance = new ExtensionManager();
        }
        return _instance;
    }

    protected void readExtList() {
        try {
            FileInputStream fileInputStream = new FileInputStream(this._extListFile);
            ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
            this._extensions = (ArrayList)objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (Exception exception) {
            this._extensions = new ArrayList();
        }
    }

    protected void updateExtList() throws IOException, ClassNotFoundException {
        FileOutputStream fileOutputStream = new FileOutputStream(this._extListFile);
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
        objectOutputStream.writeObject(this._extensions);
        objectOutputStream.close();
    }

    protected ExtensionManager() {
        this.readExtList();
    }

    protected Extension find(String string) {
        for (Extension extension : this._extensions) {
            if (!extension.name.equals(string)) continue;
            return extension;
        }
        return null;
    }

    protected void addExtension(String string, String string2, String string3) {
        Extension extension = this.find(string);
        if (extension != null) {
            this._extensions.remove(extension);
        }
        Extension extension2 = new Extension(string, string2, string3);
        this._extensions.add(extension2);
        try {
            this.updateExtList();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public String getVersion(String string) {
        Extension extension = this.find(string);
        if (extension != null) {
            return extension.version;
        }
        return null;
    }

    public boolean isOutOfDate(String string, String string2) {
        String string3;
        Extension extension = this.find(string);
        if (extension == null) {
            return false;
        }
        String string4 = ExtensionManager.normalisedVersion(extension.version);
        int n = string4.compareTo(string3 = ExtensionManager.normalisedVersion(string2));
        return n < 0;
    }

    public boolean isInstalled(String string) {
        Extension extension = this.find(string);
        return extension != null;
    }

    private String getExtName(String string) {
        int n = string.lastIndexOf("-");
        if (n >= 0) {
            return string.substring(0, n) + ".jar";
        }
        return string;
    }

    public boolean install(String string, String string2, String string3) {
        String string4 = this.getUserExtPath();
        String string5 = System.getProperty("java.io.tmpdir");
        try {
            URL uRL = new URL(string2);
            File file = new File(Util.downloadURL(uRL, string5));
            String string6 = this.getExtName(file.getName());
            File file2 = new File(string4, string6);
            if (file2.exists()) {
                file2.delete();
            }
            if (!file.renameTo(file2)) {
                Debug.error("Failed to install " + file.getName() + " to " + file2.getAbsolutePath(), new Object[0]);
                return false;
            }
            this.addExtension(string, string2, string3);
        }
        catch (IOException iOException) {
            Debug.error("Failed to download " + string2, new Object[0]);
            iOException.printStackTrace();
            return false;
        }
        return true;
    }

    public String getUserExtPath() {
        String string = Env.getSikuliDataPath() + File.separator + "extensions";
        File file = new File(string);
        if (!file.exists()) {
            file.mkdirs();
        }
        return string;
    }

    public static String normalisedVersion(String string) {
        return ExtensionManager.normalisedVersion(string, ".", 4);
    }

    public static String normalisedVersion(String string, String string2, int n) {
        String[] stringArray = Pattern.compile(string2, 16).split(string);
        StringBuilder stringBuilder = new StringBuilder();
        for (String string3 : stringArray) {
            stringBuilder.append(String.format("%" + n + 's', string3));
        }
        return stringBuilder.toString();
    }
}

