/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.script;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.sikuli.script.Debug;
import org.sikuli.script.FindFailedResponse;
import org.sikuli.script.ImageLocator;
import org.sikuli.script.Pattern;

class FindFailedDialog
extends JDialog
implements ActionListener {
    JButton retryButton;
    JButton skipButton;
    JButton abortButton;
    FindFailedResponse _response;

    public <PSC> FindFailedDialog(PSC PSC) {
        this.setModal(true);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        Component component = this.createTargetComponent(PSC);
        jPanel.add(component, "North");
        JPanel jPanel2 = new JPanel();
        this.retryButton = new JButton("Retry");
        this.retryButton.addActionListener(this);
        this.skipButton = new JButton("Skip");
        this.skipButton.addActionListener(this);
        this.abortButton = new JButton("Abort");
        this.abortButton.addActionListener(this);
        jPanel2.add(this.retryButton);
        jPanel2.add(this.skipButton);
        jPanel2.add(this.abortButton);
        jPanel.add((Component)jPanel2, "South");
        this.add(jPanel);
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                FindFailedDialog.this._response = FindFailedResponse.ABORT;
            }
        });
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (this.retryButton == actionEvent.getSource()) {
            this._response = FindFailedResponse.RETRY;
        } else if (this.abortButton == actionEvent.getSource()) {
            this._response = FindFailedResponse.ABORT;
        } else if (this.skipButton == actionEvent.getSource()) {
            this._response = FindFailedResponse.SKIP;
        }
        this.dispose();
    }

    public FindFailedResponse getResponse() {
        return this._response;
    }

    <PSC> Component createTargetComponent(PSC PSC) {
        if (PSC instanceof Pattern) {
            Pattern pattern = (Pattern)PSC;
            JLabel jLabel = new JLabel("Sikuli can not find pattern :" + pattern);
            return jLabel;
        }
        if (PSC instanceof String) {
            String string = (String)PSC;
            try {
                String string2 = new ImageLocator().locate((String)PSC);
                BufferedImage bufferedImage = null;
                try {
                    bufferedImage = ImageIO.read(new File(string2));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                JPanel jPanel = new JPanel();
                jPanel.setLayout(new BorderLayout());
                JLabel jLabel = new JLabel();
                jLabel.setIcon(new ImageIcon(bufferedImage));
                JLabel jLabel2 = new JLabel("Sikuli is unable to find the target image.");
                jPanel.add((Component)jLabel2, "First");
                jPanel.add(new JLabel((String)PSC));
                jPanel.add((Component)jLabel, "Last");
                return jPanel;
            }
            catch (IOException iOException) {
                JLabel jLabel = new JLabel("Sikuli can not find text :" + string);
                return jLabel;
            }
        }
        return null;
    }

    @Override
    public void setVisible(boolean bl) {
        if (bl) {
            this.toFront();
            this.setAlwaysOnTop(true);
            this.pack();
            this.setResizable(false);
            this.setLocationRelativeTo(this);
        }
        super.setVisible(bl);
    }

    public static void main(String[] stringArray) {
        FindFailedDialog findFailedDialog = new FindFailedDialog("Test");
        findFailedDialog.setVisible(true);
        Debug.log("" + (Object)((Object)findFailedDialog.getResponse()), new Object[0]);
    }
}

