/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.script;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.sikuli.script.Debug;
import org.sikuli.script.Env;
import org.sikuli.script.Settings;
import org.sikuli.script.Util;

public class ImageLocator {
    Map<URI, String> _cache = new HashMap<URI, String>();
    String _cache_dir;
    String _bundle_path;

    public ImageLocator(String string) {
        File file;
        this._bundle_path = string;
        String string2 = "";
        if (string != null) {
            file = new File(string);
            string2 = file.getName() + "/";
        }
        this._cache_dir = System.getProperty("java.io.tmpdir") + "/sikuli_cache/" + string2;
        file = new File(this._cache_dir);
        if (!file.exists()) {
            file.mkdir();
        }
    }

    public ImageLocator() {
        this(Settings.BundlePath);
    }

    protected URL getURL(String string) {
        try {
            URL uRL = new URL(string);
            return uRL;
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public String locateURL(URL uRL) throws IOException {
        Debug.log(3, "locateURL " + uRL, new Object[0]);
        try {
            URI uRI = uRL.toURI();
            if (this._cache.containsKey(uRI)) {
                return this._cache.get(uRI);
            }
            String string = Util.downloadURL(uRL, this._cache_dir);
            Debug.log(3, "download " + uRI + " to local: " + string, new Object[0]);
            this._cache.put(uRI, string);
            return string;
        }
        catch (URISyntaxException uRISyntaxException) {
            Debug.error("URI syntax error: " + uRL + ", " + uRISyntaxException.getMessage(), new Object[0]);
            return null;
        }
        catch (IOException iOException) {
            throw iOException;
        }
    }

    public static void addImagePath(String string) {
        String string2 = System.getProperty("SIKULI_IMAGE_PATH");
        string2 = string2 != null ? string2 + Env.getSeparator() + string : string;
        System.setProperty("SIKULI_IMAGE_PATH", string2);
    }

    protected static String[] splitImagePath(String string) {
        string = string.replaceAll("[Hh][Tt][Tt][Pp]://", "__http__//");
        string = string.replaceAll("[Hh][Tt][Tt][Pp][Ss]://", "__https__//");
        String[] stringArray = string.split(Env.getSeparator());
        for (int i = 0; i < stringArray.length; ++i) {
            boolean bl = false;
            if (stringArray[i].indexOf("__http__") >= 0) {
                stringArray[i] = stringArray[i].replaceAll("__http__//", "http://");
                bl = true;
            } else if (stringArray[i].indexOf("__https__") >= 0) {
                stringArray[i] = stringArray[i].replaceAll("__https__//", "https://");
                bl = true;
            }
            if (bl) {
                if (stringArray[i].endsWith("/")) continue;
                int n = i;
                stringArray[n] = stringArray[n] + "/";
                continue;
            }
            if (stringArray[i].endsWith(File.separator)) continue;
            int n = i;
            stringArray[n] = stringArray[n] + File.separator;
        }
        return stringArray;
    }

    public static void removeImagePath(String string) {
        String string2 = System.getProperty("SIKULI_IMAGE_PATH");
        if (string2 != null) {
            String[] stringArray = ImageLocator.splitImagePath(string2);
            StringBuilder stringBuilder = new StringBuilder();
            boolean bl = true;
            for (String string3 : stringArray) {
                if (string3.equals(string) || string3.equals(string + File.separator)) continue;
                if (bl) {
                    bl = false;
                } else {
                    stringBuilder.append(Env.getSeparator());
                }
                stringBuilder.append(string3);
            }
            System.setProperty("SIKULI_IMAGE_PATH", stringBuilder.toString());
        }
    }

    public static String[] getImagePath() {
        String string = "";
        if (System.getenv("SIKULI_IMAGE_PATH") != null) {
            string = string + System.getenv("SIKULI_IMAGE_PATH");
        }
        if (System.getProperty("SIKULI_IMAGE_PATH") != null) {
            if (string.length() > 0 && !string.endsWith(Env.getSeparator())) {
                string = string + Env.getSeparator();
            }
            string = string + System.getProperty("SIKULI_IMAGE_PATH");
        }
        if (string.length() > 0) {
            return ImageLocator.splitImagePath(string);
        }
        return new String[0];
    }

    protected String searchFile(String string) throws IOException {
        String[] stringArray;
        Debug.log(4, "ImageLocator.searchFile: " + string + " bundle path: " + this._bundle_path, new Object[0]);
        File file = new File(this._bundle_path, string);
        if (file.exists()) {
            return file.getAbsolutePath();
        }
        for (String string2 : stringArray = ImageLocator.getImagePath()) {
            Debug.log(4, "ImageLocator: env+sys path: " + string2, new Object[0]);
            file = new File(string2, string);
            if (file.exists()) {
                Debug.log(4, "ImageLocator found " + string + " in " + string2, new Object[0]);
                return file.getAbsolutePath();
            }
            URL uRL = this.getURL(string2);
            if (uRL == null) continue;
            try {
                String string3 = this.locateURL(new URL(uRL, string));
                Debug.log(4, "ImageLocator found " + string + " in " + string2, new Object[0]);
                return string3;
            }
            catch (IOException iOException) {
                Debug.log(3, "can't find " + string + " in " + uRL, new Object[0]);
            }
        }
        return null;
    }

    public String locate(String string) throws IOException {
        String string2 = string;
        URL uRL = this.getURL(string);
        if (uRL != null) {
            return this.locateURL(uRL);
        }
        File file = new File(string);
        if (file.isAbsolute()) {
            if (file.exists()) {
                return string;
            }
        } else {
            string2 = this.searchFile(string);
            if (string2 != null) {
                return string2;
            }
        }
        throw new FileNotFoundException("File " + string + " not exists");
    }
}

