/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.script;

import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.io.IOException;
import java.util.Date;
import java.util.Iterator;
import org.python.core.Py;
import org.python.core.PyObject;
import org.python.util.PythonInterpreter;
import org.sikuli.script.Clipboard;
import org.sikuli.script.Debug;
import org.sikuli.script.Env;
import org.sikuli.script.EventManager;
import org.sikuli.script.FindFailed;
import org.sikuli.script.FindFailedDialog;
import org.sikuli.script.FindFailedResponse;
import org.sikuli.script.Finder;
import org.sikuli.script.IRobot;
import org.sikuli.script.IScreen;
import org.sikuli.script.Location;
import org.sikuli.script.Match;
import org.sikuli.script.Pattern;
import org.sikuli.script.Screen;
import org.sikuli.script.ScreenHighlighter;
import org.sikuli.script.ScreenImage;
import org.sikuli.script.Settings;
import org.sikuli.script.SikuliActionManager;
import org.sikuli.script.SikuliEventObserver;
import org.sikuli.script.TextRecognizer;

public class Region {
    static final float DEFAULT_HIGHLIGHT_TIME = 2.0f;
    private IRobot _robot;
    private IScreen _scr;
    private ScreenHighlighter _overlay = null;
    public int x;
    public int y;
    public int w;
    public int h;
    protected FindFailedResponse _defaultFindFailedResponse = FindFailedResponse.ABORT;
    protected boolean _throwException = true;
    protected double _autoWaitTimeout = 3.0;
    protected boolean _observing = false;
    protected EventManager _evtMgr = null;
    protected ScreenImage _lastScreenImage;
    protected Match _lastMatch;
    protected Iterator<Match> _lastMatches;
    private int _hold_buttons = 0;
    private String _hold_keys = "";

    public void setFindFailedResponse(FindFailedResponse findFailedResponse) {
        this._defaultFindFailedResponse = findFailedResponse;
    }

    public FindFailedResponse getFindFailedResponse() {
        return this._defaultFindFailedResponse;
    }

    @Deprecated
    public Region(int n, int n2, int n3, int n4) {
        this.init(n, n2, n3, n4, null);
    }

    @Deprecated
    public Region(Rectangle rectangle) {
        this.init(rectangle.x, rectangle.y, rectangle.width, rectangle.height, null);
    }

    @Deprecated
    public Region(Region region) {
        this.init(region.x, region.y, region.w, region.h, region.getScreen());
    }

    Region(Rectangle rectangle, IScreen iScreen) {
        this.init(rectangle.x, rectangle.y, rectangle.width, rectangle.height, iScreen);
    }

    public static Region create(Rectangle rectangle) {
        return Region.create(new Region(rectangle));
    }

    public static Region create(int n, int n2, int n3, int n4) {
        return Region.create(new Region(n, n2, n3, n4));
    }

    public static Region create(Rectangle rectangle, IScreen iScreen) {
        return Region.create(new Region(rectangle, iScreen));
    }

    public static Region create(Region region) {
        return Region.toJythonRegion(region);
    }

    protected Region() {
    }

    public String toString() {
        return String.format("Region[%d,%d %dx%d]@%s E:%s, T:%.1f", this.x, this.y, this.w, this.h, this._scr.toString(), this._throwException ? "Y" : "N", this._autoWaitTimeout);
    }

    protected void init(int n, int n2, int n3, int n4, IScreen iScreen) {
        this.x = n;
        this.y = n2;
        this.w = n3;
        this.h = n4;
        this._scr = iScreen != null ? iScreen : this.initScreen();
        this._robot = this._scr.getRobot();
    }

    protected EventManager getEventManager() {
        if (this._evtMgr == null) {
            this._evtMgr = new EventManager(this);
        }
        return this._evtMgr;
    }

    private Screen initScreen() {
        if (this instanceof Screen) {
            return (Screen)this;
        }
        Rectangle rectangle = new Rectangle(this.x, this.y, this.w, this.h);
        for (int i = 0; i < Screen.getNumberScreens(); ++i) {
            Rectangle rectangle2 = Screen.getBounds(i);
            if (!rectangle2.contains(rectangle)) continue;
            return new Screen(i);
        }
        return new Screen();
    }

    protected void updateSelf() {
        if (this._overlay != null) {
            this._overlay.highlight(this);
        }
    }

    public IScreen getScreen() {
        return this._scr;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getW() {
        return this.w;
    }

    public int getH() {
        return this.h;
    }

    public void setX(int n) {
        this.x = n;
    }

    public void setY(int n) {
        this.y = n;
    }

    public void setW(int n) {
        this.w = n;
    }

    public void setH(int n) {
        this.h = n;
    }

    public Rectangle getROI() {
        return new Rectangle(this.x, this.y, this.w, this.h);
    }

    public void setROI(int n, int n2, int n3, int n4) {
        this.x = n;
        this.y = n2;
        this.w = n3;
        this.h = n4;
    }

    public void setROI(Region region) {
        this.x = region.x;
        this.y = region.y;
        this.w = region.w;
        this.h = region.h;
    }

    public void setROI(Rectangle rectangle) {
        this.x = (int)rectangle.getX();
        this.y = (int)rectangle.getY();
        this.w = (int)rectangle.getWidth();
        this.h = (int)rectangle.getHeight();
    }

    public void highlight() {
        if (this._overlay == null) {
            this.highlight(true);
        } else {
            this.highlight(false);
        }
    }

    protected void highlight(boolean bl) {
        Debug.history("toggle highlight " + this.toString() + ": " + bl, new Object[0]);
        if (!(this._scr instanceof Screen)) {
            Debug.error("highlight only work on the physical desktop screens.", new Object[0]);
            return;
        }
        Screen screen = (Screen)this.getScreen();
        if (bl) {
            this._overlay = new ScreenHighlighter(screen);
            this._overlay.highlight(this);
        } else if (this._overlay != null) {
            this._overlay.close();
            this._overlay = null;
        }
    }

    public void highlight(float f) {
        Debug.history("highlight " + this.toString() + " for " + f + " secs", new Object[0]);
        if (!(this._scr instanceof Screen)) {
            Debug.error("highlight only work on the physical desktop screens.", new Object[0]);
            return;
        }
        Screen screen = (Screen)this.getScreen();
        ScreenHighlighter screenHighlighter = new ScreenHighlighter(screen);
        screenHighlighter.highlight(this, f);
    }

    public Rectangle getRect() {
        return this.getROI();
    }

    public void setRect(Rectangle rectangle) {
        this.setROI(rectangle);
    }

    public void setRect(int n, int n2, int n3, int n4) {
        this.setROI(n, n2, n3, n4);
    }

    public void setRect(Region region) {
        this.setROI(region);
    }

    public Location getCenter() {
        return new Location(this.x + this.w / 2, this.y + this.h / 2);
    }

    public Location getTopLeft() {
        return new Location(this.x, this.y);
    }

    public Location getTopRight() {
        return new Location(this.x + this.w, this.y);
    }

    public Location getBottomLeft() {
        return new Location(this.x, this.y + this.h);
    }

    public Location getBottomRight() {
        return new Location(this.x + this.w, this.y + this.h);
    }

    public Region offset(Location location) {
        return Region.create(this.x + location.x, this.y + location.y, this.w, this.h);
    }

    public Region moveTo(Location location) {
        this.x = location.x;
        this.y = location.y;
        this.updateSelf();
        return this;
    }

    public Region morphTo(Region region) {
        this.x = region.x;
        this.y = region.y;
        this.w = region.w;
        this.h = region.h;
        this.updateSelf();
        return this;
    }

    public Region nearby() {
        return this.nearby(50);
    }

    public Region nearby(int n) {
        Rectangle rectangle = this.getScreen().getBounds();
        Rectangle rectangle2 = new Rectangle(this.x - n, this.y - n, this.w + n * 2, this.h + n * 2);
        rectangle2 = rectangle2.intersection(rectangle);
        return Region.create(rectangle2);
    }

    public Region right() {
        return this.right(9999999);
    }

    public Region right(int n) {
        Rectangle rectangle = this.getScreen().getBounds();
        Rectangle rectangle2 = new Rectangle(this.x + this.w, this.y, n, this.h);
        rectangle2 = rectangle2.intersection(rectangle);
        return Region.create(rectangle2);
    }

    public Region left() {
        return this.left(9999999);
    }

    public Region left(int n) {
        Rectangle rectangle = this.getScreen().getBounds();
        Region region = Region.create(this);
        region.x = this.x - n < rectangle.x ? rectangle.x : this.x - n;
        region.y = this.y;
        region.w = this.x - region.x;
        region.h = this.h;
        return region;
    }

    public Region above() {
        return this.above(9999999);
    }

    public Region above(int n) {
        Rectangle rectangle = this.getScreen().getBounds();
        Region region = Region.create(this);
        region.x = this.x;
        region.y = this.y - n < rectangle.y ? rectangle.y : this.y - n;
        region.w = this.w;
        region.h = this.y - region.y;
        return region;
    }

    public Region below() {
        return this.below(999999);
    }

    public Region below(int n) {
        Rectangle rectangle = this.getScreen().getBounds();
        Rectangle rectangle2 = new Rectangle(this.x, this.y + this.h, this.w, n);
        rectangle2 = rectangle2.intersection(rectangle);
        return Region.create(rectangle2);
    }

    public Region inside() {
        return this;
    }

    public void setThrowException(boolean bl) {
        this._throwException = bl;
        this._defaultFindFailedResponse = this._throwException ? FindFailedResponse.ABORT : FindFailedResponse.SKIP;
    }

    public void setAutoWaitTimeout(double d) {
        this._autoWaitTimeout = d;
    }

    public boolean getThrowException() {
        return this._throwException;
    }

    public double getAutoWaitTimeout() {
        return this._autoWaitTimeout;
    }

    public <PSC> Match find(PSC PSC) throws FindFailed {
        if (this._autoWaitTimeout > 0.0) {
            return this.wait(PSC, this._autoWaitTimeout);
        }
        do {
            try {
                this._lastMatch = this.doFind(PSC);
            }
            catch (Exception exception) {
                throw new FindFailed(exception.getMessage());
            }
            if (this._lastMatch == null) continue;
            return this._lastMatch;
        } while (this.handleFindFailed(PSC));
        return null;
    }

    <PSC> boolean handleFindFailed(PSC PSC) throws FindFailed {
        FindFailedResponse findFailedResponse;
        if (this._defaultFindFailedResponse == FindFailedResponse.PROMPT) {
            FindFailedDialog findFailedDialog = new FindFailedDialog(PSC);
            findFailedDialog.setVisible(true);
            findFailedResponse = findFailedDialog.getResponse();
        } else {
            findFailedResponse = this._defaultFindFailedResponse;
        }
        if (findFailedResponse == FindFailedResponse.SKIP) {
            return false;
        }
        if (findFailedResponse == FindFailedResponse.RETRY) {
            return true;
        }
        if (findFailedResponse == FindFailedResponse.ABORT) {
            throw new FindFailed("can not find " + PSC + " on the screen.");
        }
        return false;
    }

    public <PSC> Iterator<Match> findAll(PSC PSC) throws FindFailed {
        do {
            try {
                if (this._autoWaitTimeout > 0.0) {
                    RepeatableFindAll repeatableFindAll = new RepeatableFindAll(PSC);
                    repeatableFindAll.repeat(this._autoWaitTimeout);
                    this._lastMatches = repeatableFindAll.getMatches();
                } else {
                    this._lastMatches = this.doFindAll(PSC);
                }
            }
            catch (Exception exception) {
                throw new FindFailed(exception.getMessage());
            }
            if (this._lastMatches == null) continue;
            return this._lastMatches;
        } while (this.handleFindFailed(PSC));
        return null;
    }

    public void wait(double d) {
        try {
            Thread.sleep((long)(d * 1000.0));
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    public <PSC> Match wait(PSC PSC) throws FindFailed {
        return this.wait(PSC, this._autoWaitTimeout);
    }

    public <PSC> Match wait(PSC PSC, double d) throws FindFailed {
        block3: {
            do {
                try {
                    Debug.log(2, "waiting for " + PSC + " to appear", new Object[0]);
                    RepeatableFind repeatableFind = new RepeatableFind(PSC);
                    repeatableFind.repeat(d);
                    this._lastMatch = repeatableFind.getMatch();
                }
                catch (Exception exception) {
                    throw new FindFailed(exception.getMessage());
                }
                if (this._lastMatch != null) break block3;
                Debug.log(2, "" + PSC + " has not appeared.", new Object[0]);
            } while (this.handleFindFailed(PSC));
            return null;
        }
        Debug.log(2, "" + PSC + " has appeared.", new Object[0]);
        return this._lastMatch;
    }

    public <PSC> Match exists(PSC PSC) {
        return this.exists(PSC, this._autoWaitTimeout);
    }

    public <PSC> Match exists(PSC PSC, double d) {
        try {
            RepeatableFind repeatableFind = new RepeatableFind(PSC);
            if (repeatableFind.repeat(d)) {
                this._lastMatch = repeatableFind.getMatch();
                return this._lastMatch;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public <PSC> boolean waitVanish(PSC PSC) {
        return this.waitVanish(PSC, this._autoWaitTimeout);
    }

    public <PSC> boolean waitVanish(PSC PSC, double d) {
        try {
            Debug.log(2, "waiting for " + PSC + " to vanish", new Object[0]);
            RepeatableVanish repeatableVanish = new RepeatableVanish(PSC);
            if (repeatableVanish.repeat(d)) {
                Debug.log(2, "" + PSC + " has vanished", new Object[0]);
                return true;
            }
            Debug.log(2, "" + PSC + " has not vanished before timeout", new Object[0]);
            return false;
        }
        catch (Exception exception) {
            Debug.error(exception.getMessage(), new Object[0]);
            return false;
        }
    }

    public <PSRML> int click(PSRML PSRML) throws FindFailed {
        return this.click(PSRML, 0);
    }

    public <PSRML> int click(PSRML PSRML, int n) throws FindFailed {
        Location location = this.getLocationFromPSRML(PSRML);
        int n2 = this._click(location, 16, n, false);
        SikuliActionManager.getInstance().clickTarget(this, PSRML, this._lastScreenImage, this._lastMatch);
        return n2;
    }

    public <PSRML> int doubleClick(PSRML PSRML) throws FindFailed {
        return this.doubleClick(PSRML, 0);
    }

    public <PSRML> int doubleClick(PSRML PSRML, int n) throws FindFailed {
        Location location = this.getLocationFromPSRML(PSRML);
        int n2 = this._click(location, 16, n, true);
        SikuliActionManager.getInstance().doubleClickTarget(this, PSRML, this._lastScreenImage, this._lastMatch);
        return n2;
    }

    public <PSRML> int rightClick(PSRML PSRML) throws FindFailed {
        return this.rightClick(PSRML, 0);
    }

    public <PSRML> int rightClick(PSRML PSRML, int n) throws FindFailed {
        Location location = this.getLocationFromPSRML(PSRML);
        int n2 = this._click(location, 4, n, false);
        SikuliActionManager.getInstance().rightClickTarget(this, PSRML, this._lastScreenImage, this._lastMatch);
        return n2;
    }

    public int wheel(int n, int n2) throws FindFailed {
        for (int i = 0; i < n2; ++i) {
            this._robot.mouseWheel(n);
            this._robot.delay(50);
        }
        return 1;
    }

    public <PSRML> int wheel(PSRML PSRML, int n, int n2) throws FindFailed {
        if (PSRML == null || this.hover(PSRML) != 0) {
            return this.wheel(n, n2);
        }
        return 0;
    }

    public <PSRML> int mouseMove(PSRML PSRML) throws FindFailed {
        return this.hover(PSRML);
    }

    public <PSRML> int hover(PSRML PSRML) throws FindFailed {
        Location location = this.getLocationFromPSRML(PSRML);
        if (location != null) {
            this._scr.showMove(location);
            this._robot.smoothMove(location);
            this._robot.waitForIdle();
            return 1;
        }
        return 0;
    }

    public <PSRML> int dragDrop(PSRML PSRML, PSRML PSRML2) throws FindFailed {
        return this.dragDrop(PSRML, PSRML2, 0);
    }

    public <PSRML> int dragDrop(PSRML PSRML, PSRML PSRML2, int n) throws FindFailed {
        boolean bl = false;
        Location location = this.getLocationFromPSRML(PSRML);
        Location location2 = this.getLocationFromPSRML(PSRML2);
        Debug.history((n != 0 ? KeyEvent.getKeyModifiersText(n) + "+" : "") + "DRAG " + location + " to " + location2, new Object[0]);
        if (location != null && location2 != null) {
            this._robot.pressModifiers(n);
            this._robot.dragDrop(location, location2, 10, (long)(Settings.MoveMouseDelay * 1000.0f), 16);
            this._robot.releaseModifiers(n);
            return 1;
        }
        return 0;
    }

    public <PSRML> int drag(PSRML PSRML) throws FindFailed {
        Location location = this.getLocationFromPSRML(PSRML);
        if (location != null) {
            this._robot.smoothMove(location);
            this._scr.showTarget(location);
            this._robot.mousePress(16);
            this._robot.waitForIdle();
            return 1;
        }
        return 0;
    }

    public <PSRML> int dropAt(PSRML PSRML) throws FindFailed {
        return this.dropAt(PSRML, Settings.DelayBeforeDrop);
    }

    public <PSRML> int dropAt(PSRML PSRML, double d) throws FindFailed {
        Location location = this.getLocationFromPSRML(PSRML);
        if (location != null) {
            this._scr.showDropTarget(location);
            this._robot.smoothMove(location);
            this._robot.delay((int)(d * 1000.0));
            this._robot.mouseRelease(16);
            this._robot.waitForIdle();
            return 1;
        }
        return 0;
    }

    public <PSRML> int type(String string) throws FindFailed {
        return this.type(null, string, 0);
    }

    public <PSRML> int type(String string, int n) throws FindFailed {
        return this.type(null, string, n);
    }

    public <PSRML> int type(PSRML PSRML, String string) throws FindFailed {
        return this.type(PSRML, string, 0);
    }

    public <PSRML> int type(PSRML PSRML, String string, int n) throws FindFailed {
        this.click(PSRML, 0);
        if (string != null) {
            Debug.history((n != 0 ? KeyEvent.getKeyModifiersText(n) + "+" : "") + "TYPE \"" + string + "\"", new Object[0]);
            for (int i = 0; i < string.length(); ++i) {
                this._robot.pressModifiers(n);
                this._robot.typeChar(string.charAt(i), IRobot.KeyMode.PRESS_RELEASE);
                this._robot.releaseModifiers(n);
                this._robot.delay(20);
            }
            this._robot.waitForIdle();
            return 1;
        }
        return 0;
    }

    public int paste(String string) throws FindFailed {
        return this.paste(null, string);
    }

    public <PSRML> int paste(PSRML PSRML, String string) throws FindFailed {
        this.click(PSRML, 0);
        if (string != null) {
            Clipboard.putText(Clipboard.PLAIN, Clipboard.UTF8, Clipboard.BYTE_BUFFER, string);
            int n = Env.getHotkeyModifier();
            this._robot.keyPress(n);
            this._robot.keyPress(86);
            this._robot.keyRelease(86);
            this._robot.keyRelease(n);
            return 1;
        }
        return 0;
    }

    public void mouseDown(int n) {
        this._hold_buttons = n;
        this._robot.mousePress(n);
        this._robot.waitForIdle();
    }

    public void mouseUp() {
        this.mouseUp(0);
    }

    public void mouseUp(int n) {
        if (n == 0) {
            this._robot.mouseRelease(this._hold_buttons);
        } else {
            this._robot.mouseRelease(n);
        }
        this._robot.waitForIdle();
    }

    public void keyDown(int n) {
        this._robot.keyPress(n);
    }

    public void keyUp(int n) {
        this._robot.keyRelease(n);
    }

    public void keyDown(String string) {
        if (string != null) {
            for (int i = 0; i < string.length(); ++i) {
                if (this._hold_keys.indexOf(string.charAt(i)) != -1) continue;
                Debug.log(5, "press: " + string.charAt(i), new Object[0]);
                this._robot.typeChar(string.charAt(i), IRobot.KeyMode.PRESS_ONLY);
                this._hold_keys = this._hold_keys + string.charAt(i);
            }
            this._robot.waitForIdle();
            return;
        }
    }

    public void keyUp() {
        this.keyUp(null);
    }

    public void keyUp(String string) {
        if (string == null) {
            string = this._hold_keys;
        }
        for (int i = 0; i < string.length(); ++i) {
            int n = this._hold_keys.indexOf(string.charAt(i));
            if (n == -1) continue;
            Debug.log(5, "release: " + string.charAt(i), new Object[0]);
            this._robot.typeChar(string.charAt(i), IRobot.KeyMode.RELEASE_ONLY);
            this._hold_keys = this._hold_keys.substring(0, n) + this._hold_keys.substring(n + 1);
        }
        this._robot.waitForIdle();
    }

    public <PSC> void onAppear(PSC PSC, SikuliEventObserver sikuliEventObserver) {
        this.getEventManager().addAppearObserver(PSC, sikuliEventObserver);
    }

    public <PSC> void onVanish(PSC PSC, SikuliEventObserver sikuliEventObserver) {
        this.getEventManager().addVanishObserver(PSC, sikuliEventObserver);
    }

    public void onChange(int n, SikuliEventObserver sikuliEventObserver) {
        this.getEventManager().addChangeObserver(n, sikuliEventObserver);
    }

    public void onChange(SikuliEventObserver sikuliEventObserver) {
        this.getEventManager().addChangeObserver(Settings.ObserveMinChangedPixels, sikuliEventObserver);
    }

    public void observe() {
        this.observe(Double.POSITIVE_INFINITY);
    }

    public void observeInBackground(final double d) {
        Thread thread2 = new Thread(){

            @Override
            public void run() {
                Region.this.observe(d);
            }
        };
        thread2.start();
    }

    public void stopObserver() {
        this._observing = false;
    }

    public void observe(double d) {
        if (this._evtMgr == null) {
            return;
        }
        int n = (int)(1000.0 / (double)Settings.ObserveScanRate);
        long l = new Date().getTime();
        this._observing = true;
        while (this._observing) {
            ScreenImage screenImage;
            Date date = new Date();
            if (!((double)l + d * 1000.0 > (double)date.getTime())) break;
            long l2 = new Date().getTime();
            this._lastScreenImage = screenImage = this._scr.capture(this.x, this.y, this.w, this.h);
            this._evtMgr.update(screenImage);
            long l3 = new Date().getTime();
            try {
                if (l3 - l2 >= (long)n) continue;
                Thread.sleep((int)((long)n - (l3 - l2)));
            }
            catch (Exception exception) {}
        }
    }

    public Match getLastMatch() {
        return this._lastMatch;
    }

    public Iterator<Match> getLastMatches() {
        return this._lastMatches;
    }

    public String text() {
        ScreenImage screenImage;
        this._lastScreenImage = screenImage = this._scr.capture(this.x, this.y, this.w, this.h);
        return TextRecognizer.getInstance().recognize(screenImage);
    }

    public static Region toJythonRegion(Region region) {
        if (region == null) {
            return null;
        }
        PythonInterpreter pythonInterpreter = new PythonInterpreter();
        pythonInterpreter.exec("from sikuli import Region");
        PyObject pyObject = pythonInterpreter.get("Region");
        PyObject pyObject2 = pyObject.__call__(Py.java2py(region));
        return (Region)pyObject2.__tojava__(Region.class);
    }

    public <PSC> Match findNow(PSC PSC) throws FindFailed {
        Debug.log("capture: " + this.x + "," + this.y, new Object[0]);
        ScreenImage screenImage = this._scr.capture(this.x, this.y, this.w, this.h);
        Debug.log("ScreenImage: " + screenImage.getROI(), new Object[0]);
        this._lastScreenImage = screenImage;
        Finder finder = new Finder(screenImage, this);
        Match match = null;
        try {
            finder.find(PSC);
            if (finder.hasNext()) {
                match = finder.next();
            }
            finder.destroy();
        }
        catch (IOException iOException) {
            throw new FindFailed(iOException.getMessage());
        }
        return match;
    }

    <PSC> Match doFind(PSC PSC) throws IOException {
        ScreenImage screenImage;
        this._lastScreenImage = screenImage = this.getScreen().capture(this.x, this.y, this.w, this.h);
        Finder finder = new Finder(screenImage, this);
        finder.find(PSC);
        if (finder.hasNext()) {
            return finder.next();
        }
        return null;
    }

    <PSC> Iterator<Match> doFindAll(PSC PSC) throws IOException {
        ScreenImage screenImage;
        this._lastScreenImage = screenImage = this.getScreen().capture(this.x, this.y, this.w, this.h);
        Finder finder = new Finder(screenImage, this);
        finder.findAll(PSC);
        if (finder.hasNext()) {
            return finder;
        }
        return null;
    }

    public <PSC> Iterator<Match> findAllNow(PSC PSC) throws FindFailed {
        ScreenImage screenImage;
        this._lastScreenImage = screenImage = this._scr.capture(this.x, this.y, this.w, this.h);
        Finder finder = new Finder(screenImage, this);
        try {
            finder.findAll(PSC);
            if (finder.hasNext()) {
                return finder;
            }
            finder.destroy();
        }
        catch (IOException iOException) {
            throw new FindFailed(iOException.getMessage());
        }
        return null;
    }

    @Deprecated
    public <PSC> Iterator<Match> waitAll(PSC PSC, double d) throws FindFailed {
        block3: {
            do {
                try {
                    RepeatableFindAll repeatableFindAll = new RepeatableFindAll(PSC);
                    repeatableFindAll.repeat(d);
                    this._lastMatches = repeatableFindAll.getMatches();
                }
                catch (Exception exception) {
                    throw new FindFailed(exception.getMessage());
                }
                if (this._lastMatches != null) break block3;
            } while (this.handleFindFailed(PSC));
            return null;
        }
        return this._lastMatches;
    }

    public <PSRM> Region getRegionFromPSRM(PSRM PSRM) throws FindFailed {
        if (PSRM instanceof Pattern || PSRM instanceof String) {
            Match match = this.find(PSRM);
            if (match != null) {
                return match;
            }
            return null;
        }
        if (PSRM instanceof Region) {
            return (Region)PSRM;
        }
        return null;
    }

    public <PSRML> Location getLocationFromPSRML(PSRML PSRML) throws FindFailed {
        if (PSRML instanceof Pattern || PSRML instanceof String) {
            Match match = this.find(PSRML);
            if (match != null) {
                return match.getTarget();
            }
            return null;
        }
        if (PSRML instanceof Match) {
            return ((Match)PSRML).getTarget();
        }
        if (PSRML instanceof Region) {
            return ((Region)PSRML).getCenter();
        }
        if (PSRML instanceof Location) {
            return (Location)PSRML;
        }
        return null;
    }

    private String getClickMsg(Location location, int n, int n2, boolean bl) {
        String string = "";
        if (n2 != 0) {
            string = string + KeyEvent.getKeyModifiersText(n2) + "+";
        }
        if (n == 16 && !bl) {
            string = string + "CLICK";
        }
        if (n == 16 && bl) {
            string = string + "DOUBLE CLICK";
        }
        if (n == 4) {
            string = string + "RIGHT CLICK";
        } else if (n == 8) {
            string = string + "MID CLICK";
        }
        string = string + " on " + location;
        return string;
    }

    private int _click(Location location, int n, int n2, boolean bl) {
        if (location == null) {
            return 0;
        }
        Debug.history(this.getClickMsg(location, n, n2, bl), new Object[0]);
        this._robot.pressModifiers(n2);
        this._robot.smoothMove(location);
        this._scr.showClick(location);
        this._robot.mousePress(n);
        this._robot.mouseRelease(n);
        if (bl) {
            this._robot.mousePress(n);
            this._robot.mouseRelease(n);
        }
        this._robot.releaseModifiers(n2);
        this._robot.waitForIdle();
        return 1;
    }

    Location toRobotCoord(Location location) {
        return new Location(location.x - this.x, location.y - this.y);
    }

    Match toGlobalCoord(Match match) {
        match.x += this.x;
        match.y += this.y;
        return match;
    }

    class RepeatableFindAll
    extends Repeatable {
        Object _target;
        Iterator<Match> _matches;

        public <PSC> RepeatableFindAll(PSC PSC) {
            this._matches = null;
            this._target = PSC;
        }

        public Iterator<Match> getMatches() {
            return this._matches;
        }

        @Override
        public void run() throws IOException {
            this._matches = Region.this.doFindAll(this._target);
        }

        @Override
        boolean ifSuccessful() {
            return this._matches != null;
        }
    }

    class RepeatableVanish
    extends RepeatableFind {
        public <PSC> RepeatableVanish(PSC PSC) {
            super(PSC);
        }

        @Override
        boolean ifSuccessful() {
            return this._match == null;
        }
    }

    class RepeatableFind
    extends Repeatable {
        Object _target;
        Match _match;

        public <PSC> RepeatableFind(PSC PSC) {
            this._match = null;
            this._target = PSC;
        }

        public Match getMatch() {
            return this._match;
        }

        @Override
        public void run() throws IOException {
            this._match = Region.this.doFind(this._target);
        }

        @Override
        boolean ifSuccessful() {
            return this._match != null;
        }
    }

    abstract class Repeatable {
        Repeatable() {
        }

        abstract void run() throws Exception;

        abstract boolean ifSuccessful();

        boolean repeat(double d) throws Exception {
            int n = (int)(1000.0 / (double)Settings.WaitScanRate);
            long l = new Date().getTime();
            do {
                long l2 = new Date().getTime();
                this.run();
                if (this.ifSuccessful()) {
                    return true;
                }
                long l3 = new Date().getTime();
                if (l3 - l2 < (long)n) {
                    Region.this._robot.delay((int)((long)n - (l3 - l2)));
                    continue;
                }
                Region.this._robot.delay(10);
            } while ((double)l + d * 1000.0 > (double)new Date().getTime());
            return false;
        }
    }
}

