/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.script;

import com.wapmx.nativeutils.jniloader.NativeLoader;
import java.awt.image.BufferedImage;
import java.io.IOException;
import org.sikuli.script.Debug;
import org.sikuli.script.OpenCV;
import org.sikuli.script.ResourceExtractor;
import org.sikuli.script.ScreenImage;
import org.sikuli.script.Settings;
import org.sikuli.script.natives.Mat;
import org.sikuli.script.natives.Vision;

public class TextRecognizer {
    protected static TextRecognizer _instance = null;
    boolean _init_succeeded = false;

    protected TextRecognizer() {
        this.init();
    }

    public void init() {
        Debug.info("Text Recognizer inited.", new Object[0]);
        try {
            String string = ResourceExtractor.extract("tessdata");
            if (string.endsWith("tessdata/")) {
                string = string.substring(0, string.length() - 9);
            }
            Settings.OcrDataPath = string;
            Debug.log(3, "OCR data path: " + string, new Object[0]);
            Vision.initOCR(Settings.OcrDataPath);
            this._init_succeeded = true;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static TextRecognizer getInstance() {
        if (_instance == null) {
            _instance = new TextRecognizer();
        }
        return _instance;
    }

    public String recognize(ScreenImage screenImage) {
        BufferedImage bufferedImage = screenImage.getImage();
        return this.recognize(bufferedImage);
    }

    public String recognize(BufferedImage bufferedImage) {
        if (this._init_succeeded) {
            Mat mat = OpenCV.convertBufferedImageToMat(bufferedImage);
            return Vision.recognize(mat);
        }
        return "";
    }

    static {
        try {
            NativeLoader.loadLibrary("VisionProxy");
            TextRecognizer textRecognizer = TextRecognizer.getInstance();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

