/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.script.internal.hotkey;

import com.melloware.jintellitype.JIntellitype;
import java.util.HashMap;
import java.util.Map;
import org.sikuli.script.Debug;
import org.sikuli.script.HotkeyEvent;
import org.sikuli.script.HotkeyListener;
import org.sikuli.script.internal.hotkey.HotkeyManager;

public class WindowsHotkeyManager
extends HotkeyManager {
    private Map<Integer, HotkeyData> _idCallbackMap = new HashMap<Integer, HotkeyData>();
    private int _gHotkeyId = 1;

    @Override
    public boolean _addHotkey(int n, int n2, HotkeyListener hotkeyListener) {
        JIntellitype jIntellitype = JIntellitype.getInstance();
        if (this._gHotkeyId == 1) {
            jIntellitype.addHotKeyListener(new JIntellitypeHandler());
        }
        this._removeHotkey(n, n2);
        int n3 = this._gHotkeyId++;
        HotkeyData hotkeyData = new HotkeyData(n, n2, hotkeyListener);
        this._idCallbackMap.put(n3, hotkeyData);
        jIntellitype.registerSwingHotKey(n3, n2, n);
        return true;
    }

    @Override
    public boolean _removeHotkey(int n, int n2) {
        for (Map.Entry<Integer, HotkeyData> entry : this._idCallbackMap.entrySet()) {
            HotkeyData hotkeyData = entry.getValue();
            if (hotkeyData.key != n || hotkeyData.modifiers != n2) continue;
            JIntellitype jIntellitype = JIntellitype.getInstance();
            int n3 = entry.getKey();
            jIntellitype.unregisterHotKey(n3);
            this._idCallbackMap.remove(n3);
            return true;
        }
        return false;
    }

    @Override
    public void cleanUp() {
        JIntellitype jIntellitype = JIntellitype.getInstance();
        for (Map.Entry<Integer, HotkeyData> entry : this._idCallbackMap.entrySet()) {
            int n = entry.getKey();
            jIntellitype.unregisterHotKey(n);
        }
        this._gHotkeyId = 1;
        this._idCallbackMap.clear();
        jIntellitype.cleanUp();
    }

    class JIntellitypeHandler
    implements com.melloware.jintellitype.HotkeyListener {
        JIntellitypeHandler() {
        }

        @Override
        public void onHotKey(int n) {
            Debug.log(4, "Hotkey pressed", new Object[0]);
            HotkeyData hotkeyData = (HotkeyData)WindowsHotkeyManager.this._idCallbackMap.get(n);
            HotkeyEvent hotkeyEvent = new HotkeyEvent(hotkeyData.key, hotkeyData.modifiers);
            hotkeyData.listener.invokeHotkeyPressed(hotkeyEvent);
        }
    }

    class HotkeyData {
        int key;
        int modifiers;
        HotkeyListener listener;

        public HotkeyData(int n, int n2, HotkeyListener hotkeyListener) {
            this.key = n;
            this.modifiers = n2;
            this.listener = hotkeyListener;
        }
    }
}

