/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.openbus.interceptors;

import openbusidl.acs.Credential;
import openbusidl.acs.CredentialHelper;
import openbusidl.acs.IAccessControlService;
import org.omg.CORBA.Any;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.NO_PERMISSION;
import org.omg.CORBA.ORB;
import org.omg.IOP.Codec;
import org.omg.IOP.ServiceContext;
import org.omg.PortableInterceptor.ServerRequestInfo;
import org.omg.PortableInterceptor.ServerRequestInterceptor;
import tecgraf.openbus.Openbus;
import tecgraf.openbus.interceptors.InterceptorImpl;
import tecgraf.openbus.util.Log;

class ServerInterceptor
extends InterceptorImpl
implements ServerRequestInterceptor {
    private ORB orb;
    private Openbus bus;
    private IAccessControlService acs;
    private int credentialSlot;

    ServerInterceptor(Codec codec, int credentialSlot) {
        super("ServerInterceptor", codec);
        this.credentialSlot = credentialSlot;
    }

    public void receive_request_service_contexts(ServerRequestInfo ri) {
        Log.INTERCEPTORS.fine("ATINGI PONTO DE INTERCEPTA\u00c7\u00c2O SERVIDOR!");
        if (ri.operation().equals("_non_existent")) {
            return;
        }
        if (this.bus == null) {
            this.bus = Openbus.getInstance();
            this.orb = this.bus.getORB();
            this.acs = this.bus.getAccessControlService();
            this.bus.setInterceptedCredentialSlot(this.credentialSlot);
        }
        try {
            ServiceContext serviceContext = ri.get_request_service_context(1234);
            Log.INTERCEPTORS.fine("TEM CREDENCIAL!");
            byte[] value = serviceContext.context_data;
            Credential credential = CredentialHelper.extract((Any)this.getCodec().decode_value(value, CredentialHelper.type()));
            Log.INTERCEPTORS.fine("CREDENCIAL: " + credential.identifier + "," + credential.owner);
            if (!this.acs.isValid(credential)) {
                Log.INTERCEPTORS.info("CREDENCIAL INVALIDA!");
                throw new NO_PERMISSION(0, CompletionStatus.COMPLETED_NO);
            }
            Log.INTERCEPTORS.fine("CREDENCIAL VALIDADA!");
            Any credentialValue = this.orb.create_any();
            CredentialHelper.insert((Any)credentialValue, (Credential)credential);
            ri.set_slot(this.credentialSlot, credentialValue);
        }
        catch (Exception e) {
            Log.INTERCEPTORS.severe("Falha na valida\u00e7\u00e3o da credencial", e);
            throw new NO_PERMISSION(0, CompletionStatus.COMPLETED_NO);
        }
    }

    public void receive_request(ServerRequestInfo ri) {
    }

    public void send_reply(ServerRequestInfo ri) {
    }

    public void send_exception(ServerRequestInfo ri) {
    }

    public void send_other(ServerRequestInfo ri) {
    }
}

