/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.openbus.util;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import javax.crypto.Cipher;
import org.apache.commons.codec.binary.Base64;
import tecgraf.openbus.util.Log;

public final class CryptoUtils {
    private static final String KEY_FACTORY_TYPE = "RSA";
    private static final String CERTIFICATE_TYPE = "X.509";
    private static final String CIPHER_ALGORITHM = "RSA";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static X509Certificate readCertificate(String certificateFile) throws CertificateException, FileNotFoundException {
        FileInputStream inputStream = new FileInputStream(certificateFile);
        try {
            CertificateFactory cf = CertificateFactory.getInstance(CERTIFICATE_TYPE);
            X509Certificate x509Certificate = (X509Certificate)cf.generateCertificate(inputStream);
            return x509Certificate;
        }
        finally {
            try {
                ((InputStream)inputStream).close();
            }
            catch (IOException e) {
                Log.COMMON.warning(e.getLocalizedMessage());
            }
        }
    }

    public static RSAPrivateKey readPrivateKey(String privateKeyFileName) throws NoSuchAlgorithmException, InvalidKeySpecException, InvalidKeyException, IOException, FileNotFoundException {
        byte[] encodedBuffer = CryptoUtils.readBytes(privateKeyFileName);
        Base64 base64 = new Base64();
        byte[] bytes = base64.decode(encodedBuffer);
        PKCS8EncodedKeySpec encodedKey = new PKCS8EncodedKeySpec(bytes);
        KeyFactory kf = KeyFactory.getInstance("RSA");
        return (RSAPrivateKey)kf.generatePrivate(encodedKey);
    }

    private static byte[] readBytes(String privateKeyFileName) throws InvalidKeyException, IOException, FileNotFoundException {
        BufferedReader reader = new BufferedReader(new FileReader(privateKeyFileName));
        StringBuilder data = new StringBuilder();
        try {
            String line = reader.readLine();
            if (line == null || !line.equals("-----BEGIN PRIVATE KEY-----")) {
                throw new InvalidKeyException("Formato do arquivo inv\u00e1lido: cabe\u00e7alho n\u00e3o encontrado.");
            }
            line = reader.readLine();
            while (line != null) {
                if (line.equals("-----END PRIVATE KEY-----")) {
                    byte[] byArray = data.toString().getBytes();
                    return byArray;
                }
                data.append(line);
                line = reader.readLine();
            }
            throw new InvalidKeyException("Formato do arquivo inv\u00e1lido: rodap\u00e9 n\u00e3o encontrado.");
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException e) {}
        }
    }

    public static byte[] encrypt(Certificate certificate, byte[] data) throws GeneralSecurityException {
        if (certificate == null) {
            throw new IllegalArgumentException("certificate == null");
        }
        if (data == null) {
            throw new IllegalArgumentException("data == null");
        }
        Cipher cipher = Cipher.getInstance("RSA");
        cipher.init(1, certificate);
        return cipher.doFinal(data);
    }

    public static byte[] decrypt(PrivateKey privateKey, byte[] encryptedData) throws GeneralSecurityException {
        Cipher cipher = Cipher.getInstance("RSA");
        cipher.init(2, privateKey);
        return cipher.doFinal(encryptedData);
    }
}

