/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.openbus.util;

import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import openbusidl.acs.IAccessControlService;
import openbusidl.acs.IAccessControlServiceHelper;
import openbusidl.acs.ILeaseProvider;
import openbusidl.acs.ILeaseProviderHelper;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import scs.core.IComponent;
import scs.core.IComponentHelper;
import tecgraf.openbus.exception.ACSUnavailableException;
import tecgraf.openbus.util.CryptoUtils;

public final class Utils {
    public static final String ICOMPONENT_KEY = "IC";
    public static final String ACCESS_CONTROL_SERVICE_KEY = "ACS";
    public static final String LEASE_PROVIDER_KEY = "LP";
    public static final String SESSION_SERVICE_FACET_NAME = "ISessionService";
    public static final String FACETS_PROPERTY_NAME = "facets";
    public static final String COMPONENT_ID_PROPERTY_NAME = "component_id";

    private static Object fetchACS(ORB orb, String host, int port, String key) throws ACSUnavailableException {
        Object obj = orb.string_to_object("corbaloc::1.0@" + host + ":" + port + "/" + key);
        if (obj == null) {
            throw new ACSUnavailableException();
        }
        try {
            if (obj._non_existent()) {
                throw new ACSUnavailableException();
            }
        }
        catch (OBJECT_NOT_EXIST e) {
            throw new ACSUnavailableException();
        }
        return obj;
    }

    public static IAccessControlService fetchAccessControlService(ORB orb, String host, int port) throws ACSUnavailableException {
        Object obj = Utils.fetchACS(orb, host, port, ACCESS_CONTROL_SERVICE_KEY);
        return IAccessControlServiceHelper.narrow((Object)obj);
    }

    public static IComponent fetchAccessControlServiceIComponent(ORB orb, String host, int port) throws ACSUnavailableException {
        Object obj = Utils.fetchACS(orb, host, port, ICOMPONENT_KEY);
        return IComponentHelper.narrow((Object)obj);
    }

    public static ILeaseProvider fetchAccessControlServiceLeaseProvider(ORB orb, String host, int port) throws ACSUnavailableException {
        Object obj = Utils.fetchACS(orb, host, port, LEASE_PROVIDER_KEY);
        return ILeaseProviderHelper.narrow((Object)obj);
    }

    public static byte[] generateAnswer(byte[] challenge, PrivateKey privateKey, Certificate acsCertificate) throws GeneralSecurityException {
        byte[] plainChallenge = CryptoUtils.decrypt(privateKey, challenge);
        return CryptoUtils.encrypt(acsCertificate, plainChallenge);
    }
}

