package tecgraf.openbus;

import org.omg.CORBA.NO_PERMISSION;

import tecgraf.openbus.core.v2_0.services.access_control.InvalidLoginCode;
import tecgraf.openbus.core.v2_0.services.access_control.InvalidRemoteCode;

/**
 * Callback de despacho de chamada.
 * <p>
 * Interface a ser implementada pelo objeto de callback a ser chamado quando uma
 * chamada proveniente de um barramento  recebida, que define a conexo a ser
 * utilizada na validao dessa chamada.
 * 
 * @author Tecgraf
 */
public interface CallDispatchCallback {

  /**
   * Callback de login invlido.
   * <p>
   * Mtodo a ser implementado pelo objeto de callback a ser chamado quando uma
   * chamada proveniente de um barramento  recebida. Esse mtodo  chamado para
   * determinar a conexo a ser utilizada na validao de cada chamada recebida.
   * Se a conexo informada no estiver conectada ao mesmo barramento indicado
   * pelo parmetro 'busid', a chamada provavelmente ser recusada com um
   * {@link NO_PERMISSION}[{@link InvalidLoginCode}] pelo fato do login
   * provavelmente no ser vlido no barramento da conexo. Como resultado disso
   * o cliente da chamada poder indicar que o servidor no est implementado
   * corretamente e lanar a exceo {@link NO_PERMISSION}[
   * {@link InvalidRemoteCode}]. Caso alguma exceo ocorra durante a execuo
   * do mtodo e no seja tratada, o erro ser capturado pelo interceptador e
   * registrado no log.
   * 
   * @param context Gerenciador de contexto do ORB que recebeu a chamada.
   * @param busid Identificao do barramento atravs do qual a chamada foi
   *        feita.
   * @param loginId Informaes do login que se tornou invlido.
   * @param object_id Idenficador opaco descrevendo o objeto sendo chamado.
   * @param operation Nome da operao sendo chamada.
   * 
   * @return Conexo a ser utilizada para receber a chamada.
   */
  Connection dispatch(OpenBusContext context, String busid, String loginId,
    byte[] object_id, String operation);

}
