package tecgraf.openbus.assistant;

import java.util.Properties;

import org.omg.CORBA.ORB;

/**
 * 
 * Representa um conjunto de parmetros opcionais que podem ser utilizados para
 * definir parmetros de configurao na construo do Assistente.
 * <p>
 * Os parmetros opicionais so descritos abaixo:
 * <ul>
 * <li>interval: Tempo em segundos indicando o tempo mnimo de espera antes de
 * cada nova tentativa aps uma falha na execuo de uma tarefa. Por exemplo,
 * depois de uma falha na tentativa de um login ou registro de oferta, o
 * assistente espera pelo menos o tempo indicado por esse parmetro antes de
 * tentar uma nova tentativa.
 * <li>orb: O ORB a ser utilizado pelo assistente para realizar suas tarefas. O
 * assistente tambm configura esse ORB de forma que todas as chamadas feitas
 * por ele sejam feitas com a identidade do login estabelecido pelo assistente.
 * Esse ORB deve ser iniciado de acordo com os requisitos do projeto OpenBus,
 * como feito pela operao 'ORBInitializer::initORB()'.
 * <li>connprops: Propriedades da conexo a ser criada com o barramento
 * espeficiado. Para maiores informaes sobre essas propriedades, veja a
 * operao 'OpenBusContext::createConnection()'.
 * <li>callback: Objeto de callback que recebe notificaes de falhas das
 * tarefas realizadas pelo assistente.
 * </ul>
 * 
 * @author Tecgraf
 */
public class AssistantParams {
  /**
   * Tempo em segundos indicando o tempo mnimo de espera antes de cada nova
   * tentativa aps uma falha na execuo de uma tarefa. Por exemplo, depois de
   * uma falha na tentativa de um login ou registro de oferta, o assistente
   * espera pelo menos o tempo indicado por esse parmetro antes de tentar uma
   * nova tentativa.
   */
  public Integer interval;
  /**
   * O ORB a ser utilizado pelo assistente para realizar suas tarefas. O
   * assistente tambm configura esse ORB de forma que todas as chamadas feitas
   * por ele sejam feitas com a identidade do login estabelecido pelo
   * assistente. Esse ORB deve ser iniciado de acordo com os requisitos do
   * projeto OpenBus, como feito pela operao 'ORBInitializer::initORB()'.
   */
  public ORB orb;
  /**
   * Propriedades da conexo a ser criada com o barramento espeficiado. Para
   * maiores informaes sobre essas propriedades, veja a operao
   * 'OpenBusContext::createConnection()'.
   */
  public Properties connprops;
  /**
   * Objeto de callback que recebe notificaes de falhas das tarefas realizadas
   * pelo assistente.
   */
  public OnFailureCallback callback;
}