package tecgraf.openbus.core;

import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.Object;

import scs.core.IComponent;
import scs.core.IComponentHelper;
import tecgraf.openbus.core.v1_05.access_control_service.IAccessControlService;
import tecgraf.openbus.core.v1_05.access_control_service.IAccessControlServiceHelper;

/**
 * Informaes do suporte legado.
 * 
 * @author Tecgraf
 */
final class LegacyInfo {

  /**   */
  private Object rawObject;
  /** Referncia para o componente legado */
  private IComponent bus;
  /** Referncia para o servio de controle de acesso legado. */
  private IAccessControlService accessControl;

  /**
   * Construtor.
   * 
   * @param obj referncia para o componente legado.
   */
  LegacyInfo(org.omg.CORBA.Object obj) {
    this.rawObject = obj;
  }

  /**
   * Recupera a referncia do controle de acesso legado
   * 
   * @return o controle de acesso legado.
   */
  IAccessControlService getAccessControl() {
    return accessControl;
  }

  /**
   * Atualiza a referncia para as facetas especficas.
   * 
   * @return <code>true</code> caso o suporte legado foi encontrado, e
   *         <code>false</code> caso o suporte legado no esteja ativo.
   */
  boolean activateLegacySuport() {
    boolean existent = false;
    try {
      if (rawObject != null && !rawObject._non_existent()) {
        existent = true;
      }
    }
    catch (OBJECT_NOT_EXIST e) {
      return false;
    }
    if (rawObject._is_a(IComponentHelper.id())) {
      this.bus = IComponentHelper.narrow(rawObject);
    }
    if (this.bus == null) {
      return false;
    }
    org.omg.CORBA.Object obj =
      this.bus.getFacet(IAccessControlServiceHelper.id());
    this.accessControl = IAccessControlServiceHelper.narrow(obj);
    return existent;
  }
}
