package tecgraf.openbus.core;

import java.util.Properties;

import org.omg.CORBA.NO_PERMISSION;
import org.omg.CORBA.ORB;

import tecgraf.openbus.OpenBusContext;
import tecgraf.openbus.core.v2_0.services.access_control.InvalidChainCode;
import tecgraf.openbus.core.v2_0.services.access_control.InvalidRemoteCode;
import tecgraf.openbus.core.v2_0.services.access_control.NoLoginCode;
import tecgraf.openbus.core.v2_0.services.access_control.UnknownBusCode;
import tecgraf.openbus.core.v2_0.services.access_control.UnverifiedLoginCode;

/**
 * Inicializador de {@link ORB}s para acesso a barramentos OpenBus.
 * <p>
 * Esse objeto  utilizado para obteno de {@link ORB}s CORBA a ser utilizados
 * exclusimamente para chamadas atravs de barramentos OpenBus.
 * 
 * @author Tecgraf
 */
public class ORBInitializer {

  /**
   * Inicializa um {@link ORB} utilizado exclusivamente para chamadas atravs de
   * barramentos OpenBus.
   * <p>
   * Inicializa um {@link ORB} utilizado exclusivamente para chamadas atravs de
   * barramentos OpenBus, ou seja, esse ORB no pode ser utilizado para fazer
   * chamadas CORBA ordinrias sem o controle de acesso do OpenBus que permite
   * identificao da origem das chamadas. Esse controle de acesso  feito
   * atravs conexes, que so obtidas e manipuladas atravs de um
   * {@link OpenBusContext}. Cada ORB possui um OpenBusContext associado, que
   * pode ser obitido atravs do comando:
   * {@link ORB#resolve_initial_references(String)
   * resolve_initial_reference("OpenBusContext")}
   * <p>
   * O ORB  inicializado da mesma forma feita pela operao {@link ORB#init}
   * definida pelo padro CORBA. Em particular, algumas implementaes de CORBA
   * no permitem inicializao de mltiplos ORBs num mesmo processo.
   * <p>
   * Chamadas realizadas e recebidas atravs deste ORB so interceptadas pela
   * biblioteca de acesso do OpenBus e podem lanar excees de sistema de CORBA
   * definidas pelo OpenBus. A seguir so apresentadas essas excees:
   * <ul>
   * <li>{@link NO_PERMISSION}[{@link NoLoginCode}]: Nenhuma conexo "Requester"
   * com login vlido est associada ao contexto atual, ou seja, a conexo
   * "Requester" corrente est desautenticada.
   * <li>{@link NO_PERMISSION}[{@link InvalidChainCode}]: A cadeia de chamadas
   * associada ao contexto atual no  compatvel com o login da conexo
   * "Requester" desse mesmo contexto. Isso ocorre pois no  possvel fazer
   * chamadas dentro de uma cadeia recebida por uma conexo com um login
   * diferente.
   * <li>{@link NO_PERMISSION}[{@link UnknownBusCode}]: O ORB remoto que recebeu
   * a chamada indicou que no possui uma conexo com login vlido no barramento
   * atravs do qual a chamada foi realizada, portanto no  capaz de validar a
   * chamada para que esta seja processada.
   * <li>{@link NO_PERMISSION}[{@link UnverifiedLoginCode}]: O ORB remoto que
   * recebeu a chamada indicou que no no  capaz de validar a chamada para que
   * esta seja processada. Isso indica que o lado remoto tem problemas de acesso
   * aos servios ncleo do barramento.
   * <li>{@link NO_PERMISSION}[{@link InvalidRemoteCode}]: O ORB remoto que
   * recebeu a chamada no est se comportando de acordo com o protocolo OpenBus
   * 2.0, o que indica que est mal implementado e tipicamente representa um bug
   * no servidor sendo chamado ou um erro de implantao do barramento.
   * </ul>
   * 
   * @return O {@link ORB} inicializado, similar  operao {@link ORB#init}
   *         definida pelo padro CORBA.
   */
  public static ORB initORB() {
    return ORBInitializer.initORB(null, null);
  }

  /**
   * Inicializa um {@link ORB} utilizado exclusivamente para chamadas atravs de
   * barramentos OpenBus.
   * <p>
   * Inicializa um {@link ORB} utilizado exclusivamente para chamadas atravs de
   * barramentos OpenBus, ou seja, esse ORB no pode ser utilizado para fazer
   * chamadas CORBA ordinrias sem o controle de acesso do OpenBus que permite
   * identificao da origem das chamadas. Esse controle de acesso  feito
   * atravs conexes, que so obtidas e manipuladas atravs de um
   * {@link OpenBusContext}. Cada ORB possui um OpenBusContext associado, que
   * pode ser obitido atravs do comando:
   * {@link ORB#resolve_initial_references(String)
   * resolve_initial_reference("OpenBusContext")}
   * <p>
   * O ORB  inicializado da mesma forma feita pela operao {@link ORB#init}
   * definida pelo padro CORBA. Em particular, algumas implementaes de CORBA
   * no permitem inicializao de mltiplos ORBs num mesmo processo.
   * <p>
   * Chamadas realizadas e recebidas atravs deste ORB so interceptadas pela
   * biblioteca de acesso do OpenBus e podem lanar excees de sistema de CORBA
   * definidas pelo OpenBus. A seguir so apresentadas essas excees:
   * <ul>
   * <li>{@link NO_PERMISSION}[{@link NoLoginCode}]: Nenhuma conexo "Requester"
   * com login vlido est associada ao contexto atual, ou seja, a conexo
   * "Requester" corrente est desautenticada.
   * <li>{@link NO_PERMISSION}[{@link InvalidChainCode}]: A cadeia de chamadas
   * associada ao contexto atual no  compatvel com o login da conexo
   * "Requester" desse mesmo contexto. Isso ocorre pois no  possvel fazer
   * chamadas dentro de uma cadeia recebida por uma conexo com um login
   * diferente.
   * <li>{@link NO_PERMISSION}[{@link UnknownBusCode}]: O ORB remoto que recebeu
   * a chamada indicou que no possui uma conexo com login vlido no barramento
   * atravs do qual a chamada foi realizada, portanto no  capaz de validar a
   * chamada para que esta seja processada.
   * <li>{@link NO_PERMISSION}[{@link UnverifiedLoginCode}]: O ORB remoto que
   * recebeu a chamada indicou que no no  capaz de validar a chamada para que
   * esta seja processada por alguma falha ao acessar os servios ncleo do
   * barramento. Isso tipicamente indica que o lado remoto tem problemas de
   * acesso aos servios ncleo do barramento.
   * <li>{@link NO_PERMISSION}[{@link InvalidRemoteCode}]: O ORB remoto que
   * recebeu a chamada no est se comportando de acordo com o protocolo OpenBus
   * 2.0, o que indica que est mal implementado e tipicamente representa um bug
   * no servidor sendo chamado ou um erro de implantao do barramento.
   * </ul>
   * 
   * @param args Parmetros usados na inicializao do {@link ORB}, similar 
   *        operao {@link ORB#init} definida pelo padro CORBA.
   * 
   * @return O {@link ORB} inicializado, similar  operao {@link ORB#init}
   *         definida pelo padro CORBA.
   */
  public static ORB initORB(String[] args) {
    return ORBInitializer.initORB(args, null);
  }

  /**
   * Inicializa um {@link ORB} utilizado exclusivamente para chamadas atravs de
   * barramentos OpenBus.
   * <p>
   * Inicializa um {@link ORB} utilizado exclusivamente para chamadas atravs de
   * barramentos OpenBus, ou seja, esse ORB no pode ser utilizado para fazer
   * chamadas CORBA ordinrias sem o controle de acesso do OpenBus que permite
   * identificao da origem das chamadas. Esse controle de acesso  feito
   * atravs conexes, que so obtidas e manipuladas atravs de um
   * {@link OpenBusContext}. Cada ORB possui um OpenBusContext associado, que
   * pode ser obitido atravs do comando:
   * {@link ORB#resolve_initial_references(String)
   * resolve_initial_reference("OpenBusContext")}
   * <p>
   * O ORB  inicializado da mesma forma feita pela operao {@link ORB#init}
   * definida pelo padro CORBA. Em particular, algumas implementaes de CORBA
   * no permitem inicializao de mltiplos ORBs num mesmo processo.
   * <p>
   * Chamadas realizadas e recebidas atravs deste ORB so interceptadas pela
   * biblioteca de acesso do OpenBus e podem lanar excees de sistema de CORBA
   * definidas pelo OpenBus. A seguir so apresentadas essas excees:
   * <ul>
   * <li>{@link NO_PERMISSION}[{@link NoLoginCode}]: Nenhuma conexo "Requester"
   * com login vlido est associada ao contexto atual, ou seja, a conexo
   * "Requester" corrente est desautenticada.
   * <li>{@link NO_PERMISSION}[{@link InvalidChainCode}]: A cadeia de chamadas
   * associada ao contexto atual no  compatvel com o login da conexo
   * "Requester" desse mesmo contexto. Isso ocorre pois no  possvel fazer
   * chamadas dentro de uma cadeia recebida por uma conexo com um login
   * diferente.
   * <li>{@link NO_PERMISSION}[{@link UnknownBusCode}]: O ORB remoto que recebeu
   * a chamada indicou que no possui uma conexo com login vlido no barramento
   * atravs do qual a chamada foi realizada, portanto no  capaz de validar a
   * chamada para que esta seja processada.
   * <li>{@link NO_PERMISSION}[{@link UnverifiedLoginCode}]: O ORB remoto que
   * recebeu a chamada indicou que no no  capaz de validar a chamada para que
   * esta seja processada por alguma falha ao acessar os servios ncleo do
   * barramento. Isso tipicamente indica que o lado remoto tem problemas de
   * acesso aos servios ncleo do barramento.
   * <li>{@link NO_PERMISSION}[{@link InvalidRemoteCode}]: O ORB remoto que
   * recebeu a chamada no est se comportando de acordo com o protocolo OpenBus
   * 2.0, o que indica que est mal implementado e tipicamente representa um bug
   * no servidor sendo chamado ou um erro de implantao do barramento.
   * </ul>
   * 
   * @param args Parmetros usados na inicializao do {@link ORB}, similar 
   *        operao {@link ORB#init} definida pelo padro CORBA.
   * @param props Propriedades usados na inicializao do {@link ORB}, similar 
   *        operao {@link ORB#init} definida pelo padro CORBA.
   * 
   * @return O {@link ORB} inicializado, similar  operao {@link ORB#init}
   *         definida pelo padro CORBA.
   */
  public static ORB initORB(String[] args, Properties props) {
    ORB orb = createORB(args, props);
    ORBMediator mediator = ORBUtils.getMediator(orb);
    mediator.setORB(orb);
    OpenBusContextImpl manager = ORBUtils.getConnectionManager(orb);
    manager.setORB(orb);
    return orb;
  }

  /**
   * Cria o ORB.
   * 
   * @param args argumentos
   * @param props propriedades
   * @return o ORB
   */
  private static ORB createORB(String[] args, Properties props) {
    ORBBuilder orbBuilder = new ORBBuilder(args, props);
    orbBuilder.addInitializer(new ORBInitializerInfo(
      InternalJacORBInitializer.class));
    return orbBuilder.build();
  }

}
