/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.openbus.assistant;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.NO_PERMISSION;
import org.omg.CORBA.ORB;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.TRANSIENT;
import scs.core.IComponent;
import tecgraf.openbus.Connection;
import tecgraf.openbus.InvalidLoginCallback;
import tecgraf.openbus.OpenBusContext;
import tecgraf.openbus.PrivateKey;
import tecgraf.openbus.assistant.AssistantParams;
import tecgraf.openbus.assistant.AuthArgs;
import tecgraf.openbus.assistant.OnFailureCallback;
import tecgraf.openbus.core.ORBInitializer;
import tecgraf.openbus.core.v2_0.OctetSeqHolder;
import tecgraf.openbus.core.v2_0.services.ServiceFailure;
import tecgraf.openbus.core.v2_0.services.access_control.AccessDenied;
import tecgraf.openbus.core.v2_0.services.access_control.LoginInfo;
import tecgraf.openbus.core.v2_0.services.access_control.LoginProcess;
import tecgraf.openbus.core.v2_0.services.access_control.MissingCertificate;
import tecgraf.openbus.core.v2_0.services.offer_registry.InvalidProperties;
import tecgraf.openbus.core.v2_0.services.offer_registry.InvalidService;
import tecgraf.openbus.core.v2_0.services.offer_registry.OfferRegistry;
import tecgraf.openbus.core.v2_0.services.offer_registry.ServiceOffer;
import tecgraf.openbus.core.v2_0.services.offer_registry.ServiceOfferDesc;
import tecgraf.openbus.core.v2_0.services.offer_registry.ServiceProperty;
import tecgraf.openbus.core.v2_0.services.offer_registry.UnauthorizedFacets;
import tecgraf.openbus.exception.AlreadyLoggedIn;
import tecgraf.openbus.exception.InvalidLoginProcess;
import tecgraf.openbus.exception.InvalidPropertyValue;

public abstract class Assistant {
    private static final Logger logger = Logger.getLogger(Assistant.class.getName());
    private int interval = 5;
    private String host;
    private int port;
    private ORB orb;
    private OpenBusContext context;
    private Connection conn;
    private OnFailureCallback callback;
    private List<Offer> offers = Collections.synchronizedList(new ArrayList());
    private volatile boolean shutdown = false;
    private ExecutorService threadPool = Executors.newCachedThreadPool(new ThreadFactory(){

        @Override
        public Thread newThread(Runnable task) {
            Thread thread = new Thread(task);
            thread.setDaemon(true);
            return thread;
        }
    });

    public Assistant(String host, int port) {
        this(host, port, null);
    }

    public Assistant(String host, int port, AssistantParams params) {
        this.host = host;
        this.port = port;
        if (params == null) {
            params = new AssistantParams();
        }
        this.orb = params.orb;
        if (this.orb == null) {
            this.orb = ORBInitializer.initORB();
        }
        try {
            this.context = (OpenBusContext)this.orb.resolve_initial_references("OpenBusContext");
        }
        catch (InvalidName e) {
            throw new IllegalArgumentException("ORB utilizado n\u00e3o foi inicializado corretamente.", e);
        }
        try {
            this.conn = this.context.createConnection(host, port, params.connprops);
        }
        catch (InvalidPropertyValue e) {
            throw new IllegalArgumentException("Propriedades definidas para a conex\u00e3o s\u00e3o inv\u00e1lidas", e);
        }
        if (this.context.getDefaultConnection() != null) {
            throw new IllegalArgumentException("ORB j\u00e1 est\u00e1 em uso.");
        }
        this.context.setDefaultConnection(this.conn);
        this.conn.onInvalidLoginCallback(new OnInvalidLogin());
        if (params.interval != null) {
            this.interval = params.interval;
        }
        this.callback = params.callback != null ? params.callback : new DefaultFailureCallback();
        this.threadPool.execute(new DoLogin(this));
    }

    public static Assistant createWithPassword(String host, int port, String entity, byte[] password) {
        return Assistant.createWithPassword(host, port, entity, password, null);
    }

    public static Assistant createWithPassword(String host, int port, final String entity, final byte[] password, AssistantParams params) {
        return new Assistant(host, port, params){

            @Override
            public AuthArgs onLoginAuthentication() {
                return new AuthArgs(entity, password);
            }
        };
    }

    public static Assistant createWithPrivateKey(String host, int port, String entity, PrivateKey key) {
        return Assistant.createWithPrivateKey(host, port, entity, key, null);
    }

    public static Assistant createWithPrivateKey(String host, int port, final String entity, final PrivateKey key, AssistantParams params) {
        return new Assistant(host, port, params){

            @Override
            public AuthArgs onLoginAuthentication() {
                return new AuthArgs(entity, key);
            }
        };
    }

    public ORB orb() {
        return this.orb;
    }

    public void registerService(IComponent component, ServiceProperty[] properties) {
        Offer offer = new Offer(this, component, properties);
        this.offers.add(offer);
        this.threadPool.execute(new DoRegister(this, offer));
    }

    public ServiceOfferDesc[] findServices(ServiceProperty[] properties, int retries) throws Throwable {
        Throwable last;
        int attempt = retries;
        do {
            last = null;
            if (this.conn.login() == null) continue;
            try {
                ServiceOfferDesc[] offerDescs = this.find(properties);
                if (offerDescs != null) {
                    return offerDescs;
                }
            }
            catch (Throwable e) {
                last = e;
            }
        } while (this.shouldRetry(retries, --attempt));
        if (last != null) {
            throw last;
        }
        return new ServiceOfferDesc[0];
    }

    public ServiceOfferDesc[] getAllServices(int retries) throws Throwable {
        Throwable last;
        int attempt = retries;
        do {
            last = null;
            if (this.conn.login() == null) continue;
            try {
                ServiceOfferDesc[] offerDescs = this.getAll();
                if (offerDescs != null) {
                    return offerDescs;
                }
            }
            catch (Throwable e) {
                last = e;
            }
        } while (this.shouldRetry(retries, --attempt));
        if (last != null) {
            throw last;
        }
        return new ServiceOfferDesc[0];
    }

    public LoginProcess startSharedAuth(OctetSeqHolder secret, int retries) throws Throwable {
        Throwable last;
        int attempt = retries;
        do {
            last = null;
            if (this.conn.login() == null) continue;
            try {
                LoginProcess process = this.startSharedAuthentication(secret);
                if (process != null) {
                    return process;
                }
            }
            catch (Throwable e) {
                last = e;
            }
        } while (this.shouldRetry(retries, --attempt));
        if (last != null) {
            throw last;
        }
        return null;
    }

    private boolean shouldRetry(int retries, int attempt) {
        if (retries < 0 || attempt >= 0) {
            try {
                Thread.sleep(this.interval * 1000);
            }
            catch (InterruptedException e) {
                logger.log(Level.SEVERE, "'Find' foi interrompido.", e);
            }
        } else {
            return false;
        }
        return true;
    }

    public void shutdown() {
        this.shutdown = true;
        this.threadPool.shutdownNow();
        try {
            long timeout = 3 * this.interval;
            TimeUnit timeUnit = TimeUnit.SECONDS;
            if (!this.threadPool.awaitTermination(timeout, timeUnit)) {
                logger.log(Level.WARNING, String.format("pool de threads n\u00e3o finalizou. Timeout = %s s", timeout));
            }
        }
        catch (InterruptedException e) {
            logger.log(Level.SEVERE, "pool de threads foi interrompido.", e);
        }
        try {
            this.conn.logout();
        }
        catch (ServiceFailure e) {
            logger.log(Level.SEVERE, String.format("falha severa no barramento em %s:%s : %s", this.host, this.port, e.message), (Throwable)((Object)e));
        }
        catch (TRANSIENT e) {
            logger.log(Level.WARNING, String.format("o barramento em %s:%s esta inacess\u00edvel no momento", this.host, this.port), e);
        }
        catch (COMM_FAILURE e) {
            logger.log(Level.WARNING, "falha de comunica\u00e7\u00e3o ao acessar servi\u00e7os n\u00facleo do barramento", e);
        }
        catch (NO_PERMISSION e) {
            if (e.minor == 1112888319) {
                logger.log(Level.WARNING, "n\u00e3o h\u00e1 um login v\u00e1lido no momento", e);
            }
            logger.log(Level.SEVERE, String.format("erro de NO_PERMISSION n\u00e3o esperado: minor_code = %s", e.minor), e);
        }
        this.context.setDefaultConnection(null);
    }

    public abstract AuthArgs onLoginAuthentication();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean login() {
        AuthArgs args = this.onLoginAuthentication();
        boolean failed = true;
        Object ex = null;
        try {
            if (args != null) {
                switch (args.mode) {
                    case AuthByPassword: {
                        this.conn.loginByPassword(args.entity, args.password);
                    }
                    case AuthByCertificate: {
                        this.conn.loginByCertificate(args.entity, args.privkey);
                    }
                    case AuthBySharing: {
                        this.conn.loginBySharedAuth(args.attempt, args.secret);
                    }
                }
                failed = false;
            } else {
                ex = new NullPointerException("'onLoginAuthentication' retornou argumentos de login nulos.");
            }
        }
        catch (AccessDenied e) {
            ex = e;
            logger.log(Level.SEVERE, "Erro ao realizar login.", (Throwable)((Object)e));
        }
        catch (AlreadyLoggedIn e) {
            failed = false;
        }
        catch (MissingCertificate e) {
            ex = e;
            logger.log(Level.SEVERE, "Erro ao realizar loginByCertificate.", (Throwable)((Object)e));
        }
        catch (InvalidLoginProcess e) {
            ex = e;
            logger.log(Level.SEVERE, "Erro ao realizar loginBySharedAuth.", e);
        }
        catch (ServiceFailure e) {
            ex = e;
            logger.log(Level.SEVERE, "Erro ao realizar login.", (Throwable)((Object)e));
        }
        catch (TRANSIENT e) {
            ex = e;
            logger.log(Level.WARNING, String.format("o barramento em %s:%s esta inacess\u00edvel no momento", this.host, this.port), e);
        }
        catch (COMM_FAILURE e) {
            ex = e;
            logger.log(Level.WARNING, "falha de comunica\u00e7\u00e3o ao acessar servi\u00e7os n\u00facleo do barramento", e);
        }
        catch (NO_PERMISSION e) {
            ex = e;
            if (e.minor == 1112888319) {
                logger.log(Level.WARNING, "n\u00e3o h\u00e1 um login v\u00e1lido no momento", e);
            } else {
                logger.log(Level.SEVERE, String.format("erro de NO_PERMISSION n\u00e3o esperado: minor_code = %s", e.minor), e);
            }
        }
        catch (Throwable e) {
            ex = e;
            logger.log(Level.SEVERE, "Erro inesperado!", e);
        }
        finally {
            if (failed) {
                try {
                    this.callback.onLoginFailure(this, (Throwable)ex);
                }
                catch (Throwable e) {
                    logger.log(Level.SEVERE, "Erro inesperado ao chamar callback!", e);
                }
            }
        }
        return failed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServiceOfferDesc[] find(ServiceProperty[] props) throws Throwable {
        ServiceOfferDesc[] offerDescs;
        block28: {
            boolean failed = true;
            Object ex = null;
            offerDescs = null;
            try {
                OfferRegistry offerRegistry = this.context.getOfferRegistry();
                offerDescs = offerRegistry.findServices(props);
                failed = false;
            }
            catch (ServiceFailure e) {
                ex = e;
                logger.log(Level.SEVERE, "Erro ao buscar ofertas.", (Throwable)((Object)e));
            }
            catch (TRANSIENT e) {
                ex = e;
                logger.log(Level.WARNING, String.format("o barramento em %s:%s esta inacess\u00edvel no momento", this.host, this.port), e);
            }
            catch (COMM_FAILURE e) {
                ex = e;
                logger.log(Level.WARNING, "falha de comunica\u00e7\u00e3o ao acessar servi\u00e7os n\u00facleo do barramento", e);
            }
            catch (NO_PERMISSION e) {
                ex = e;
                if (e.minor == 1112888319) {
                    logger.log(Level.WARNING, "n\u00e3o h\u00e1 um login v\u00e1lido no momento", e);
                }
                logger.log(Level.SEVERE, String.format("erro de NO_PERMISSION n\u00e3o esperado: minor_code = %s", e.minor), e);
            }
            catch (Throwable e) {
                ex = e;
                logger.log(Level.SEVERE, "Erro inesperado!", e);
            }
            finally {
                if (!failed) break block28;
                try {
                    this.callback.onFindFailure(this, (Throwable)ex);
                }
                catch (Throwable e) {
                    logger.log(Level.SEVERE, "Erro inesperado ao chamar callback!", e);
                }
                throw ex;
            }
        }
        return offerDescs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServiceOfferDesc[] getAll() throws Throwable {
        ServiceOfferDesc[] offerDescs;
        block28: {
            boolean failed = true;
            Object ex = null;
            offerDescs = null;
            try {
                OfferRegistry offerRegistry = this.context.getOfferRegistry();
                offerDescs = offerRegistry.getAllServices();
                failed = false;
            }
            catch (ServiceFailure e) {
                ex = e;
                logger.log(Level.SEVERE, "Erro ao recuperar ofertas.", (Throwable)((Object)e));
            }
            catch (TRANSIENT e) {
                ex = e;
                logger.log(Level.WARNING, String.format("o barramento em %s:%s esta inacess\u00edvel no momento", this.host, this.port), e);
            }
            catch (COMM_FAILURE e) {
                ex = e;
                logger.log(Level.WARNING, "falha de comunica\u00e7\u00e3o ao acessar servi\u00e7os n\u00facleo do barramento", e);
            }
            catch (NO_PERMISSION e) {
                ex = e;
                if (e.minor == 1112888319) {
                    logger.log(Level.WARNING, "n\u00e3o h\u00e1 um login v\u00e1lido no momento", e);
                }
                logger.log(Level.SEVERE, String.format("erro de NO_PERMISSION n\u00e3o esperado: minor_code = %s", e.minor), e);
            }
            catch (Throwable e) {
                ex = e;
                logger.log(Level.SEVERE, "Erro inesperado!", e);
            }
            finally {
                if (!failed) break block28;
                try {
                    this.callback.onFindFailure(this, (Throwable)ex);
                }
                catch (Throwable e) {
                    logger.log(Level.SEVERE, "Erro inesperado ao chamar callback!", e);
                }
                throw ex;
            }
        }
        return offerDescs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LoginProcess startSharedAuthentication(OctetSeqHolder secret) throws Throwable {
        LoginProcess attempt;
        block28: {
            boolean failed = true;
            Object ex = null;
            attempt = null;
            try {
                attempt = this.conn.startSharedAuth(secret);
                failed = false;
            }
            catch (ServiceFailure e) {
                ex = e;
                logger.log(Level.SEVERE, "Erro ao iniciar processo de autentica\u00e7\u00e3o compartilhada.", (Throwable)((Object)e));
            }
            catch (TRANSIENT e) {
                ex = e;
                logger.log(Level.WARNING, String.format("o barramento em %s:%s esta inacess\u00edvel no momento", this.host, this.port), e);
            }
            catch (COMM_FAILURE e) {
                ex = e;
                logger.log(Level.WARNING, "falha de comunica\u00e7\u00e3o ao acessar servi\u00e7os n\u00facleo do barramento", e);
            }
            catch (NO_PERMISSION e) {
                ex = e;
                if (e.minor == 1112888319) {
                    logger.log(Level.WARNING, "n\u00e3o h\u00e1 um login v\u00e1lido no momento", e);
                }
                logger.log(Level.SEVERE, String.format("erro de NO_PERMISSION n\u00e3o esperado: minor_code = %s", e.minor), e);
            }
            catch (Throwable e) {
                ex = e;
                logger.log(Level.SEVERE, "Erro inesperado!", e);
            }
            finally {
                if (!failed) break block28;
                try {
                    this.callback.onStartSharedAuthFailure(this, (Throwable)ex);
                }
                catch (Throwable e) {
                    logger.log(Level.SEVERE, "Erro inesperado ao chamar callback!", e);
                }
                throw ex;
            }
        }
        return attempt;
    }

    private class DefaultFailureCallback
    implements OnFailureCallback {
        private DefaultFailureCallback() {
        }

        @Override
        public void onLoginFailure(Assistant assistant, Throwable exception) {
        }

        @Override
        public void onRegisterFailure(Assistant assistant, IComponent component, ServiceProperty[] properties, Throwable except) {
        }

        @Override
        public void onFindFailure(Assistant assistant, Throwable exception) {
        }

        @Override
        public void onStartSharedAuthFailure(Assistant assistant, Throwable except) {
        }
    }

    private class DoRegister
    implements Runnable {
        Assistant assist;
        private Offer offer;

        public DoRegister(Assistant assist, Offer offer) {
            this.assist = assist;
            this.offer = offer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            logger.fine("Iniciando tarefa 'DoRegister'.");
            block7: while (!this.assist.shutdown) {
                boolean retry = true;
                Object object = this.offer.lock;
                synchronized (object) {
                    while (!this.offer.event.get() && !this.assist.shutdown) {
                        try {
                            this.offer.lock.wait();
                        }
                        catch (InterruptedException e) {
                            logger.fine("Thread 'DoRegister' foi interrompida.");
                            break;
                        }
                    }
                    this.offer.event.set(false);
                }
                while (retry && !this.assist.shutdown) {
                    logger.fine("Thread 'DoRegister' tratando evento");
                    LoginInfo login = this.assist.conn.login();
                    if (login != null) {
                        retry = !login.id.equals(this.offer.loginId()) ? this.offer.registryOffer() : false;
                    }
                    if (retry) {
                        try {
                            Thread.sleep(this.assist.interval * 1000);
                            continue;
                        }
                        catch (InterruptedException e) {
                            logger.warning("Thread 'DoRegister' foi interrompida.");
                            continue block7;
                        }
                    }
                    logger.fine("Completou atendimento de evento 'DoRegister'.");
                }
            }
            logger.fine("Finalizando tarefa 'DoRegister'.");
        }
    }

    private class DoLogin
    implements Runnable {
        Assistant assist;

        public DoLogin(Assistant assist) {
            this.assist = assist;
        }

        @Override
        public void run() {
            boolean retry = true;
            logger.fine("Iniciando tarefa 'DoLogin'.");
            if (this.assist.conn.login() != null) {
                retry = false;
            }
            while (retry && !this.assist.shutdown) {
                retry = this.assist.login();
                if (!retry) continue;
                try {
                    Thread.sleep(this.assist.interval * 1000);
                }
                catch (InterruptedException e) {
                    logger.fine("Thread 'DoLogin' foi interrompida.");
                }
            }
            logger.fine("Finalizando tarefa 'DoLogin'.");
        }
    }

    private class OnInvalidLogin
    implements InvalidLoginCallback {
        private OnInvalidLogin() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void invalidLogin(Connection conn, LoginInfo login) {
            logger.fine("Iniciando callback 'OnInvalidLogin");
            DoLogin doLogin = new DoLogin(Assistant.this);
            doLogin.run();
            List list = Assistant.this.offers;
            synchronized (list) {
                for (Offer aOffer : Assistant.this.offers) {
                    aOffer.reset();
                }
            }
            logger.fine("Finalizando callback 'OnInvalidLogin");
        }
    }

    private class Offer {
        Assistant assist;
        IComponent component;
        ServiceProperty[] properties;
        AtomicReference<ServiceOfferDesc> offer = new AtomicReference();
        Object lock = new Object();
        AtomicBoolean event = new AtomicBoolean(true);

        public Offer(Assistant assist, IComponent component, ServiceProperty[] properties) {
            this.assist = assist;
            this.component = component;
            this.properties = Arrays.copyOf(properties, properties.length);
        }

        public String loginId() {
            ServiceOfferDesc desc = this.offer.get();
            if (desc != null) {
                for (ServiceProperty prop : desc.properties) {
                    if (!prop.name.equals("openbus.offer.login")) continue;
                    return prop.value;
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean registryOffer() {
            boolean failed = true;
            Object ex = null;
            try {
                OfferRegistry offerRegistry = this.assist.context.getOfferRegistry();
                ServiceOffer theOffer = offerRegistry.registerService(this.component, this.properties);
                this.offer.set(theOffer.describe());
                failed = false;
            }
            catch (UnauthorizedFacets e) {
                StringBuffer interfaces = new StringBuffer();
                for (String facet : e.facets) {
                    interfaces.append("\n  - ");
                    interfaces.append(facet);
                }
                ex = e;
                logger.log(Level.WARNING, String.format("a entidade n\u00e3o foi autorizada pelo administrador do barramento a ofertar os servi\u00e7os: %s", interfaces.toString()), (Throwable)((Object)e));
            }
            catch (InvalidService e) {
                ex = e;
                logger.log(Level.WARNING, "o servi\u00e7o ofertado apresentou alguma falha durante o registro.", (Throwable)((Object)e));
            }
            catch (InvalidProperties e) {
                StringBuffer props = new StringBuffer();
                for (ServiceProperty prop : e.properties) {
                    props.append("\n  - ");
                    props.append(String.format("name = %s, value = %s", prop.name, prop.value));
                }
                ex = e;
                logger.log(Level.WARNING, String.format("tentativa de registrar servi\u00e7o com propriedades inv\u00e1lidas: %s", props.toString()), (Throwable)((Object)e));
            }
            catch (ServiceFailure e) {
                ex = e;
                logger.log(Level.SEVERE, "Erro ao realizar login.", (Throwable)((Object)e));
            }
            catch (TRANSIENT e) {
                ex = e;
                logger.log(Level.WARNING, String.format("o barramento em %s:%s esta inacess\u00edvel no momento", this.assist.host, this.assist.port), e);
            }
            catch (COMM_FAILURE e) {
                ex = e;
                logger.log(Level.WARNING, "falha de comunica\u00e7\u00e3o ao acessar servi\u00e7os n\u00facleo do barramento", e);
            }
            catch (NO_PERMISSION e) {
                ex = e;
                if (e.minor == 1112888319) {
                    logger.log(Level.WARNING, "n\u00e3o h\u00e1 um login v\u00e1lido no momento", e);
                } else {
                    logger.log(Level.SEVERE, String.format("erro de NO_PERMISSION n\u00e3o esperado: minor_code = %s", e.minor), e);
                }
            }
            catch (Throwable e) {
                ex = e;
                logger.log(Level.SEVERE, "Erro inesperado!", e);
            }
            finally {
                if (failed) {
                    try {
                        this.assist.callback.onRegisterFailure(this.assist, this.component, this.properties, (Throwable)ex);
                    }
                    catch (Throwable e) {
                        logger.log(Level.SEVERE, "Erro inesperado ao chamar callback!", e);
                    }
                }
            }
            return failed;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void reset() {
            Object object = this.lock;
            synchronized (object) {
                this.event.set(true);
                this.lock.notifyAll();
                logger.fine("Resetando oferta.");
            }
        }
    }
}

