/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.openbus.core;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.omg.CORBA.INITIALIZE;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.Object;
import org.omg.IOP.Codec;
import org.omg.IOP.CodecFactory;
import org.omg.IOP.CodecFactoryHelper;
import org.omg.IOP.CodecFactoryPackage.UnknownEncoding;
import org.omg.IOP.Encoding;
import org.omg.PortableInterceptor.ClientRequestInterceptor;
import org.omg.PortableInterceptor.ORBInitInfo;
import org.omg.PortableInterceptor.ORBInitInfoPackage.DuplicateName;
import org.omg.PortableInterceptor.ORBInitInfoPackage.InvalidName;
import org.omg.PortableInterceptor.ORBInitializer;
import org.omg.PortableInterceptor.ServerRequestInterceptor;
import tecgraf.openbus.core.ClientRequestInterceptorImpl;
import tecgraf.openbus.core.ORBMediator;
import tecgraf.openbus.core.OpenBusContextImpl;
import tecgraf.openbus.core.ServerRequestInterceptorImpl;

public final class InternalJacORBInitializer
extends LocalObject
implements ORBInitializer {
    private static final Logger logger = Logger.getLogger(InternalJacORBInitializer.class.getName());
    private static final byte ENCODING_CDR_ENCAPS_MAJOR_VERSION = 1;
    private static final byte ENCODING_CDR_ENCAPS_MINOR_VERSION = 2;

    public void pre_init(ORBInitInfo info) {
        Codec codec = this.createCodec(info);
        int signedChainSlotId = info.allocate_slot_id();
        int currentThreadSlotId = info.allocate_slot_id();
        int ignoreThreadSlotId = info.allocate_slot_id();
        int joinedChainSlotId = info.allocate_slot_id();
        int joinedChainTargetSlotId = info.allocate_slot_id();
        int joinedBusSlotId = info.allocate_slot_id();
        int busSlotId = info.allocate_slot_id();
        OpenBusContextImpl multiplexer = new OpenBusContextImpl(currentThreadSlotId, ignoreThreadSlotId);
        try {
            info.register_initial_reference("OpenBusContext", (Object)multiplexer);
        }
        catch (InvalidName e) {
            String message = "Falha inesperada ao registrar o multiplexador";
            logger.log(Level.SEVERE, message, e);
            throw new INITIALIZE(message);
        }
        ORBMediator mediator = new ORBMediator(codec, signedChainSlotId, joinedChainSlotId, joinedChainTargetSlotId, joinedBusSlotId, busSlotId, multiplexer);
        try {
            info.register_initial_reference("openbus.ORBMediator", (Object)mediator);
        }
        catch (InvalidName e) {
            String message = "Falha inesperada ao registrar o mediador";
            logger.log(Level.SEVERE, message, e);
            throw new INITIALIZE(message);
        }
    }

    public void post_init(ORBInitInfo info) {
        ORBMediator mediator = this.getMediator(info);
        this.addClientInterceptor(info, mediator);
        this.addServerInterceptors(info, mediator);
    }

    private void addClientInterceptor(ORBInitInfo info, ORBMediator mediator) {
        try {
            info.add_client_request_interceptor((ClientRequestInterceptor)new ClientRequestInterceptorImpl("ClientRequestInterceptor", mediator));
        }
        catch (DuplicateName e) {
            String message = "Falha inesperada ao registrar o interceptador cliente";
            logger.log(Level.SEVERE, message, e);
            throw new INITIALIZE(message);
        }
    }

    private void addServerInterceptors(ORBInitInfo info, ORBMediator mediator) {
        try {
            info.add_server_request_interceptor((ServerRequestInterceptor)new ServerRequestInterceptorImpl("ServerRequestInterceptor", mediator));
        }
        catch (DuplicateName e) {
            String message = "Falha inesperada ao registrar o interceptador servidor";
            logger.log(Level.SEVERE, message, e);
            throw new INITIALIZE(message);
        }
    }

    private ORBMediator getMediator(ORBInitInfo info) {
        Object obj;
        try {
            obj = info.resolve_initial_references("openbus.ORBMediator");
        }
        catch (InvalidName e) {
            String message = "Falha inesperada ao obter o mediador";
            logger.log(Level.SEVERE, message, e);
            throw new INITIALIZE(message);
        }
        if (obj == null) {
            String message = "O mediador n\u00e3o foi encontrado";
            logger.severe(message);
            throw new INITIALIZE(message);
        }
        return (ORBMediator)obj;
    }

    private Codec createCodec(ORBInitInfo info) {
        Object obj;
        try {
            obj = info.resolve_initial_references("CodecFactory");
        }
        catch (InvalidName e) {
            String message = "Falha inesperada ao obter a f\u00e1brica de codificadores";
            logger.log(Level.SEVERE, message, e);
            throw new INITIALIZE(message);
        }
        CodecFactory codecFactory = CodecFactoryHelper.narrow((Object)obj);
        Encoding encoding = new Encoding(0, 1, 2);
        try {
            return codecFactory.create_codec(encoding);
        }
        catch (UnknownEncoding e) {
            String message = "Falha inesperada ao criar o codificador";
            logger.log(Level.SEVERE, message, e);
            throw new INITIALIZE(message);
        }
    }
}

