/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.openbus.core;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.omg.CORBA.Any;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.NO_PERMISSION;
import org.omg.CORBA.ORB;
import org.omg.CORBA.UserException;
import org.omg.PortableInterceptor.Current;
import org.omg.PortableInterceptor.InvalidSlot;
import org.omg.PortableInterceptor.RequestInfo;
import tecgraf.openbus.CallDispatchCallback;
import tecgraf.openbus.CallerChain;
import tecgraf.openbus.Connection;
import tecgraf.openbus.OpenBusContext;
import tecgraf.openbus.core.CallerChainImpl;
import tecgraf.openbus.core.ConnectionImpl;
import tecgraf.openbus.core.ORBMediator;
import tecgraf.openbus.core.ORBUtils;
import tecgraf.openbus.core.v2_0.credential.SignedCallChain;
import tecgraf.openbus.core.v2_0.credential.SignedCallChainHelper;
import tecgraf.openbus.core.v2_0.services.access_control.CallChain;
import tecgraf.openbus.core.v2_0.services.access_control.CallChainHelper;
import tecgraf.openbus.core.v2_0.services.access_control.LoginRegistry;
import tecgraf.openbus.core.v2_0.services.offer_registry.OfferRegistry;
import tecgraf.openbus.exception.InvalidPropertyValue;
import tecgraf.openbus.exception.OpenBusInternalException;

final class OpenBusContextImpl
extends LocalObject
implements OpenBusContext {
    private static final Logger logger = Logger.getLogger(OpenBusContextImpl.class.getName());
    private final int CURRENT_CONNECTION_SLOT_ID;
    private final int IGNORE_THREAD_SLOT_ID;
    private Map<Long, Connection> connectedThreads;
    private Connection defaultConn;
    private CallDispatchCallback dispatchCallback;
    private ORB orb;
    private final ReentrantReadWriteLock rwlock = new ReentrantReadWriteLock(true);
    private final ReentrantReadWriteLock.ReadLock readLock = this.rwlock.readLock();
    private final ReentrantReadWriteLock.WriteLock writeLock = this.rwlock.writeLock();

    public OpenBusContextImpl(int currentConnectionSlotId, int ignoreThreadSlotId) {
        this.connectedThreads = Collections.synchronizedMap(new HashMap());
        this.CURRENT_CONNECTION_SLOT_ID = currentConnectionSlotId;
        this.IGNORE_THREAD_SLOT_ID = ignoreThreadSlotId;
    }

    @Override
    public ORB orb() {
        return this.orb;
    }

    @Override
    public Connection createConnection(String host, int port) {
        ConnectionImpl conn;
        try {
            conn = new ConnectionImpl(host, port, this, this.orb);
        }
        catch (InvalidPropertyValue e) {
            throw new OpenBusInternalException("BUG: Este erro nunca deveria ocorrer.", e);
        }
        return conn;
    }

    @Override
    public Connection createConnection(String host, int port, Properties props) throws InvalidPropertyValue {
        return new ConnectionImpl(host, port, this, this.orb, props);
    }

    int getCurrentConnectionSlotId() {
        return this.CURRENT_CONNECTION_SLOT_ID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Connection setDefaultConnection(Connection conn) {
        Connection old;
        this.writeLock.lock();
        try {
            old = this.defaultConn;
            this.defaultConn = conn;
        }
        finally {
            this.writeLock.unlock();
        }
        return old;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Connection getDefaultConnection() {
        this.readLock.lock();
        try {
            Connection connection = this.defaultConn;
            return connection;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public Connection setCurrentConnection(Connection conn) {
        long id = Thread.currentThread().getId();
        Any any = this.orb.create_any();
        if (conn != null) {
            any.insert_longlong(id);
        }
        Current current = ORBUtils.getPICurrent(this.orb);
        try {
            current.set_slot(this.CURRENT_CONNECTION_SLOT_ID, any);
        }
        catch (InvalidSlot e) {
            String message = "Falha inesperada ao acessar o slot da thread corrente";
            logger.log(Level.SEVERE, message, e);
            throw new OpenBusInternalException(message, e);
        }
        return this.setConnectionByThreadId(id, conn);
    }

    @Override
    public Connection getCurrentConnection() {
        Any any;
        Connection connection = null;
        Current current = ORBUtils.getPICurrent(this.orb);
        try {
            any = current.get_slot(this.CURRENT_CONNECTION_SLOT_ID);
        }
        catch (InvalidSlot e) {
            String message = "Falha inesperada ao acessar o slot da thread corrente";
            logger.log(Level.SEVERE, message, e);
            throw new INTERNAL(message);
        }
        if (any.type().kind().value() != 0) {
            long id = any.extract_longlong();
            connection = this.connectedThreads.get(id);
        }
        if (connection == null) {
            connection = this.getDefaultConnection();
        }
        return connection;
    }

    @Override
    public CallerChain getCallerChain() {
        CallChain callChain;
        SignedCallChain signedChain;
        String busId;
        Current current = ORBUtils.getPICurrent(this.orb);
        ORBMediator mediator = ORBUtils.getMediator(this.orb);
        try {
            Any any = current.get_slot(mediator.getBusSlotId());
            if (any.type().kind().value() == 0) {
                return null;
            }
            busId = any.extract_string();
            any = current.get_slot(mediator.getSignedChainSlotId());
            if (any.type().kind().value() == 0) {
                return null;
            }
            signedChain = SignedCallChainHelper.extract(any);
            Any anyChain = mediator.getCodec().decode_value(signedChain.encoded, CallChainHelper.type());
            callChain = CallChainHelper.extract(anyChain);
        }
        catch (InvalidSlot e) {
            String message = "Falha inesperada ao obter o slot no PICurrent";
            logger.log(Level.SEVERE, message, e);
            throw new OpenBusInternalException(message, e);
        }
        catch (UserException e) {
            String message = "Falha inesperada ao recuperar a cadeia.";
            logger.log(Level.SEVERE, message, e);
            throw new OpenBusInternalException(message, e);
        }
        return new CallerChainImpl(busId, callChain.target, callChain.caller, callChain.originators, signedChain);
    }

    @Override
    public void joinChain() throws OpenBusInternalException {
        this.joinChain(null);
    }

    @Override
    public void joinChain(CallerChain chain) {
        CallerChain callerChain = chain = chain != null ? chain : this.getCallerChain();
        if (chain == null) {
            return;
        }
        try {
            Current current = ORBUtils.getPICurrent(this.orb);
            ORBMediator mediator = ORBUtils.getMediator(this.orb);
            SignedCallChain signedChain = ((CallerChainImpl)chain).signedCallChain();
            Any any = this.orb.create_any();
            SignedCallChainHelper.insert(any, signedChain);
            current.set_slot(mediator.getJoinedChainSlotId(), any);
            Any busAny = this.orb.create_any();
            busAny.insert_string(chain.busid());
            current.set_slot(mediator.getJoinedBusSlotId(), busAny);
            Any targetAny = this.orb.create_any();
            targetAny.insert_string(chain.target());
            current.set_slot(mediator.getJoinedChainTargetSlotId(), targetAny);
        }
        catch (InvalidSlot e) {
            String message = "Falha inesperada ao obter o slot no PICurrent";
            logger.log(Level.SEVERE, message, e);
            throw new OpenBusInternalException(message, e);
        }
    }

    @Override
    public void exitChain() {
        try {
            Current current = ORBUtils.getPICurrent(this.orb);
            ORBMediator mediator = ORBUtils.getMediator(this.orb);
            Any any = this.orb.create_any();
            current.set_slot(mediator.getJoinedChainSlotId(), any);
            current.set_slot(mediator.getJoinedChainTargetSlotId(), any);
            current.set_slot(mediator.getJoinedBusSlotId(), any);
        }
        catch (InvalidSlot e) {
            String message = "Falha inesperada ao obter o slot no PICurrent";
            logger.log(Level.SEVERE, message, e);
            throw new OpenBusInternalException(message, e);
        }
    }

    @Override
    public CallerChain getJoinedChain() {
        try {
            Current current = ORBUtils.getPICurrent(this.orb);
            ORBMediator mediator = ORBUtils.getMediator(this.orb);
            Any any = current.get_slot(mediator.getJoinedBusSlotId());
            if (any.type().kind().value() == 0) {
                return null;
            }
            String busId = any.extract_string();
            any = current.get_slot(mediator.getJoinedChainSlotId());
            if (any.type().kind().value() == 0) {
                return null;
            }
            SignedCallChain signedChain = SignedCallChainHelper.extract(any);
            Any anyChain = mediator.getCodec().decode_value(signedChain.encoded, CallChainHelper.type());
            CallChain callChain = CallChainHelper.extract(anyChain);
            any = current.get_slot(mediator.getJoinedChainTargetSlotId());
            if (any.type().kind().value() == 0) {
                return null;
            }
            String target = any.extract_string();
            return new CallerChainImpl(busId, target, callChain.caller, callChain.originators, signedChain);
        }
        catch (InvalidSlot e) {
            String message = "Falha inesperada ao obter o slot no PICurrent";
            logger.log(Level.SEVERE, message, e);
            throw new OpenBusInternalException(message, e);
        }
        catch (UserException e) {
            String message = "Falha inesperada ao recuperar a cadeia.";
            logger.log(Level.SEVERE, message, e);
            throw new OpenBusInternalException(message, e);
        }
    }

    Connection getConnectionByThreadId(long threadId) {
        return this.connectedThreads.get(threadId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Connection setConnectionByThreadId(long threadId, Connection conn) {
        Map<Long, Connection> map = this.connectedThreads;
        synchronized (map) {
            Connection old = this.connectedThreads.remove(threadId);
            if (conn != null) {
                this.connectedThreads.put(threadId, conn);
            }
            return old;
        }
    }

    void setORB(ORB orb) {
        this.orb = orb;
    }

    void ignoreCurrentThread() {
        Any any = this.orb.create_any();
        any.insert_boolean(true);
        Current current = ORBUtils.getPICurrent(this.orb);
        try {
            current.set_slot(this.IGNORE_THREAD_SLOT_ID, any);
        }
        catch (InvalidSlot e) {
            String message = "Falha inesperada ao acessar o slot de intercepta\u00e7\u00e3o ignorada";
            logger.log(Level.SEVERE, message, e);
            throw new OpenBusInternalException(message, e);
        }
    }

    void unignoreCurrentThread() {
        Any any = this.orb.create_any();
        Current current = ORBUtils.getPICurrent(this.orb);
        try {
            current.set_slot(this.IGNORE_THREAD_SLOT_ID, any);
        }
        catch (InvalidSlot e) {
            String message = "Falha inesperada ao acessar o slot de intercepta\u00e7\u00e3o ignorada";
            logger.log(Level.SEVERE, message, e);
            throw new OpenBusInternalException(message, e);
        }
    }

    boolean isCurrentThreadIgnored(RequestInfo ri) {
        Any any;
        try {
            any = ri.get_slot(this.IGNORE_THREAD_SLOT_ID);
        }
        catch (InvalidSlot e) {
            String message = "Falha inesperada ao obter o slot de intercepta\u00e7\u00e3o ignorada";
            throw new INTERNAL(message);
        }
        if (any.type().kind().value() != 0) {
            boolean isIgnored = any.extract_boolean();
            return isIgnored;
        }
        return false;
    }

    @Override
    public void onCallDispatch(CallDispatchCallback callback) {
        this.dispatchCallback = callback;
    }

    @Override
    public CallDispatchCallback onCallDispatch() {
        return this.dispatchCallback;
    }

    @Override
    public LoginRegistry getLoginRegistry() {
        ConnectionImpl conn = (ConnectionImpl)this.getCurrentConnection();
        if (conn == null || conn.login() == null) {
            throw new NO_PERMISSION(1112888319, CompletionStatus.COMPLETED_NO);
        }
        return conn.logins();
    }

    @Override
    public OfferRegistry getOfferRegistry() {
        ConnectionImpl conn = (ConnectionImpl)this.getCurrentConnection();
        if (conn == null || conn.login() == null) {
            throw new NO_PERMISSION(1112888319, CompletionStatus.COMPLETED_NO);
        }
        return conn.offers();
    }
}

