/*
 * Decompiled with CFR 0.152.
 */
package demo;

import demo.MessengerHelper;
import demo.ProxyMessengerImpl;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.NO_PERMISSION;
import org.omg.CORBA.ORB;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;
import org.omg.CORBA.TRANSIENT;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAHelper;
import org.omg.PortableServer.POAManagerPackage.AdapterInactive;
import org.omg.PortableServer.Servant;
import scs.core.ComponentContext;
import scs.core.ComponentId;
import scs.core.exception.SCSException;
import tecgraf.openbus.OpenBusContext;
import tecgraf.openbus.PrivateKey;
import tecgraf.openbus.assistant.Assistant;
import tecgraf.openbus.core.OpenBusPrivateKey;
import tecgraf.openbus.core.v2_0.services.ServiceFailure;
import tecgraf.openbus.core.v2_0.services.offer_registry.ServiceOfferDesc;
import tecgraf.openbus.core.v2_0.services.offer_registry.ServiceProperty;
import tecgraf.openbus.exception.AlreadyLoggedIn;

public class CallChainProxy {
    private static String host;
    private static int port;
    private static String entity;
    private static OpenBusPrivateKey privateKey;

    public static void main(String[] args) throws InvalidName, AdapterInactive, SCSException, AlreadyLoggedIn {
        ServiceOfferDesc[] offers;
        if (args.length < 4) {
            String params = "[interval]";
            String desc = "\n  - [interval] = Tempo de espera entre tentativas de acesso ao barramento. Valor padr\u00e3o \u00e9 '1'";
            System.out.println(String.format("Usage: 'demo' <host> <port> <entity> <privatekeypath> %s\n  - host = \u00e9 o host do barramento\n  - port = \u00e9 a porta do barramento\n  - entity = \u00e9 a entidade a ser autenticada\n  - privatekeypath = \u00e9 o caminho da chave privada de autentica\u00e7\u00e3o da entidade %s", params, desc));
            System.exit(1);
            return;
        }
        host = args[0];
        try {
            port = Integer.parseInt(args[1]);
        }
        catch (NumberFormatException e) {
            System.out.println("Valor de <port> deve ser um n\u00famero");
            System.exit(1);
            return;
        }
        entity = args[2];
        String privateKeyFile = args[3];
        try {
            privateKey = OpenBusPrivateKey.createPrivateKeyFromFile((String)privateKeyFile);
        }
        catch (Exception e) {
            System.out.println("<privatekeypath> deve apontar para uma chave v\u00e1lida.");
            e.printStackTrace();
            System.exit(1);
            return;
        }
        final Assistant assist = Assistant.createWithPrivateKey((String)host, (int)port, (String)entity, (PrivateKey)privateKey);
        final ORB orb = assist.orb();
        Thread run = new Thread(){

            @Override
            public void run() {
                orb.run();
            }
        };
        run.start();
        Thread shutdown = new Thread(){

            @Override
            public void run() {
                assist.shutdown();
                orb.shutdown(true);
                orb.destroy();
            }
        };
        Runtime.getRuntime().addShutdownHook(shutdown);
        OpenBusContext context = (OpenBusContext)orb.resolve_initial_references("OpenBusContext");
        POA poa = POAHelper.narrow((Object)orb.resolve_initial_references("RootPOA"));
        poa.the_POAManager().activate();
        ComponentId id = new ComponentId("Messenger", 1, 0, 0, "java");
        ComponentContext component = new ComponentContext(orb, poa, id);
        ProxyMessengerImpl proxy = new ProxyMessengerImpl(context, entity);
        component.addFacet("Messenger", MessengerHelper.id(), (Servant)proxy);
        ServiceProperty[] findProperties = new ServiceProperty[]{new ServiceProperty("offer.role", "actual messenger"), new ServiceProperty("offer.domain", "Demo Call Chain"), new ServiceProperty("openbus.component.interface", MessengerHelper.id())};
        try {
            offers = assist.findServices(findProperties, -1);
        }
        catch (ServiceFailure e) {
            System.err.println(String.format("falha severa no barramento em %s:%s : %s", host, port, e.message));
            System.exit(1);
            return;
        }
        catch (TRANSIENT e) {
            System.err.println(String.format("o barramento em %s:%s esta inacess\u00edvel no momento", host, port));
            System.exit(1);
            return;
        }
        catch (COMM_FAILURE e) {
            System.err.println("falha de comunica\u00e7\u00e3o ao acessar servi\u00e7os n\u00facleo do barramento");
            System.exit(1);
            return;
        }
        catch (NO_PERMISSION e) {
            if (e.minor == 1112888319) {
                System.err.println(String.format("n\u00e3o h\u00e1 um login de '%s' v\u00e1lido no momento", entity));
            }
            System.exit(1);
            return;
        }
        catch (Throwable e) {
            System.err.println("Erro inesperado durante busca de servi\u00e7os.");
            e.printStackTrace();
            System.exit(1);
            return;
        }
        proxy.setOffers(offers);
        ServiceProperty[] serviceProperties = new ServiceProperty[]{new ServiceProperty("offer.role", "proxy messenger"), new ServiceProperty("offer.domain", "Demo Call Chain")};
        assist.registerService(component.getIComponent(), serviceProperties);
    }
}

