/*
 * Decompiled with CFR 0.152.
 */
package demo;

import demo.MessengerHelper;
import demo.MessengerImpl;
import org.omg.CORBA.ORB;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAHelper;
import org.omg.PortableServer.POAManagerPackage.AdapterInactive;
import org.omg.PortableServer.Servant;
import scs.core.ComponentContext;
import scs.core.ComponentId;
import scs.core.exception.SCSException;
import tecgraf.openbus.OpenBusContext;
import tecgraf.openbus.PrivateKey;
import tecgraf.openbus.assistant.Assistant;
import tecgraf.openbus.core.OpenBusPrivateKey;
import tecgraf.openbus.core.v2_0.services.offer_registry.ServiceProperty;
import tecgraf.openbus.exception.AlreadyLoggedIn;

public class CallChainServer {
    private static String host;
    private static int port;
    private static String entity;
    private static OpenBusPrivateKey privateKey;

    public static void main(String[] args) throws InvalidName, AdapterInactive, SCSException, AlreadyLoggedIn {
        if (args.length < 4) {
            String params = "[interval]";
            String desc = "\n  - [interval] = Tempo de espera entre tentativas de acesso ao barramento. Valor padr\u00e3o \u00e9 '1'";
            System.out.println(String.format("Usage: 'demo' <host> <port> <entity> <privatekeypath> %s\n  - host = \u00e9 o host do barramento\n  - port = \u00e9 a porta do barramento\n  - entity = \u00e9 a entidade a ser autenticada\n  - privatekeypath = \u00e9 o caminho da chave privada de autentica\u00e7\u00e3o da entidade %s", params, desc));
            System.exit(1);
            return;
        }
        host = args[0];
        try {
            port = Integer.parseInt(args[1]);
        }
        catch (NumberFormatException e) {
            System.out.println("Valor de <port> deve ser um n\u00famero");
            System.exit(1);
            return;
        }
        entity = args[2];
        String privateKeyFile = args[3];
        try {
            privateKey = OpenBusPrivateKey.createPrivateKeyFromFile((String)privateKeyFile);
        }
        catch (Exception e) {
            System.out.println("<privatekeypath> deve apontar para uma chave v\u00e1lida.");
            e.printStackTrace();
            System.exit(1);
            return;
        }
        final Assistant assist = Assistant.createWithPrivateKey((String)host, (int)port, (String)entity, (PrivateKey)privateKey);
        final ORB orb = assist.orb();
        Thread run = new Thread(){

            @Override
            public void run() {
                orb.run();
            }
        };
        run.start();
        Thread shutdown = new Thread(){

            @Override
            public void run() {
                assist.shutdown();
                orb.shutdown(true);
                orb.destroy();
            }
        };
        Runtime.getRuntime().addShutdownHook(shutdown);
        OpenBusContext context = (OpenBusContext)orb.resolve_initial_references("OpenBusContext");
        POA poa = POAHelper.narrow((Object)orb.resolve_initial_references("RootPOA"));
        poa.the_POAManager().activate();
        ComponentId id = new ComponentId("Messenger", 1, 0, 0, "java");
        ComponentContext component = new ComponentContext(orb, poa, id);
        component.addFacet("Messenger", MessengerHelper.id(), (Servant)new MessengerImpl(context, entity));
        ServiceProperty[] serviceProperties = new ServiceProperty[]{new ServiceProperty("offer.role", "actual messenger"), new ServiceProperty("offer.domain", "Demo Call Chain")};
        assist.registerService(component.getIComponent(), serviceProperties);
    }
}

