package demo;

import tecgraf.openbus.OpenBusContext;

/**
 * Implementao do componente Greetings
 * 
 * @author Tecgraf
 */
public class GreetingsImpl extends GreetingsPOA {

  /**
   * Lnguas em que se realiza o cumprimento.
   * 
   * @author Tecgraf
   */
  static public enum Language {
    /** Ingls */
    English,
    /** Espanhol */
    Spanish,
    /** Portugus */
    Portuguese;
  };

  /**
   * Perodos em que se realiza o cumprimento.
   * 
   * @author Tecgraf
   */
  static public enum Period {
    /** Manh */
    Morning,
    /** Tarde */
    Afternoon,
    /** Noite */
    Night;
  };

  /** Contexto com o barramento. */
  private OpenBusContext context;
  /** O perodo */
  private Period period;
  /** A lngua */
  private Language language;

  /**
   * Construtor.
   * 
   * @param context Conexo com o barramento.
   * @param language A lngua utilizada.
   * @param period O perodo.
   */
  public GreetingsImpl(OpenBusContext context, Language language, Period period) {
    this.context = context;
    this.language = language;
    this.period = period;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String sayGreetings() {
    String caller = context.getCallerChain().caller().entity;
    switch (language) {
      case English:
        return englishGreetings(caller);
      case Spanish:
        return spanishGreetings(caller);
      case Portuguese:
        return portugueseGreetings(caller);
    }
    return "BUG: lingua no especificada";
  }

  /**
   * Cumprimentaes em ingls.
   * 
   * @param caller requisitante da chamada.
   * @return o cumprimento.
   */
  private String englishGreetings(String caller) {
    switch (this.period) {
      case Morning:
        return String.format("Good morning %s", caller);
      case Afternoon:
        return String.format("Good afternoon %s", caller);
      case Night:
        return String.format("Good night %s", caller);
    }
    return "BUG: periodo no especificado";
  }

  /**
   * Cumprimentaes em espanhol.
   * 
   * @param caller requisitante da chamada.
   * @return o cumprimento.
   */
  private String spanishGreetings(String caller) {
    switch (this.period) {
      case Morning:
        return String.format("Buenos das %s", caller);
      case Afternoon:
        return String.format("Buenas tardes %s", caller);
      case Night:
        return String.format("Buenas noches %s", caller);
    }
    return "BUG: periodo no especificado";
  }

  /**
   * Cumprimentaes em portugus.
   * 
   * @param caller requisitante da chamada.
   * @return o cumprimento.
   */
  private String portugueseGreetings(String caller) {
    switch (this.period) {
      case Morning:
        return String.format("Bom dia %s", caller);
      case Afternoon:
        return String.format("Boa tarde %s", caller);
      case Night:
        return String.format("Boa noite %s", caller);
    }
    return "BUG: periodo no especificado";
  }
}
