/*
 * Decompiled with CFR 0.152.
 */
package demo;

import demo.CallbackPOA;
import demo.Timer;
import demo.TimerHelper;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.NO_PERMISSION;
import org.omg.CORBA.ORB;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;
import org.omg.CORBA.TRANSIENT;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAHelper;
import org.omg.PortableServer.POAManagerPackage.AdapterInactive;
import org.omg.PortableServer.POAPackage.ServantNotActive;
import org.omg.PortableServer.POAPackage.WrongPolicy;
import org.omg.PortableServer.Servant;
import tecgraf.openbus.CallerChain;
import tecgraf.openbus.Connection;
import tecgraf.openbus.OpenBusContext;
import tecgraf.openbus.core.ORBInitializer;
import tecgraf.openbus.core.v2_0.services.ServiceFailure;
import tecgraf.openbus.core.v2_0.services.access_control.AccessDenied;
import tecgraf.openbus.core.v2_0.services.offer_registry.ServiceOfferDesc;
import tecgraf.openbus.core.v2_0.services.offer_registry.ServiceProperty;
import tecgraf.openbus.demo.util.Utils;
import tecgraf.openbus.exception.AlreadyLoggedIn;

public final class MultiplexingClient {
    private static String host;
    private static int port;
    private static String entity;
    private static String password;
    private static AtomicInteger pending;

    public static void main(String[] args) throws AlreadyLoggedIn, InvalidName, ServiceFailure, AdapterInactive {
        ServiceOfferDesc[] services;
        if (args.length < 3) {
            System.out.println(String.format("Usage: 'demo' <host> <port> <entity> [password] %s\n  - host = \u00e9 o host do barramento\n  - port = \u00e9 a porta do barramento\n  - entity = \u00e9 a entidade a ser autenticada\n  - password = senha (opcional) %s", "", ""));
            System.exit(1);
            return;
        }
        host = args[0];
        try {
            port = Integer.parseInt(args[1]);
        }
        catch (NumberFormatException e) {
            System.out.println("Valor de <port> deve ser um n\u00famero");
            System.exit(1);
            return;
        }
        password = entity = args[2];
        if (args.length > 3) {
            password = args[3];
        }
        Utils.setLogLevel((Level)Level.FINEST);
        final ORB orb = ORBInitializer.initORB();
        Thread run = new Thread(){

            @Override
            public void run() {
                orb.run();
            }
        };
        run.start();
        Thread shutdown = new Thread(){

            @Override
            public void run() {
                orb.shutdown(true);
                orb.destroy();
            }
        };
        Runtime.getRuntime().addShutdownHook(shutdown);
        final POA poa = POAHelper.narrow((Object)orb.resolve_initial_references("RootPOA"));
        poa.the_POAManager().activate();
        final OpenBusContext context = (OpenBusContext)orb.resolve_initial_references("OpenBusContext");
        try {
            context.setDefaultConnection(MultiplexingClient.newLogin(context));
            ServiceProperty[] properties = new ServiceProperty[]{new ServiceProperty("offer.domain", "Demo Multiplexing"), new ServiceProperty("openbus.component.interface", TimerHelper.id())};
            services = context.getOfferRegistry().findServices(properties);
        }
        catch (AccessDenied e) {
            System.err.println(String.format("a senha fornecida para a entidade '%s' foi negada", entity));
            System.exit(1);
            return;
        }
        catch (ServiceFailure e) {
            System.err.println(String.format("falha severa no barramento em %s:%s : %s", host, port, e.message));
            System.exit(1);
            return;
        }
        catch (TRANSIENT e) {
            System.err.println(String.format("o barramento em %s:%s esta inacess\u00edvel no momento", host, port));
            System.exit(1);
            return;
        }
        catch (COMM_FAILURE e) {
            System.err.println("falha de comunica\u00e7\u00e3o ao acessar servi\u00e7os n\u00facleo do barramento");
            System.exit(1);
            return;
        }
        catch (NO_PERMISSION e) {
            if (e.minor == 1112888319) {
                System.err.println(String.format("n\u00e3o h\u00e1 um login de '%s' v\u00e1lido no momento", entity));
            }
            System.exit(1);
            return;
        }
        for (int i = 0; i < services.length; ++i) {
            final int index = i;
            final ServiceOfferDesc offerDesc = services[i];
            new Thread(){

                @Override
                public void run() {
                    block27: {
                        Connection conn = null;
                        try {
                            conn = MultiplexingClient.newLogin(context);
                        }
                        catch (AccessDenied e) {
                            System.err.println(String.format("a senha fornecida para a entidade '%s' foi negada", entity));
                            return;
                        }
                        catch (AlreadyLoggedIn e) {
                            System.err.println("tentativa de autenticar uma conex\u00e3o j\u00e1 autenticada");
                            return;
                        }
                        catch (ServiceFailure e) {
                            System.err.println(String.format("falha severa no barramento em %s:%s : %s", host, port, e.message));
                            return;
                        }
                        catch (TRANSIENT e) {
                            System.err.println(String.format("o barramento em %s:%s esta inacess\u00edvel no momento", host, port));
                            return;
                        }
                        catch (COMM_FAILURE e) {
                            System.err.println("falha de comunica\u00e7\u00e3o ao acessar servi\u00e7os n\u00facleo do barramento");
                            return;
                        }
                        catch (NO_PERMISSION e) {
                            if (e.minor == 1112888319) {
                                System.err.println(String.format("n\u00e3o h\u00e1 um login de '%s' v\u00e1lido no momento", entity));
                            }
                            return;
                        }
                        boolean failed = true;
                        try {
                            context.setCurrentConnection(conn);
                            Object timerObj = offerDesc.service_ref.getFacet(TimerHelper.id());
                            if (timerObj == null) {
                                System.out.println("o servi\u00e7o encontrado n\u00e3o prov\u00ea a faceta ofertada");
                                return;
                            }
                            CallbackImpl cb = new CallbackImpl(context, conn.login().id, offerDesc);
                            poa.servant_to_reference((Servant)cb);
                            Timer timer = TimerHelper.narrow(timerObj);
                            timer.newTrigger(index, cb._this());
                            failed = false;
                        }
                        catch (TRANSIENT e) {
                            System.err.println("o servi\u00e7o encontrado encontra-se indispon\u00edvel");
                        }
                        catch (COMM_FAILURE e) {
                            System.err.println("falha de comunica\u00e7\u00e3o com o servi\u00e7o encontrado");
                        }
                        catch (NO_PERMISSION e) {
                            switch (e.minor) {
                                case 1112888319: {
                                    System.err.println(String.format("n\u00e3o h\u00e1 um login de '%s' v\u00e1lido no momento", entity));
                                    break;
                                }
                                case 1112888068: {
                                    System.err.println("o servi\u00e7o encontrado n\u00e3o est\u00e1 mais logado ao barramento");
                                    break;
                                }
                                case 1112888067: {
                                    System.err.println("o servi\u00e7o encontrado n\u00e3o foi capaz de validar a chamada");
                                    break;
                                }
                                case 1112888318: {
                                    System.err.println("integra\u00e7\u00e3o do servi\u00e7o encontrado com o barramento est\u00e1 incorreta");
                                }
                            }
                        }
                        catch (ServantNotActive e) {
                            System.err.println("erro ao ativar o servant");
                        }
                        catch (WrongPolicy e) {
                            System.err.println("erro ao ativar o servant");
                        }
                        if (!failed) {
                            int pend = pending.incrementAndGet();
                            System.out.println("Incrementing pending = " + pend);
                        }
                        try {
                            conn.logout();
                        }
                        catch (ServiceFailure e) {
                            System.err.println(String.format("falha severa no barramento em %s:%s : %s", host, port, e.message));
                        }
                        catch (TRANSIENT e) {
                            System.err.println(String.format("o barramento em %s:%s esta inacess\u00edvel no momento", host, port));
                        }
                        catch (COMM_FAILURE e) {
                            System.err.println("falha de comunica\u00e7\u00e3o ao acessar servi\u00e7os n\u00facleo do barramento");
                        }
                        catch (NO_PERMISSION e) {
                            if (e.minor != 1112888319) break block27;
                            System.err.println(String.format("n\u00e3o h\u00e1 um login de '%s' v\u00e1lido no momento", entity));
                        }
                    }
                }
            }.start();
        }
    }

    private static Connection newLogin(OpenBusContext context) throws AccessDenied, AlreadyLoggedIn, ServiceFailure {
        Connection connection = context.createConnection(host, port);
        connection.loginByPassword(entity, password.getBytes());
        return connection;
    }

    static {
        pending = new AtomicInteger(0);
    }

    public static class CallbackImpl
    extends CallbackPOA {
        private ServiceOfferDesc offerDesc;
        private String loginId;
        private OpenBusContext context;

        public CallbackImpl(OpenBusContext context, String loginId, ServiceOfferDesc offerDesc) {
            this.context = context;
            this.loginId = loginId;
            this.offerDesc = offerDesc;
        }

        @Override
        public void notifyTrigger() {
            CallerChain chain = this.context.getCallerChain();
            String timerId = Utils.getProperty((ServiceOfferDesc)this.offerDesc, (String)"openbus.offer.login");
            if (chain.caller().id.equals(timerId)) {
                System.out.println("notifica\u00e7\u00e3o do timer esperado recebida!");
                if (chain.originators().length > 1 || !chain.originators()[0].id.equals(this.loginId)) {
                    System.out.println("  notifica\u00e7\u00e3o feita fora da chamada original!");
                }
            } else {
                System.out.println("notifica\u00e7\u00e3o inesperada recebida:");
                System.out.println(String.format("  recebida de: %s", chain.caller().id));
                System.out.println(String.format("  esperada de: %s", timerId));
            }
            int pend = pending.decrementAndGet();
            System.out.println("decrementing pending = " + pend);
            if (pend == 0) {
                try {
                    this.context.getDefaultConnection().logout();
                }
                catch (ServiceFailure e) {
                    System.err.println(String.format("falha severa no barramento em %s:%s : %s", host, port, e.message));
                }
                catch (TRANSIENT e) {
                    System.err.println(String.format("o barramento em %s:%s esta inacess\u00edvel no momento", host, port));
                }
                catch (COMM_FAILURE e) {
                    System.err.println("falha de comunica\u00e7\u00e3o ao acessar servi\u00e7os n\u00facleo do barramento");
                }
                catch (NO_PERMISSION e) {
                    if (e.minor == 1112888319) {
                        System.err.println(String.format("n\u00e3o h\u00e1 um login de '%s' v\u00e1lido no momento", entity));
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

