/*
 * Decompiled with CFR 0.152.
 */
package demo;

import demo.TimerHelper;
import demo.TimerImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.logging.Level;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.NO_PERMISSION;
import org.omg.CORBA.ORB;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;
import org.omg.CORBA.TRANSIENT;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAHelper;
import org.omg.PortableServer.POAManagerPackage.AdapterInactive;
import org.omg.PortableServer.POAPackage.ServantNotActive;
import org.omg.PortableServer.POAPackage.WrongPolicy;
import org.omg.PortableServer.Servant;
import scs.core.ComponentContext;
import scs.core.ComponentId;
import scs.core.exception.SCSException;
import tecgraf.openbus.CallDispatchCallback;
import tecgraf.openbus.Connection;
import tecgraf.openbus.OpenBusContext;
import tecgraf.openbus.PrivateKey;
import tecgraf.openbus.core.ORBInitializer;
import tecgraf.openbus.core.OpenBusPrivateKey;
import tecgraf.openbus.core.v2_0.services.ServiceFailure;
import tecgraf.openbus.core.v2_0.services.access_control.AccessDenied;
import tecgraf.openbus.core.v2_0.services.access_control.MissingCertificate;
import tecgraf.openbus.core.v2_0.services.offer_registry.InvalidProperties;
import tecgraf.openbus.core.v2_0.services.offer_registry.InvalidService;
import tecgraf.openbus.core.v2_0.services.offer_registry.ServiceProperty;
import tecgraf.openbus.core.v2_0.services.offer_registry.UnauthorizedFacets;
import tecgraf.openbus.demo.util.Utils;
import tecgraf.openbus.exception.AlreadyLoggedIn;

public final class MultiplexingServer {
    private static String host;
    private static int port;
    private static String entity;
    private static OpenBusPrivateKey privateKey;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws InvalidName, AdapterInactive, SCSException, AlreadyLoggedIn, ServiceFailure, ServantNotActive, WrongPolicy {
        if (args.length < 4) {
            System.out.println(String.format("Usage: 'demo' <host> <port> <entity> <privatekeypath> %s\n  - host = \u00e9 o host do barramento\n  - port = \u00e9 a porta do barramento\n  - entity = \u00e9 a entidade a ser autenticada\n  - privatekeypath = \u00e9 o caminho da chave privada de autentica\u00e7\u00e3o da entidade %s", "", ""));
            System.exit(1);
            return;
        }
        host = args[0];
        try {
            port = Integer.parseInt(args[1]);
        }
        catch (NumberFormatException e) {
            System.out.println("Valor de <port> deve ser um n\u00famero");
            System.exit(1);
            return;
        }
        entity = args[2];
        String privateKeyFile = args[3];
        try {
            privateKey = OpenBusPrivateKey.createPrivateKeyFromFile((String)privateKeyFile);
        }
        catch (Exception e) {
            System.out.println("<privatekeypath> deve apontar para uma chave v\u00e1lida.");
            e.printStackTrace();
            System.exit(1);
            return;
        }
        Utils.setLogLevel((Level)Level.FINEST);
        final ORB orb = ORBInitializer.initORB();
        Thread run = new Thread(){

            @Override
            public void run() {
                orb.run();
            }
        };
        run.start();
        Thread shutdown = new Thread(){

            @Override
            public void run() {
                orb.shutdown(true);
                orb.destroy();
            }
        };
        Runtime.getRuntime().addShutdownHook(shutdown);
        OpenBusContext context = (OpenBusContext)orb.resolve_initial_references("OpenBusContext");
        final HashMap<String, Connection> map = new HashMap<String, Connection>();
        context.onCallDispatch(new CallDispatchCallback(){

            public Connection dispatch(OpenBusContext arg0, String busid, String loginId, byte[] object_id, String operation) {
                System.out.println("dispatch para id: " + Arrays.toString(object_id));
                Connection conn = (Connection)map.get(Arrays.toString(object_id));
                if (conn != null) {
                    System.out.println("achou conn " + conn.login().id);
                    return conn;
                }
                if (!map.isEmpty()) {
                    ArrayList list = new ArrayList(map.values());
                    conn = (Connection)list.get(0);
                    System.out.println("aleatorio conn " + conn.login().id);
                    return conn;
                }
                return null;
            }
        });
        POA poa = POAHelper.narrow((Object)orb.resolve_initial_references("RootPOA"));
        poa.the_POAManager().activate();
        for (int i = 0; i < 3; ++i) {
            ComponentId id = new ComponentId("Timer", 1, 0, 0, "java");
            ComponentContext component = new ComponentContext(orb, poa, id);
            TimerImpl timer = new TimerImpl(context);
            component.addFacet("Timer", TimerHelper.id(), (Servant)timer);
            Connection conn = context.createConnection(host, port);
            context.setCurrentConnection(conn);
            map.put(Arrays.toString(poa.servant_to_id((Servant)timer)), conn);
            System.out.println(String.format("Mapa timer %s with id %s", timer.hashCode(), Arrays.toString(poa.servant_to_id((Servant)timer))));
            boolean failed = true;
            try {
                conn.loginByCertificate(entity, (PrivateKey)privateKey);
                ServiceProperty[] serviceProperties = new ServiceProperty[]{new ServiceProperty("offer.domain", "Demo Multiplexing")};
                context.getOfferRegistry().registerService(component.getIComponent(), serviceProperties);
                System.out.println(String.format("Registering timer %s with login %s", timer.hashCode(), conn.login().id));
                failed = false;
                continue;
            }
            catch (AccessDenied e) {
                System.err.println(String.format("a chave em '%s' n\u00e3o corresponde ao certificado da entidade '%s'", privateKeyFile, entity));
                continue;
            }
            catch (MissingCertificate e) {
                System.err.println(String.format("a entidade %s n\u00e3o possui um certificado registrado", entity));
                continue;
            }
            catch (UnauthorizedFacets e) {
                StringBuffer interfaces = new StringBuffer();
                for (String string : e.facets) {
                    interfaces.append("\n  - ");
                    interfaces.append(string);
                }
                System.err.println(String.format("a entidade '%s' n\u00e3o foi autorizada pelo administrador do barramento a ofertar os servi\u00e7os: %s", entity, interfaces.toString()));
                continue;
            }
            catch (InvalidService e) {
                System.err.println("o servi\u00e7o ofertado apresentou alguma falha durante o registro.");
                continue;
            }
            catch (InvalidProperties e) {
                StringBuffer props = new StringBuffer();
                for (String string : e.properties) {
                    props.append("\n  - ");
                    props.append(String.format("name = %s, value = %s", ((ServiceProperty)string).name, ((ServiceProperty)string).value));
                }
                System.err.println(String.format("tentativa de registrar servi\u00e7o com propriedades inv\u00e1lidas: %s", props.toString()));
                continue;
            }
            catch (ServiceFailure e) {
                System.err.println(String.format("falha severa no barramento em %s:%s : %s", host, port, e.message));
                continue;
            }
            catch (TRANSIENT e) {
                System.err.println(String.format("o barramento em %s:%s esta inacess\u00edvel no momento", host, port));
                continue;
            }
            catch (COMM_FAILURE e) {
                System.err.println("falha de comunica\u00e7\u00e3o ao acessar servi\u00e7os n\u00facleo do barramento");
                continue;
            }
            catch (NO_PERMISSION e) {
                if (e.minor != 1112888319) continue;
                System.err.println(String.format("n\u00e3o h\u00e1 um login de '%s' v\u00e1lido no momento", entity));
                continue;
            }
            finally {
                if (failed) {
                    context.getCurrentConnection().logout();
                }
            }
        }
    }
}

