/*
 * Decompiled with CFR 0.152.
 */
package demo;

import demo.Callback;
import demo.TimerPOA;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.NO_PERMISSION;
import org.omg.CORBA.TRANSIENT;
import tecgraf.openbus.CallerChain;
import tecgraf.openbus.Connection;
import tecgraf.openbus.OpenBusContext;

public class TimerImpl
extends TimerPOA {
    private OpenBusContext context;

    public TimerImpl(OpenBusContext context) {
        this.context = context;
    }

    @Override
    public void newTrigger(double timeout, final Callback cb) {
        final long time = (long)timeout;
        final CallerChain chain = this.context.getCallerChain();
        final Connection conn = this.context.getCurrentConnection();
        final String entity = conn.login().entity;
        new Thread(){

            @Override
            public void run() {
                try {
                    Thread.sleep(time * 1000L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                TimerImpl.this.context.setCurrentConnection(conn);
                TimerImpl.this.context.joinChain(chain);
                try {
                    System.out.println(String.format("timer %s notifying with login %s", this.hashCode(), conn.login().id));
                    cb.notifyTrigger();
                }
                catch (TRANSIENT e) {
                    System.err.println("o servi\u00e7o encontrado encontra-se indispon\u00edvel");
                }
                catch (COMM_FAILURE e) {
                    System.err.println("falha de comunica\u00e7\u00e3o na notifica\u00e7\u00e3o da callback");
                }
                catch (NO_PERMISSION e) {
                    switch (e.minor) {
                        case 1112888319: {
                            System.err.println(String.format("n\u00e3o h\u00e1 um login de '%s' v\u00e1lido no momento", entity));
                            break;
                        }
                        case 1112888068: {
                            System.err.println("o servi\u00e7o encontrado n\u00e3o est\u00e1 mais logado ao barramento");
                            break;
                        }
                        case 1112888067: {
                            System.err.println("o servi\u00e7o encontrado n\u00e3o foi capaz de validar a chamada");
                            break;
                        }
                        case 1112888318: {
                            System.err.println("integra\u00e7\u00e3o do servi\u00e7o encontrado com o barramento est\u00e1 incorreta");
                        }
                    }
                }
            }
        }.start();
    }
}

