/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.openbus.interop.delegation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import tecgraf.openbus.OpenBusContext;
import tecgraf.openbus.core.v2_0.services.access_control.LoginInfo;
import tecgraf.openbus.interop.delegation.BroadcasterPOA;
import tecgraf.openbus.interop.delegation.Messenger;
import tecgraf.openbus.interop.util.Utils;

public class BroadcasterImpl
extends BroadcasterPOA {
    private OpenBusContext context;
    private List<String> subscribers;
    private Messenger messenger;

    public BroadcasterImpl(OpenBusContext context, Messenger messenger) {
        this.context = context;
        this.subscribers = Collections.synchronizedList(new ArrayList());
        this.messenger = messenger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void post(String message) {
        this.context.joinChain();
        List<String> list = this.subscribers;
        synchronized (list) {
            for (String user : this.subscribers) {
                this.messenger.post(user, message);
            }
        }
    }

    @Override
    public void subscribe() {
        LoginInfo caller = this.context.getCallerChain().caller();
        LoginInfo[] originators = this.context.getCallerChain().originators();
        String user = caller.entity;
        System.out.println("inscri\u00e7\u00e3o de " + Utils.chain2str((LoginInfo[])originators, (LoginInfo)caller));
        this.subscribers.add(user);
    }

    @Override
    public void unsubscribe() {
        LoginInfo caller = this.context.getCallerChain().caller();
        LoginInfo[] originators = this.context.getCallerChain().originators();
        String user = caller.entity;
        System.out.println("cancelando inscri\u00e7\u00e3o de " + Utils.chain2str((LoginInfo[])originators, (LoginInfo)caller));
        this.subscribers.remove(user);
    }
}

