/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.openbus.interop.delegation;

import java.util.Properties;
import java.util.logging.Level;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAHelper;
import org.omg.PortableServer.Servant;
import scs.core.ComponentContext;
import scs.core.ComponentId;
import scs.core.IComponent;
import tecgraf.openbus.Connection;
import tecgraf.openbus.InvalidLoginCallback;
import tecgraf.openbus.OpenBusContext;
import tecgraf.openbus.PrivateKey;
import tecgraf.openbus.core.ORBInitializer;
import tecgraf.openbus.core.OpenBusPrivateKey;
import tecgraf.openbus.core.v2_0.services.offer_registry.ServiceOfferDesc;
import tecgraf.openbus.core.v2_0.services.offer_registry.ServiceProperty;
import tecgraf.openbus.interop.delegation.ForwarderHelper;
import tecgraf.openbus.interop.delegation.ForwarderImpl;
import tecgraf.openbus.interop.delegation.ForwarderInvalidLoginCallback;
import tecgraf.openbus.interop.delegation.Messenger;
import tecgraf.openbus.interop.delegation.MessengerHelper;
import tecgraf.openbus.interop.util.Utils;

public class ForwardServer {
    public static void main(String[] args) {
        try {
            Properties props = Utils.readPropertyFile((String)"/test.properties");
            String host = props.getProperty("bus.host.name");
            int port = Integer.valueOf(props.getProperty("bus.host.port"));
            String entity = "interop_delegation_java_forwarder";
            String privateKeyFile = "admin/InteropDelegation.key";
            OpenBusPrivateKey privateKey = OpenBusPrivateKey.createPrivateKeyFromFile((String)privateKeyFile);
            Utils.setLogLevel((Level)Level.parse(props.getProperty("log.level", "OFF")));
            ORB orb = ORBInitializer.initORB((String[])args);
            new Utils.ORBRunThread(orb).start();
            Runtime.getRuntime().addShutdownHook((Thread)new Utils.ShutdownThread(orb));
            OpenBusContext context = (OpenBusContext)orb.resolve_initial_references("OpenBusContext");
            Connection conn = context.createConnection(host, port);
            context.setDefaultConnection(conn);
            conn.loginByCertificate(entity, (PrivateKey)privateKey);
            ServiceProperty[] messengerProps = new ServiceProperty[]{new ServiceProperty("openbus.component.interface", MessengerHelper.id()), new ServiceProperty("offer.domain", "Interoperability Tests")};
            ServiceOfferDesc[] services = context.getOfferRegistry().findServices(messengerProps);
            if (services.length <= 0) {
                System.err.println("n\u00e3o encontrou o servi\u00e7o messenger");
                System.exit(1);
            }
            if (services.length > 1) {
                System.out.println("Foram encontrados v\u00e1rios servi\u00e7os de messenger");
            }
            Messenger messenger = MessengerHelper.narrow(services[0].service_ref.getFacet(MessengerHelper.id()));
            ForwarderImpl forwarderServant = new ForwarderImpl(context);
            POA poa = POAHelper.narrow((Object)orb.resolve_initial_references("RootPOA"));
            poa.the_POAManager().activate();
            ComponentContext ctx = new ComponentContext(orb, poa, new ComponentId("Forwarder", 1, 0, 0, "java"));
            ctx.addFacet("forwarder", ForwarderHelper.id(), (Servant)forwarderServant);
            ForwarderImpl.Timer timer = new ForwarderImpl.Timer(context, forwarderServant, messenger);
            timer.start();
            ServiceProperty[] serviceProperties = new ServiceProperty[]{new ServiceProperty("offer.domain", "Interoperability Tests")};
            IComponent ic = ctx.getIComponent();
            context.getOfferRegistry().registerService(ic, serviceProperties);
            conn.onInvalidLoginCallback((InvalidLoginCallback)new ForwarderInvalidLoginCallback(entity, (PrivateKey)privateKey, ic, serviceProperties, timer));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

