/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.openbus.interop.delegation;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import tecgraf.openbus.CallerChain;
import tecgraf.openbus.OpenBusContext;
import tecgraf.openbus.core.v2_0.services.access_control.LoginInfo;
import tecgraf.openbus.interop.delegation.ForwarderPOA;
import tecgraf.openbus.interop.delegation.Messenger;
import tecgraf.openbus.interop.delegation.NoForward;
import tecgraf.openbus.interop.delegation.PostDesc;
import tecgraf.openbus.interop.util.Utils;

public class ForwarderImpl
extends ForwarderPOA {
    private OpenBusContext context;
    private Map<String, ForwardInfo> forwardsOf;

    public ForwarderImpl(OpenBusContext context) {
        this.context = context;
        this.forwardsOf = Collections.synchronizedMap(new HashMap());
    }

    @Override
    public void setForward(String to) {
        CallerChain chain = this.context.getCallerChain();
        LoginInfo caller = chain.caller();
        LoginInfo[] originators = chain.originators();
        String user = caller.entity;
        System.out.println(String.format("configurando forward para '%s' por '%s'", to, Utils.chain2str((LoginInfo[])originators, (LoginInfo)caller)));
        this.forwardsOf.put(user, new ForwardInfo(chain, to));
    }

    @Override
    public void cancelForward(String to) {
        LoginInfo caller = this.context.getCallerChain().caller();
        LoginInfo[] originators = this.context.getCallerChain().originators();
        String user = caller.entity;
        ForwardInfo forward = this.forwardsOf.remove(user);
        if (forward != null) {
            System.out.println(String.format("cancelando forward para '%s' por '%s'", forward.to, Utils.chain2str((LoginInfo[])originators, (LoginInfo)caller)));
        }
    }

    @Override
    public String getForward() throws NoForward {
        LoginInfo caller = this.context.getCallerChain().caller();
        String user = caller.entity;
        ForwardInfo forward = this.forwardsOf.get(user);
        if (forward == null) {
            throw new NoForward();
        }
        return forward.to;
    }

    public Map<String, ForwardInfo> getForwardsOf() {
        return this.forwardsOf;
    }

    public static class Timer
    extends Thread {
        private volatile boolean stop = false;
        private ForwarderImpl forwarder;
        private OpenBusContext context;
        private Messenger messenger;

        public Timer(OpenBusContext context, ForwarderImpl forwarder, Messenger messenger) {
            this.forwarder = forwarder;
            this.messenger = messenger;
            this.context = context;
        }

        public void stopTimer() {
            this.stop = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!this.stop) {
                Map<String, ForwardInfo> forwardsOf;
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException e) {
                    this.stop = true;
                }
                Map<String, ForwardInfo> map = forwardsOf = this.forwarder.getForwardsOf();
                synchronized (map) {
                    for (Map.Entry<String, ForwardInfo> entry : forwardsOf.entrySet()) {
                        String user = entry.getKey();
                        ForwardInfo info = entry.getValue();
                        System.out.println("Verificando mensagens de " + user);
                        this.context.joinChain(info.chain);
                        PostDesc[] posts = this.messenger.receivePosts();
                        this.context.exitChain();
                        for (PostDesc post : posts) {
                            this.messenger.post(info.to, String.format("forwarded message by %s:%s", post.from, post.message));
                        }
                    }
                }
            }
        }
    }

    public static class ForwardInfo {
        public CallerChain chain;
        public String to;

        public ForwardInfo(CallerChain chain, String to) {
            this.chain = chain;
            this.to = to;
        }
    }
}

