/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.openbus.interop.delegation;

import java.util.Properties;
import java.util.logging.Level;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAHelper;
import org.omg.PortableServer.Servant;
import scs.core.ComponentContext;
import scs.core.ComponentId;
import scs.core.IComponent;
import tecgraf.openbus.Connection;
import tecgraf.openbus.InvalidLoginCallback;
import tecgraf.openbus.OpenBusContext;
import tecgraf.openbus.PrivateKey;
import tecgraf.openbus.core.ORBInitializer;
import tecgraf.openbus.core.OpenBusPrivateKey;
import tecgraf.openbus.core.v2_0.services.offer_registry.ServiceProperty;
import tecgraf.openbus.interop.delegation.CommonInvalidLoginCallback;
import tecgraf.openbus.interop.delegation.MessengerHelper;
import tecgraf.openbus.interop.delegation.MessengerImpl;
import tecgraf.openbus.interop.util.Utils;

public class MessengerServer {
    public static void main(String[] args) {
        try {
            Properties props = Utils.readPropertyFile((String)"/test.properties");
            String host = props.getProperty("bus.host.name");
            int port = Integer.valueOf(props.getProperty("bus.host.port"));
            String entity = "interop_delegation_java_messenger";
            String privateKeyFile = "admin/InteropDelegation.key";
            OpenBusPrivateKey privateKey = OpenBusPrivateKey.createPrivateKeyFromFile((String)privateKeyFile);
            Utils.setLogLevel((Level)Level.parse(props.getProperty("log.level", "OFF")));
            ORB orb = ORBInitializer.initORB((String[])args);
            new Utils.ORBRunThread(orb).start();
            Runtime.getRuntime().addShutdownHook((Thread)new Utils.ShutdownThread(orb));
            OpenBusContext context = (OpenBusContext)orb.resolve_initial_references("OpenBusContext");
            Connection conn = context.createConnection(host, port);
            context.setDefaultConnection(conn);
            conn.loginByCertificate(entity, (PrivateKey)privateKey);
            POA poa1 = POAHelper.narrow((Object)orb.resolve_initial_references("RootPOA"));
            poa1.the_POAManager().activate();
            ComponentContext ctx = new ComponentContext(orb, poa1, new ComponentId("Messenger", 1, 0, 0, "java"));
            ctx.addFacet("messenger", MessengerHelper.id(), (Servant)new MessengerImpl(context));
            ServiceProperty[] serviceProperties = new ServiceProperty[]{new ServiceProperty("offer.domain", "Interoperability Tests")};
            IComponent ic = ctx.getIComponent();
            context.getOfferRegistry().registerService(ctx.getIComponent(), serviceProperties);
            conn.onInvalidLoginCallback((InvalidLoginCallback)new CommonInvalidLoginCallback(entity, (PrivateKey)privateKey, ic, serviceProperties));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

