/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.openbus.interop.sharedauth;

import java.io.File;
import java.io.FileOutputStream;
import java.util.Properties;
import java.util.logging.Level;
import org.omg.CORBA.Any;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import tecgraf.openbus.Connection;
import tecgraf.openbus.OpenBusContext;
import tecgraf.openbus.core.ORBInitializer;
import tecgraf.openbus.core.v2_0.OctetSeqHolder;
import tecgraf.openbus.core.v2_0.services.access_control.LoginProcess;
import tecgraf.openbus.core.v2_0.services.offer_registry.ServiceOfferDesc;
import tecgraf.openbus.core.v2_0.services.offer_registry.ServiceProperty;
import tecgraf.openbus.interop.sharedauth.EncodedSharedAuth;
import tecgraf.openbus.interop.sharedauth.EncodedSharedAuthHelper;
import tecgraf.openbus.interop.simple.Hello;
import tecgraf.openbus.interop.simple.HelloHelper;
import tecgraf.openbus.interop.util.Utils;
import tecgraf.openbus.security.Cryptography;

public final class Client {
    public static void main(String[] args) {
        try {
            Properties props = Utils.readPropertyFile((String)"/test.properties");
            String host = props.getProperty("bus.host.name");
            int port = Integer.valueOf(props.getProperty("bus.host.port"));
            String entity = "interop_sharedauth_java_client";
            Utils.setLogLevel((Level)Level.parse(props.getProperty("log.level", "OFF")));
            ORB orb = ORBInitializer.initORB();
            OpenBusContext context = (OpenBusContext)orb.resolve_initial_references("OpenBusContext");
            Connection connection = context.createConnection(host, port);
            context.setDefaultConnection(connection);
            connection.loginByPassword(entity, entity.getBytes(Cryptography.CHARSET));
            OctetSeqHolder secret = new OctetSeqHolder();
            LoginProcess process = connection.startSharedAuth(secret);
            EncodedSharedAuth data = new EncodedSharedAuth((Object)process, secret.value);
            Any any = orb.create_any();
            EncodedSharedAuthHelper.insert(any, data);
            byte[] encoded = Utils.getCodec((ORB)orb).encode_value(any);
            File file = new File("sharedauth.dat");
            FileOutputStream fstream = new FileOutputStream(file);
            fstream.write(encoded);
            fstream.close();
            ServiceProperty[] serviceProperties = new ServiceProperty[]{new ServiceProperty("openbus.component.interface", HelloHelper.id()), new ServiceProperty("offer.domain", "Interoperability Tests")};
            ServiceOfferDesc[] services = context.getOfferRegistry().findServices(serviceProperties);
            if (services.length < 1) {
                System.err.println("O servidor do demo Hello n\u00e3o foi encontrado");
                connection.logout();
                System.exit(1);
            }
            if (services.length > 1) {
                System.out.println("Foram encontrados v\u00e1rios servidores do demo Hello");
            }
            for (ServiceOfferDesc offerDesc : services) {
                String sayHello;
                Object helloObj = offerDesc.service_ref.getFacetByName("Hello");
                if (helloObj == null) {
                    System.out.println("N\u00e3o foi poss\u00edvel encontrar uma faceta com esse nome.");
                    continue;
                }
                Hello hello = HelloHelper.narrow(helloObj);
                if (hello == null) {
                    System.out.println("Faceta encontrada n\u00e3o implementa Hello.");
                    continue;
                }
                String expected = "Hello " + entity + "!";
                if (expected.equals(sayHello = hello.sayHello())) {
                    System.out.println("Received: " + sayHello);
                    continue;
                }
                System.err.println("ERROR!");
                System.err.println("Expected: " + expected);
                System.err.println("Received: " + sayHello);
            }
            connection.logout();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

