/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.openbus.interop.util;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.omg.CORBA.ORB;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;
import org.omg.IOP.Codec;
import org.omg.IOP.CodecFactory;
import org.omg.IOP.CodecFactoryHelper;
import org.omg.IOP.CodecFactoryPackage.UnknownEncoding;
import org.omg.IOP.Encoding;
import tecgraf.openbus.Connection;
import tecgraf.openbus.core.v2_0.services.ServiceFailure;
import tecgraf.openbus.core.v2_0.services.access_control.LoginInfo;
import tecgraf.openbus.core.v2_0.services.offer_registry.ServiceOffer;
import tecgraf.openbus.core.v2_0.services.offer_registry.ServiceProperty;

public class Utils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties readPropertyFile(String fileName) throws IOException {
        Properties properties = new Properties();
        InputStream propertiesStream = Utils.class.getResourceAsStream(fileName);
        if (propertiesStream == null) {
            throw new FileNotFoundException(String.format("O arquivo de propriedades '%s' n\u00e3o foi encontrado", fileName));
        }
        try {
            properties.load(propertiesStream);
        }
        finally {
            try {
                propertiesStream.close();
            }
            catch (IOException e) {
                System.err.println("Ocorreu um erro ao fechar o arquivo de propriedades");
                e.printStackTrace();
            }
        }
        return properties;
    }

    public static String findProperty(ServiceProperty[] props, String key) {
        for (int i = 0; i < props.length; ++i) {
            ServiceProperty property = props[i];
            if (!property.name.equals(key)) continue;
            return property.value;
        }
        return null;
    }

    public static String chain2str(LoginInfo[] callers, LoginInfo caller) {
        StringBuffer buffer = new StringBuffer();
        for (LoginInfo loginInfo : callers) {
            buffer.append(loginInfo.entity);
            buffer.append("->");
        }
        buffer.append(caller.entity);
        return buffer.toString();
    }

    public static Codec getCodec(ORB orb) throws UnknownEncoding, InvalidName {
        Object obj = orb.resolve_initial_references("CodecFactory");
        CodecFactory codecFactory = CodecFactoryHelper.narrow((Object)obj);
        byte major = 1;
        byte minor = 2;
        Encoding encoding = new Encoding(0, major, minor);
        return codecFactory.create_codec(encoding);
    }

    public static void setLogLevel(Level level) {
        Logger logger = Logger.getLogger("tecgraf.openbus");
        logger.setLevel(level);
        logger.setUseParentHandlers(false);
        ConsoleHandler handler = new ConsoleHandler();
        handler.setLevel(level);
        logger.addHandler(handler);
    }

    public static class ShutdownThread
    extends Thread {
        private ORB orb;
        private List<Connection> conns = new ArrayList<Connection>();
        private List<ServiceOffer> offers = new ArrayList<ServiceOffer>();

        public ShutdownThread(ORB orb) {
            this.orb = orb;
        }

        @Override
        public void run() {
            for (ServiceOffer offer : this.offers) {
                try {
                    offer.remove();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            for (Connection conn : this.conns) {
                try {
                    conn.logout();
                }
                catch (ServiceFailure e) {
                    e.printStackTrace();
                }
            }
            this.orb.shutdown(true);
            this.orb.destroy();
        }

        public void addConnetion(Connection conn) {
            this.conns.add(conn);
        }

        public void removeConnetion(Connection conn) {
            this.conns.remove(conn);
        }

        public void addOffer(ServiceOffer offer) {
            this.offers.add(offer);
        }

        public void removeOffer(ServiceOffer offer) {
            this.offers.remove(offer);
        }
    }

    public static class ORBRunThread
    extends Thread {
        private ORB orb;

        public ORBRunThread(ORB orb) {
            this.orb = orb;
        }

        @Override
        public void run() {
            this.orb.run();
        }
    }
}

