/*
 * $Id$
 */
package csbase.client.algorithms.commands;

/**
 * O observador local de comandos.
 */
public interface CommandListener {

  /**
   * Indica que houve falha na inicializao do comando.
   * 
   * @param commandId O identificador do comando (No aceita {@code null}).
   */
  void initFailure(String commandId);

  /**
   * Indica que a execuo do comando foi abortada.
   * 
   * @param commandId O identificador do comando (No aceita {@code null}).
   */
  void wasKilled(String commandId);

  /**
   * Indica que as informaes do comando se perderam.
   * 
   * @param commandId O identificador do comando (No aceita {@code null}).
   */
  void wasLost(String commandId);

  /**
   * Indica que a execuo do comando terminou (no se sabe como).
   * 
   * @param commandId O identificador do comando (No aceita {@code null}).
   */
  void wasCompleted(String commandId);

  /**
   * Indica que a execuo do comando terminou (com erro).
   * 
   * @param commandId O identificador do comando (No aceita {@code null}).
   */
  void executionFailure(String commandId);

  /**
   * Indica que a execuo do comando terminou (com sucesso).
   * 
   * @param commandId O identificador do comando (No aceita {@code null}).
   */
  void executionSucceded(String commandId);

  /**
   * Indica que a execuo do comando terminou, mas no foi possvel obter o
   * cdigo de retorno.
   * 
   * @param commandId O identificador do comando (No aceita {@code null}).
   */
  void noExitCode(String commandId);

}
