package csbase.client.algorithms.commands.newview;

import tecgraf.javautils.configurationmanager.ConfigurationManager;

/**
 * Tipo de visualizao de comando que pode ser apresentada, dependendo da
 * natureza do seu configurador.
 */
enum CommandViewType {
  /**
   * Viso de um algoritmo simples.
   */
  SIMPLE,
  /**
   * Viso de um fluxo.
   */
  FLOW,
  /**
   * Viso de um n de um fluxo.
   */
  NODE,
  /**
   * Viso de erro no carregamento das informaes do comando.
   */
  ERROR;

  /**
   * Nome da propriedade do {@link ConfigurationManager} que configura o padro
   * de nome do arquivo de log para cada tipo de viso.
   * 
   * @return O nome da propriedade.
   */
  public String getPropertyName() {
    switch (this) {
      case SIMPLE:
        return "simple";
      case FLOW:
        return "flow";
      case NODE:
        return "node";
      default:
        return "";
    }
  }
}