package csbase.client.algorithms.commands.newview;

import java.awt.Component;
import java.awt.GridBagLayout;

import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingConstants;
import javax.swing.border.Border;
import javax.swing.border.EtchedBorder;

import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.GBC;
import tecgraf.javautils.gui.StatusBar;
import csbase.client.algorithms.commands.cache.events.CommandUpdatedEvent.Type;
import csbase.client.applications.flowapplication.graph.GraphImages;
import csbase.client.desktop.DesktopComponentFrame;
import csbase.client.kernel.ClientException;
import csbase.client.util.gui.log.tab.Tab;
import csbase.client.util.gui.log.tab.AbstractTab.TabType;
import csbase.client.util.svgpanel.SVGPanel;
import csbase.logic.CommandInfo;

/**
 * Viso para os casos de erro no carregamento das informaes do comando.
 */
public class ErrorView implements CommandView {

  /**
   * Mensagem de erro.
   */
  private String errorMessage;

  /**
   * Construtor.
   * 
   * @param errorMessage mensagem de erro.
   */
  public ErrorView(String errorMessage) {
    this.errorMessage = errorMessage;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String getTitle() {
    return LNG.get(ErrorView.class.getSimpleName() + ".window.title");
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void selectTab(TabType tabType) throws ClientException {
    // No h abas.
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void selectTab(String title) throws ClientException {
    // No h abas.
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Tab getSelected() {
    return null;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Component getMainComponent(DesktopComponentFrame owner)
    throws ClientException {
    SVGPanel svgPanel = new SVGPanel();
    svgPanel.setImage(GraphImages.ICON_MISSING);
    svgPanel.setVerticalAligment(SVGPanel.VerticalAlignment.BOTTOM);
    svgPanel.setHorizontalAligment(SVGPanel.HorizontalAlignment.CENTER);

    JLabel errorLabel = new JLabel(errorMessage, SwingConstants.CENTER);

    JPanel panel = new JPanel(new GridBagLayout());
    Border border = BorderFactory.createEtchedBorder(EtchedBorder.LOWERED);
    panel.setBorder(border);
    GBC gbc = new GBC(0, 0).both().weights(1.0, 1.0);
    panel.add(new JPanel(), new GBC(gbc).gridy(1));
    panel.add(svgPanel, new GBC(gbc).gridy(2));
    panel.add(errorLabel, new GBC(gbc).gridy(3).center());
    panel.add(new JPanel(), new GBC(gbc).gridy(4));
    return panel;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void commandUpdated(Type type, CommandInfo cmd) {
    // ignora o evento.
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public StatusBar getStatusBar() {
    return null;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void selectPreferredTab() throws ClientException {
    // No h abas.
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void close() {
    // No h o que fazer.
  }

}
