package csbase.client.algorithms.parameters;

import java.awt.Window;

import javax.swing.JComponent;
import javax.swing.JTextField;

import csbase.logic.algorithms.parameters.IntegerParameter;

/**
 * Viso para o {@link IntegerParameter Parmetro do Tipo Inteiro}.
 *
 * @author lmoreira
 */
public final class IntegerParameterView extends SimpleParameterView<Integer> {

  /**
   * Cria uma viso em modo {@link ParameterView.Mode#CONFIGURATION}.
   *
   * @param window NO EST SENDO UTILIZADO. Existe somente para manter
   *        compatibilidade com o WebSintesi.
   * @param parameter O parmetro (No aceita {@code null}).
   *
   * @deprecated para manter compatibilidade com o WebSintesi
   */
  @Deprecated
  public IntegerParameterView(Window window, IntegerParameter parameter) {
    this(parameter, Mode.CONFIGURATION);
  }

  /**
   * Cria a viso.
   *
   * @param parameter O parmetro que  manipulado por esta viso (No aceita
   * @param mode Modo de visualizao. No aceita {@code null}, os possveis
   *        valores so: {@link ParameterView.Mode#CONFIGURATION} ou
   *        {@code null}). {@link ParameterView.Mode#REPORT}.
   */
  public IntegerParameterView(IntegerParameter parameter, Mode mode) {
    super(parameter, mode);
    updateCapabilityView();
    updateVisibilyView();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public IntegerParameter getParameter() {
    return (IntegerParameter) super.getParameter();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected JComponent createConfigurationComponent(Object... componentArgs) {
    return new IntegerConfigurationParameter();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected JComponent createReportComponent(Object... componentArgs) {
    return new IntegerReportParameter();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void updateViewContents() {
    ((IIntegerParameterComponent) getComponent()).updateViewContents();
  }

  /**
   * Interface comum s diferentes vises do parmetro.
   */
  private interface IIntegerParameterComponent {
    /**
     * Atualiza o contedo exibido pela viso.
     */
    void updateViewContents();
  }

  /**
   * Viso do parmetro em modo {@link ParameterView.Mode#REPORT}.
   */
  private final class IntegerReportParameter extends JTextField implements
    IIntegerParameterComponent {

    /**
     * Construtor.
     */
    IntegerReportParameter() {
      setToolTipText(getParameter().getDescription());
      ComponentProperties.setProperties(this, Mode.REPORT, true);
      super.setEditable(false);
      updateViewContents();
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public void updateViewContents() {
      IntegerParameter parameter = getParameter();
      Integer value = parameter.getValue();
      if (value == null || value == IntegerParameter.ERROR_VALUE) {
        setText("");
      }
      else {
        setText(value.toString());
      }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public void setEditable(boolean enable) {
      // Este mtodo no faz nada por que este componente no pode ser editvel.
    }
  }

  /**
   * Viso do parmetro em modo {@link ParameterView.Mode#CONFIGURATION}.
   */
  private final class IntegerConfigurationParameter extends IntegerTextField
    implements IIntegerParameterComponent {

    /**
     * Construtor.
     */
    IntegerConfigurationParameter() {
      super(new AbstractNumberTextFieldModel<Integer>(
        IntegerParameter.ERROR_VALUE) {
        @Override
        public void setValue(Integer value) {
          getParameter().setValue(value);
          fireChangedValue();
        }

        @Override
        public Integer getValue() {
          return getParameter().getValue();
        }
      });

      setToolTipText(getParameter().getDescription());
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public void updateViewContents() {
      updateView();
    }
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public boolean fillVerticalSpace() {
    return false;
  }
}
