/*
 * $Author:$ $Date:$ $Release:$
 */
package csbase.client.algorithms.parameters;

import java.awt.Color;
import java.awt.Window;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;

import javax.swing.JComponent;
import javax.swing.JTextField;

import csbase.logic.algorithms.parameters.TextParameter;
import csbase.logic.algorithms.parameters.TextParameterListener;

/**
 * Viso para o {@link TextParameter Parmetro do Tipo Texto}.
 * 
 * @author lmoreira
 */
public final class TextParameterView extends SimpleParameterView<String> {

  /**
   * Cria uma viso em modo {@link ParameterView.Mode#CONFIGURATION}.
   * 
   * @param window NO EST SENDO UTILIZADO. Existe somente para manter
   *        compatibilidade com o WebSintesi.
   * @param parameter O parmetro (No aceita {@code null}).
   * 
   * @deprecated para manter compatibilidade com o WebSintesi
   */
  @Deprecated
  public TextParameterView(Window window, TextParameter parameter) {
    this(parameter, Mode.CONFIGURATION);
  }

  /**
   * Cria uma viso.
   * 
   * @param parameter O parmetro (No aceita {@code null}).
   * @param mode Modo de visualizao. No aceita {@code null}, os possveis
   *        valores so: {@link ParameterView.Mode#CONFIGURATION} ou
   *        {@link ParameterView.Mode#REPORT}.
   */
  public TextParameterView(TextParameter parameter, Mode mode) {
    super(parameter, mode);

    updateCapabilityView();
    updateVisibilyView();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public TextParameter getParameter() {
    return (TextParameter) super.getParameter();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected JComponent createConfigurationComponent(Object... componentArgs) {
    return new TextConfigurationParameter();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected JComponent createReportComponent(Object... componentArgs) {
    return new TextReportParameter();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void updateViewContents() {
    ((ITextParameterComponent) getComponent()).updateViewContents();
  }

  /**
   * Interface comum s diferentes vises do parmetro.
   */
  private interface ITextParameterComponent {
    /**
     * Atualiza o contedo exibido pela viso.
     */
    void updateViewContents();
  }

  /**
   * Viso do parmetro em modo {@link ParameterView.Mode#REPORT}.
   */
  private final class TextReportParameter extends JTextField implements
    ITextParameterComponent {

    /**
     * Construtor.
     */
    TextReportParameter() {
      setToolTipText(getParameter().getDescription());
      ComponentProperties.setProperties(this, Mode.REPORT, true);
      super.setEditable(false);
      updateViewContents();
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public void updateViewContents() {
      String value = getParameter().getValue();
      setText(null == value ? " " : value);
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public void setEditable(boolean enable) {
      // Este mtodo no faz nada por que este componente no pode ser editvel.
    }
  }

  /**
   * Viso do parmetro em modo {@link ParameterView.Mode#CONFIGURATION}.
   */
  private final class TextConfigurationParameter extends JTextField implements
    ITextParameterComponent {

    /**
     * Cor de fundo para um parmetro no-editvel.
     */
    private final Color DISABLED_BACKGROUND_COLOR = Color.LIGHT_GRAY;

    /**
     * Cor de fundo padro.
     */
    private Color defaultBackgroundColor;

    /**
     * Construtor.
     */
    TextConfigurationParameter() {
      this.defaultBackgroundColor = getBackground();
      addFocusListener(new FocusListener() {
        @Override
        public void focusLost(FocusEvent e) {
          updateModel();
        }

        @Override
        public void focusGained(FocusEvent e) {
          // Ignora esse evento.
        }
      });
      setToolTipText(getParameter().getDescription());

      updateViewContents();
      updateEditabilityView();
      getParameter().addTextParameterListener(new TextParameterListener() {
        @Override
        public void editabilityWasChanged(TextParameter parameter) {
          updateEditabilityView();
        }
      });
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public void updateViewContents() {
      String value = getParameter().getValue();
      setText(null == value ? "" : value);
    }

    /**
     * Atualiza o estado Proibir/Permitir Edio da viso de acordo com o
     * parmetro.
     */
    private void updateEditabilityView() {
      boolean isEditable = getParameter().isEditable();
      setEditable(isEditable);
      if (isEditable) {
        setBackground(defaultBackgroundColor);
      }
      else {
        setBackground(DISABLED_BACKGROUND_COLOR);
      }
    }

    /**
     * Atualiza o modelo (L informaes da viso e atrubui a informao ao
     * parmetro).
     */
    private void updateModel() {
      String text = getText();
      if (text.length() == 0) {
        getParameter().setValue(null);
      }
      else {
        getParameter().setValue(text);
      }
    }
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public boolean fillVerticalSpace() {
    return false;
  }
}
