/*
 * $Id$
 */

package csbase.client.applications;

import java.awt.event.ActionEvent;

/**
 * Ao genrica de exibio de about.
 * 
 * @author Tecgraf/PUC-Rio
 */
public class ApplicationAboutAction extends
  ApplicationStandardAction<Application> {

  /**
   * {@inheritDoc}
   */
  @Override
  public void actionPerformed(final ActionEvent ae) {
    final Application application = getApplication();
    final String authorName = application.getAuthorName();
    final String authorMail = application.getAuthorMail();
    final String versionNumber = application.getVersion();
    final String name = application.getName();
    final String description = application.getDescription();
    final String msg =
      name + "\n" + description + "\n\n" + authorName + "\n" + authorMail
        + "\n" + versionNumber;
    application.showInformation(application.getApplicationFrame(), msg);
  }

  /**
   * Construtor padro.
   * 
   * @param application a aplicao
   */
  public ApplicationAboutAction(final Application application) {
    super(application);
    putValue(SMALL_ICON, ApplicationImages.ICON_ABOUT_16);
  }
}
